% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rdca_package.R
\name{decline_fit}
\alias{decline_fit}
\title{Arps decline_fit prediction}
\usage{
decline_fit(decline_fit_lst, time_lst)
}
\arguments{
\item{decline_fit_lst}{a list object of class 'decline_fit'}

\item{time_lst}{a list object of class 'time'}
}
\value{
a list of estimates for the parameters of the Arps model according to the class of 'decline_fit_lst' and 'time_lst' objects
}
\description{
Generate a list of estimates for the Arps decline model according to the class of 'decline_fit_lst' and 'time_lst' objects
}
\examples{
dcl_time_hyp <- decline_time(1:10000, unit = "day")
prod_data <- 4500 / (1 + 0.002 * 0.834 * dcl_time_hyp$t) ^ (1 / 0.834)
dcl_fit_param_hyp <- decline_fit_param(input_unit = "Field", output_unit = "Field",
fluid = "gas", model = "hyperbolic", fit_data = "rate", prod_data = prod_data,
initial_param = c(1000, 0.01, 1.0), lower = c(0, 1e-6, 1e-6), upper = NULL,
control = list(maxiter = 100))
dcl_fit_hyp <- decline_fit(dcl_fit_param_hyp, dcl_time_hyp)

dcl_fit_hyp

}
