% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/BSGD.R
\name{SharkBSGDPredict}
\alias{SharkBSGDPredict}
\title{Budgeted SGD Predict.}
\usage{
SharkBSGDPredict(x, model, verbose = FALSE)
}
\arguments{
\item{x}{matrix with input data}

\item{model}{a model trained with BSGD Train}

\item{verbose}{verbose output?}
}
\description{
This will do prediction with a support vector machine trained by BSGD.
See more on http://image.diku.dk/shark/sphinx_pages/build/html/rest_sources/tutorials/algorithms/kernelBudgetedSGD.html
}
\note{
Currently works only for binary classification. Uses only RBF kernel.
}
\examples{
x = as.matrix(iris[,1:4])
		y = as.vector(as.numeric(iris[,5]))
		y = replace(y, y == 2, 0)
		y = replace(y, y == 3, 0)
		model = SharkBSGDTrain (x, y, C = 0.0001,
		      budget = 5, gamma = 1, epochs = 1, strategy = "Merge")
		results = SharkBSGDPredict (x, model)
		cat ("BSGD training error is ", sum(abs(y - results$predictions))/length(y), "\\n")
}

