% Generated by roxygen2 (4.1.1): do not edit by hand
\docType{data}
\name{.O}
\alias{$,Octave-method}
\alias{$<-,Octave-method}
\alias{.O}
\alias{[[,Octave-method}
\alias{show,Octave-method}
\title{Direct Interface to Octave}
\format{\code{.O} is an object of class \code{\linkS4class{Octave}}.}
\usage{
.O

\S4method{$}{Octave}(x, name)

\S4method{$}{Octave}(x, name) <- value

\S4method{[[}{Octave}(x, i, exact = TRUE)
}
\arguments{
  \item{x}{an \code{OctaveInterface} object. Essentially used with \code{x = .O}.}

  \item{name}{name of the Octave obj	ect to retrieve or assign.}

  \item{value}{value to assign to the Octave object.}

  \item{i}{name of the Octave object to retrieve.}

  \item{exact}{logical not used.}
}
\description{
  \code{RcppOctave} provides a simple interface to Octave via the
object \code{.O}, an instance of class \code{Octave}, that allows for direct access
to Octave functions and variables using calls such as: \code{.O$svd(matrix(1:9,3))}.

The method \code{$} provides a direct way of calling Octave functions or
retrieving variables from Octave base context, via e.g. \code{.O$svd(x)}
or \code{.O$a}.
It is equivalent to \code{o_get(name)}.

The method \code{$<-} allow to directly assign/set Octave variables via e.g.
\code{.O$a <- 10}.

The method \code{[[} provides an alternative way of retrieving Octave objects,
and is equivalent to \code{o_get(name)}.
}
\examples{
\dontshow{# roxygen generated flag
options(R_CHECK_RUNNING_EXAMPLES_=TRUE)
}

.O
# assign/get Octave variables
.O$a <- 10
.O$a

# call Octave functions
.O$help()
.O$svd(matrix(runif(9), 3))
}
\seealso{
  \code{\link{o_get}}

\code{\link{o_get}}
}
\keyword{datasets}

