//=================================================================================================
/*!
//  \file blaze/system/BLAS.h
//  \brief System settings for the BLAS mode
//
//  Copyright (C) 2013 Klaus Iglberger - All Rights Reserved
//
#  This file is part of the Blaze library. You can redistribute it and/or modify it under
#  the terms of the New (Revised) BSD License. Redistribution and use in source and binary
#  forms, with or without modification, are permitted provided that the following conditions
#  are met:
#
#  1. Redistributions of source code must retain the above copyright notice, this list of
#     conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright notice, this list
#     of conditions and the following disclaimer in the documentation and/or other materials
#     provided with the distribution.
#  3. Neither the names of the Blaze development group nor the names of its contributors
#     may be used to endorse or promote products derived from this software without specific
#     prior written permission.
#
#  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
#  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
#  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
#  SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
#  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
#  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
#  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
#  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
#  ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
#  DAMAGE.
*/
//=================================================================================================

#ifndef _BLAZE_SYSTEM_BLAS_H_
#define _BLAZE_SYSTEM_BLAS_H_


//=================================================================================================
//
//  BLAS MODE CONFIGURATION
//
//=================================================================================================

//*************************************************************************************************
/*!\brief Compilation switch for the BLAS mode.
// \ingroup system
//
// This compilation switch enables/disables the BLAS mode. In case the BLAS mode is enabled,
// several basic linear algebra functions (such as for instance matrix-matrix multiplications
// between two dense matrices) are handled by performance optimized BLAS functions. Note that
// in this case it is mandatory to provide the according BLAS header file for the compilation
// of the Blaze library. In case the BLAS mode is disabled, all linear algebra functions use
// the default implementations of the Blaze library and therefore BLAS is not a requirement
// for the compilation process.
//
// Possible settings for the BLAS switch:
//  - Deactivated: \b 0
//  - Activated  : \b 1
//
// Note that changing the setting of the BLAS mode requires a recompilation of the Blaze
// library. Also note that this switch is automatically set by the configuration script of
// the Blaze library.
*/
#define BLAZE_BLAS_MODE 0
//*************************************************************************************************


//*************************************************************************************************
/*!\brief Compilation switch for the parallel BLAS mode.
// \ingroup system
//
// This compilation switch specifies whether the used BLAS library is itself parallelized or not.
// In case the given BLAS library is itself parallelized, the Blaze library does not perform any
// attempt to parallelize the execution of BLAS kernels. If, however, the given BLAS library is
// not parallelized Blaze will attempt to parallelize the execution of BLAS kernels.
//
// Possible settings for the switch:
//  - BLAS library is not parallelized: \b 0
//  - BLAS library is parallelized    : \b 1
//
// Note that changing the setting of the BLAS mode requires a recompilation of the Blaze library.
// Also note that this switch is automatically set by the configuration script of the Blaze
// library.
*/
#define BLAZE_BLAS_IS_PARALLEL 0
//*************************************************************************************************

#endif
