#!/usr/bin/r -t
#
# Copyright (C) 2018 Keith O'Hara and Dirk Eddelbuettel
#
# This file is part of RcppArmadillo.
#
# RcppArmadillo is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
#
# RcppArmadillo is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with RcppArmadillo.  If not, see <http://www.gnu.org/licenses/>.

.setUp <- RcppArmadillo:::unit_test_setup("Rlapack.cpp")

test.Rlapack <- function() {

    set.seed(123)

    ## create variables

    n <- 5 # size the of matrices generated in tests

    ## Basic operations

    rl1 <- norm(cx_eig_pair_test(n),"2") 
    rl2 <- norm(cx_qz_test(n),"2")
    rl3 <- cx_rank_test(n)                # should equal n
    rl4 <- norm(cx_solve_test(n),"2")
    rl5 <- norm(cx_pinv_test(n),"2")      # should be (approx) an identity matrix
    rl6 <- norm(cx_schur_test(n),"2")

    checkEquals(rl1,  0,  msg="eig_pair for complex matrices")
    checkEquals(rl2,  0,  msg="qz for complex matrices")
    checkEquals(rl3,  n,  msg="rank complex matrices")
    checkEquals(rl4,  0,  msg="solve for complex matrices")
    checkEquals(rl5,  1,  msg="pinv for complex matrices")
    checkEquals(rl6,  0,  msg="schur for complex matrices")
}
