# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' The APT Package Management system uses a data-rich caching
#' structure. This accessor function returns the Build-Depends for
#' a set of packages matching the given regular expression. 
#'
#' Note that the package lookup uses regular expressions. If only a
#' single package is desired, append a single \code{$} to terminate
#' the expression.  \emph{Ie} \code{r-cran-rcpp$} will \emph{not}
#' return results for \code{r-cran-rcpparmadillo} and
#' \code{r-cran-rcppeigen}.
#'
#' @title Return Build-Depends for given packages
#' @param regexp A regular expression for the package name(s) with a
#' default of all (".")
#' @return A character vector containing package names is returned.
#' @author Dirk Eddelbuettel
#' @examples
#' buildDepends("r-cran-rcpp$")
buildDepends <- function(regexp = ".") {
    .Call('RcppAPT_buildDepends', PACKAGE = 'RcppAPT', regexp)
}

#' The APT Package Management system uses a data-rich caching
#' structure. This accessor function displays the information for
#' a set of packages matching the given regular expression. The
#' output corresponds to \code{apt-cache showsrc pkgname}.
#'
#' Note that the package lookup uses regular expressions. If only a
#' single package is desired, append a single \code{$} to terminate
#' the expression.  \emph{Ie} \code{r-cran-rcpp$} will \emph{not}
#' return results for \code{r-cran-rcpparmadillo} and
#' \code{r-cran-rcppeigen}.
#'
#' @title Display information for given packages
#' @param regexp A regular expression for the package name(s) with a
#' default of all (".")
#' @return A boolean is returned indicating whether or not the given
#' regular expression could be matched to source packages -- but the
#' function is invoked ' for the side effect of displaying information.
#' @author Dirk Eddelbuettel
#' @examples
#' showSrc("^r-(base|doc)-")
#' showSrc("r-cran-rcpp")  # also finds RcppEigen and RcppArmadillo
#' showSrc("r-cran-rcpp$") # just Rcpp
showSrc <- function(regexp = ".") {
    .Call('RcppAPT_showSrc', PACKAGE = 'RcppAPT', regexp)
}

#' The APT Package Management system uses a data-rich caching
#' structure. This accessor function displays the information for
#' a set of packages matching the given regular expression. It
#' corresponds somewhat to \code{apt-cache showpkg pkgname} but
#' displays more information.
#'
#' Note that the package lookup uses regular expressions. If only a
#' single package is desired, append a single \code{$} to terminate
#' the expression.  \emph{Ie} \code{r-cran-rcpp$} will \emph{not}
#' return results for \code{r-cran-rcpparmadillo} and
#' \code{r-cran-rcppeigen}.
#'
#' @title Display information for given packages
#' @param regexp A regular expression for the package name(s) with a
#' default of all (".")
#' @return A boolean is returned indicating whether or not the given
#' regular expression could be matched to source packages -- but the
#' function is invoked ' for the side effect of displaying information.
#' @author Dirk Eddelbuettel
#' @examples
#' showSrc("^r-(base|doc)-")
dumpPackages <- function(regexp = ".") {
    .Call('RcppAPT_dumpPackages', PACKAGE = 'RcppAPT', regexp)
}

#' The APT Package Management system uses a data-rich caching
#' structure. This accessor function returns the names of installable
#' packages for a given regular expression.
#'
#' Note that the package lookup uses regular expressions. If only a
#' single package is desired, append a single \code{$} to terminate
#' the expression.  \emph{Ie} \code{r-cran-rcpp$} will \emph{not}
#' return results for \code{r-cran-rcpparmadillo} and
#' \code{r-cran-rcppeigen}.
#' 
#' @title Retrieve Names of All Installable Packages
#' @param regexp A regular expression for the package name(s) with a
#' default of all ("."). 
#' @return A data frame with columns containing the
#' package name, the installed version (or NA if not installed)
#' and the section it is installed in (or NA).
#' @author Dirk Eddelbuettel
#' @examples
#' getPackages("^r-(base|doc)-")
getPackages <- function(regexp = ".") {
    .Call('RcppAPT_getPackages', PACKAGE = 'RcppAPT', regexp)
}

#' The APT Package Management system uses a data-rich caching
#' structure. This accessor function tests whether a given package
#' exists.
#' @title Test for Existence of Given Package
#' @param pkg A character vector with name of the package
#' @return A boolean result vector is returned indicating if the 
#' package at the given position is available.
#' @author Dirk Eddelbuettel
#' @examples
#' hasPackages(c("r-base-core", "somethingThatDoesNotExist"))
hasPackages <- function(pkg) {
    .Call('RcppAPT_hasPackages', PACKAGE = 'RcppAPT', pkg)
}

