\name{Menu.General}
\alias{Menu.General}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{General factorial designs}
\description{This menu covers full factorial designs orthogonal main effects designs 
for cases for which not all factors are at two levels. 
Furthermore, Taguchi-parameter designs are covered. This 
help file is about how and when to apply these.}
%- maybe also 'usage' for other objects documented here.
\section{Quantitative or Qualitative}{
Both types of design are suitable for quantitative and qualitative factors alike. 
If you have quantitative factors only, you may want to consider the special menu for these.
}
\section{Full factorial designs}{
Full factorial designs are straight-forward to generate and are generated by 
function \code{\link[DoE.base]{fac.design}} from package \pkg{DoE.base}. The 
number of runs needed for a full factorial experiment is the product of the numbers 
of levels of all factors. This may be more than is feasible. In such situations, the 
orthogonal main effects plans may be helpful. If interactions are also of interest, 
it may be useful to combine several plans or to pay attention to specific properties of 
orthogonal arrays (automatic support for such possibilities is currently poor and will be improved 
in the future).\cr 
Full factorial designs can be run in blocks. This is advisable, whenever the experimental 
units are not homogeneous, but smaller groups of units (the blocks) can be made 
reasonably homogeneous (e.g., batches of material, etc.). }
\section{Orthogonal main effects plans}{
If a full factorial experiment is too large, an orthogonal main effects plan may be useful. 
As long as there are no interactions between the factors represented by columns of the array, 
all such arrays work well, provided they are large enough for stable estimation. Some arrays also 
work well in the presence of interactions or even allow estimation of interactions for special subsets 
of variables. However, there is no automated support for selection of an array that 
has desirable properties. It may therefore be useful to specifically select an array 
the properties of which are known to the experimenter.}
\section{Warning}{Important: For all factorial designs, 
the experiment must conduct all experimental runs as determined in the design, 
because the design properties will deteriorate in ways not easily foreseeable, 
if some combinations are omitted. 

It must be carefully considered in the planning phase, whether it is 
possible to conduct all experimental runs, or whether there might be restrictions 
that do not permit all combinations to be run (e.g.: three factors, each with levels 
\dQuote{small} and \dQuote{large}, where the combination with all three factors 
at level \dQuote{large} is not doable because of space restrictions). 
If such restrictions are encountered, the design should be devised in a different way from the beginning. 
If possible, reasonable adjustments to levels should ensure that a factorial design 
becomes feasible again. Alternatively, a non-orthogonal D-optimal design can take 
the restrictions into account. \emph{Unfortunately, this functionality is not yet implemented in this GUI.}
}
\section{Taguchi inner-outer array designs - also called parameter designs}{
  With the menu item \emph{Create Taguchi inner-outer array}, two \bold{existing} designs 
  can be combined into a crossed inner-outer array design. For more detail, see the 
  literature and the help in the Taguchi design menu.}

\references{ 
    Box G. E. P, Hunter, W. C. and Hunter, J. S. (2005) 
    \emph{Statistics for Experimenters, 2nd edition}.
    New York: Wiley.
 }
\author{ Ulrike Groemping }
\seealso{ See Also \code{\link[FrF2]{pb}} for the function behind the screening designs, 
\code{\link[FrF2]{FrF2}} for the function behind the regular fractional factorial designs, 
and \code{\link[FrF2:CatalogueAccessors]{catlg}} for a catalogue of regular fractional factorial designs, 
and \code{\link{DoEGlossary}} for a glossary of terms relevant in connection with 
orthogonal 2-level factorial designs. 
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ design }
\keyword{ array }% __ONLY ONE__ keyword per line
