% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleCompute.R
\name{computeSampling}
\alias{computeSampling}
\title{Sampling raw data matrix}
\usage{
computeSampling(x, label = NULL, K = 0, toKeep = NULL,
  sampling.size.max = 3000, K.max = 20, kmeans.variance.min = 0.95)
}
\arguments{
\item{x}{matrix of raw data (point by line).}

\item{label}{vector of (named) labels.}

\item{K}{number of clusters. If K=0 (default), this number is automatically computed thanks to the Elbow method.}

\item{toKeep}{vector of row.names to keep in the sample (for constrained algorithms).}

\item{sampling.size.max}{maximal number of observations to keep in the sample.}

\item{K.max}{maximal number of clusters (K.Max=20 by default).}

\item{kmeans.variance.min}{elbow method cumulative explained variance > criteria to stop K-search.}
}
\value{
The function returns a list containing:
\item{selection.ids}{vector of selected row.names in the sample.}
\item{selection.labs}{vector of selected labels in the sample.}
\item{matching}{character specifying the matching for all observations and used for generalization of the clustering result.}
\item{size.max}{maximal number of observations kept in the sample.}
\item{K}{number of clusters.}
}
\description{
computes sampling on raw data matrix to reduce the number of observations, with generalization step.
}
\details{
computeSampling computes sampling on raw data matrix to reduce the number of observations, with generalization step.
}
\examples{
dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))
tf <- tempfile()
write.table(dat, tf, sep=",", dec=".")
x <- importSample(file.features=tf, dir.save=tempdir())

res.sampling <- computeSampling(x$features$initial$x)


}
\keyword{internal}
