% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{RblParse}
\alias{RblParse}
\title{Parse Bloomberg response file and fetch data}
\usage{
RblParse(file, auto.assign = FALSE, env = parent.frame(),
  verbose = TRUE)
}
\arguments{
\item{file}{character string representing the local file to parse (see \code{\link{RblDownload}})}

\item{auto.assign}{logical. Should results be loaded to env when using PROGRAMNAME=gethistory?}

\item{env}{where to create objects if auto.assign = TRUE}

\item{verbose}{logical. Should R report extra information on progress?}
}
\value{
\describe{
 \item{PROGRAMNAME=getdata}{data.frame containig identifiers (rows) and fields (columns). NULL on failure.}
 \item{PROGRAMNAME=gethistory}{list of xts objects. If \emph{auto.assign}=TRUE the xts objects are loaded in \emph{env} and the object names are returned. NULL on failure.}
}
}
\description{
Parse Bloomberg response file. The PROGRAMNAME in use is auto detected: 'getdata' and 'gethistory' are supported.
}
\examples{
\dontrun{
# Run RblConnect first
RblRequest <- RblRequestBuilder(header = list(FIRMNAME = RblUser(), PROGRAMNAME = 'getdata'), 
                                fields = c('PX_LAST'), identifiers = c('SXXE Index'))
req <- RblUpload(RblRequest)
out <- RblDownload(req$out)
data <- RblParse(d)
data
}

}
