/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.pattern;

import ch.qos.logback.access.pattern.AccessConverter;
import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.core.util.CachingDateFormatter;
import java.util.List;
import java.util.TimeZone;

public class DateConverter
extends AccessConverter {
    CachingDateFormatter cachingDateFormatter = null;

    public void start() {
        String datePattern = this.getFirstOption();
        if (datePattern == null) {
            datePattern = "dd/MM/yyyy:HH:mm:ss Z";
        }
        if (datePattern.equals("ISO8601")) {
            datePattern = "yyyy-MM-dd HH:mm:ss,SSS";
        }
        try {
            this.cachingDateFormatter = new CachingDateFormatter(datePattern);
        }
        catch (IllegalArgumentException e) {
            this.addWarn("Could not instantiate SimpleDateFormat with pattern " + datePattern, e);
            this.cachingDateFormatter = new CachingDateFormatter("dd/MM/yyyy:HH:mm:ss Z");
        }
        List optionList = this.getOptionList();
        if (optionList != null && optionList.size() > 1) {
            TimeZone tz = TimeZone.getTimeZone((String)optionList.get(1));
            this.cachingDateFormatter.setTimeZone(tz);
        }
    }

    public String convert(IAccessEvent accessEvent) {
        long timestamp = accessEvent.getTimeStamp();
        return this.cachingDateFormatter.format(timestamp);
    }
}

