% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_u.R
\name{get_u}
\alias{get_u}
\title{Computation of the coefficients of the PSWF on the Legendre polynomials basis of L^2(-1,1)}
\usage{
get_u(c, N)
}
\arguments{
\item{c}{parameter indexing the functions of the SVD}

\item{N}{maximal index of the functions computed in the SVD}
}
\value{
a list containing, in order:

- ueven : the coefficients of the decomposition of the SVD on the Legendre polynomials for the even functions

- uodd : the coefficients of the decomposition of the SVD on the Legendre polynomials for the odd functions
}
\description{
The matrix ueven has columns u^0,u^2,...,u^{2N}, and the matrix uodd has columns u^1,u^3,...,u^{2N+1}.
Each column has length N+1. Below, note that i must have odd length so that ai and ci have even length and can be split into two subvectors containing alternate entries of ai and ci.
}
\examples{
library(orthopolynom)
library(polynom)
library(tmvtnorm)
library(ks)
library(sfsmisc)
library(snowfall)
library(fourierin)
library(rdetools)
library(statmod)
library(RCEIM)
library(robustbase)
library(VGAM)
library(RandomCoefficients)
#### Number of Psis
L =15
L1 = L+1
N2 = max(L,3)
twoN = 2*N2
#### Bandwidth 1
c1 = 1
K1 = max(twoN+2,30)
K = K1
### get the coefficients beta (for the computation of Psi) of the PSWF on the
### basis of Legendre polynomials.
out <- get_u(c1,N2)

}
