% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/form_sparse_matrix.R
\name{form_sparse_matrix}
\alias{form_sparse_matrix}
\title{Form Sparse Random Matrix}
\usage{
form_sparse_matrix(n_rows, n_cols, JLT, eps = 0.1, method = "achlioptas")
}
\arguments{
\item{n_rows}{- number of rows in the sample}

\item{n_cols}{- number of columns in the sample}

\item{JLT}{- Boolean to set JL transform (TRUE or FALSE)}

\item{eps}{- error tolerance level}

\item{method}{- method to generate projection matrix}
}
\value{
Random Sparse Matrix
}
\description{
The purpose of sparse matrix is to reduce the computational complexity even more when comparing to gaussian matrix.
The sparse matrix can be generated using a simpler approach by filling with zero's or one's to reduce the computation.
This function supports 3 methods that are used to generate the sparse matrix.
}
\details{
The 3 types of methods used in the function are

1. "probability" - In this method, the sparse matrix was generated using the equal probability
distribution with the elements [-1, 1].

2. "achlioptas" - Achlioptas matrix is easy to generate and also the 2/3rd of the matrix was filled
with zero which makes it as more sparse and cut-off the 2/3rd computation.

3. "li" - This method generalizes the achlioptas method and generate very sparse random matrix
 to improve the computational speed up of random projection.
}
\examples{
#load library
library(RandPro)

# Matrix generated with deafult method "achlioptas" without JLT
mat <- form_sparse_matrix(n_rows = 300,n_cols = 1000,JLT = FALSE)

#create matrix with JLT and default method
mat <- form_sparse_matrix(n_rows = 250,n_cols = 1000000,JLT = TRUE,eps = 0.5)

#create matrix with JLT and probability method
mat <- form_sparse_matrix(250,1000000,JLT = TRUE,eps = 0.5,method = "probability")

#create matrix with JLT and li method
mat <- form_sparse_matrix(n_rows = 250,n_cols = 1000000,JLT = TRUE,eps = 0.5,method = "li")

}
\author{
Aghila G

Siddharth R
}
\references{
[1] Ping Li, Trevor J. Hastie, and Kenneth W. Church,  "Very sparse random projections(2006)".

[2] D. Achlioptas, "Database-friendly random projections(2002)"
}
\keyword{Achlioptas,}
\keyword{Dimension_Reduction,}
\keyword{Johnson-Lindenstrauss_Lemma,}
\keyword{Li,}
\keyword{Probability}
\keyword{RandomProjection,}
\keyword{distribution}
\keyword{sparse_matrix,}

