% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StemID.R
\name{compscore}
\alias{compscore}
\title{Compute StemID2 score}
\usage{
compscore(object, nn = 1, scthr = 0, show = TRUE)
}
\arguments{
\item{object}{\code{Ltree} class object.}

\item{nn}{Positive integer number. Number of higher order neighbors to be included for the determination of links: indirect connections via \code{n-1} intermittant
neighbors are allowed. Default is 1.}

\item{scthr}{Real number between zero and one. Score threshold for links to be included in the calculation. For \code{scthr=0} all significant links are included. The
maximum score is one.}

\item{show}{logical. If \code{TRUE}, then plot heatmap of projections. Default is \code{TRUE}.}
}
\value{
A list ot three components:
  \item{links}{a vector with the number of significant links for each cluster.}
  \item{entropy}{a vector with the delta entropy for each cluster.}
  \item{StemIDscore}{a vector with the StemID score for each cluster.}
}
\description{
This function extracts the number of links connecting a given cluster to other cluster, the delta median entropy of each cluster
(median entropy of a cluster after subtracting the minimum median entropy across all clusters), and the StemID2 score which is the product of both quantities for
each cluster.
}
