% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RaceID.R
\name{fractDotPlot}
\alias{fractDotPlot}
\title{Dotplot of gene expression across clusters or samples}
\usage{
fractDotPlot(object, genes, cluster = NULL, samples = NULL, subset = NULL,
  zsc = FALSE, logscale = TRUE, cap = Inf, flo = -Inf)
}
\arguments{
\item{object}{\code{SCseq} class object.}

\item{genes}{vector of valid gene names corresponding to row names of slot \code{ndata}. The expression for this genes is shown.}

\item{cluster}{vector of valid cluster numbers contained in slot \code{cpart}. Default is \code{NULL}. If not given, then the \code{samples} argument is expected.
If both are given, only the \code{samples} argument is considered.}

\item{samples}{vector of sample names for all cells. Length and order has to correspond to \code{colnames} of slot \code{ndata}. Default is \code{NULL}.}

\item{subset}{vector of unique sample names to show in the expression dotplot. Each sample names in \code{subset} has to occur in \code{samples}.
Default is \code{NULL}. If not given and \code{samples} is not \code{NULL}, the subset is intialized with all sample names occuring in \code{samples}.}

\item{zsc}{logical. If \code{TRUE} then a z-score transformation is applied. Default is \code{FALSE}.}

\item{logscale}{logical. If \code{TRUE} then a log2 transformation is applied. Default is \code{TRUE}.}

\item{cap}{real number. Upper limit for the expression, log2 expression, or z-score. Values larges then \code{cap} are replaced by \code{cap}.}

\item{flo}{real number. Lower limit for the expression, log2 expression, or z-score. Values smaller then \code{flo} are replaced by \code{flo}.}
}
\value{
None
}
\description{
This is a plotting function for visualizing gene expression across subsets of clusters or samples. The diameter of a dot reflects the fraction of cells
expressing a gene, and the color indicates the expression z-score across all clusters or samples.
}
