% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnsc.R
\name{cnsc}
\alias{cnsc}
\alias{cnscinfun}
\alias{cnscinfun2}
\title{Conversion of Non-Standard Content into a Character Chain}
\usage{
cnsc(...)

cnscinfun()

cnscinfun2(...)
}
\arguments{
\item{...}{Character vectors, standard or non-standard, existing or non-existing 
R objects, regular call. Examples : \code{"word1"}; \code{c("word1 word2")}; 
\code{c("word1", "word2")};  \code{"word1", "word2", "word3"};
\code{word1, word2, c("word3", "word4")}.}
}
\description{
\code{cnsc} converts standard content and non-standard content \code{...} into a 
character chain. Standard content, including \emph{call}s, is evaluated.
Non-standard content and non-existing objects (in \code{.GlobalEnv}) are converted into 
character chains. Regular lists are kept unchanged.

\code{cnscinfun} is intended to be used inside a function. It should not be used directly.
}
\examples{
### cnsc
## Non-standard content (nsc1, nsc2), standard content ("stc3", "double word4") 
## and regular object (vec) stored in .GlobalEnv are merged.
vec <- c("obj5", "obj6")
cnsc(nsc1, nsc2, "stc3", "double word4", vec)

## Lists, either name in .GlobalEnv or call, are evaluated.
lst <- list(A = c("txt1","txt2","txt3"), B = c("txt4", "txt5"))
cnsc(lst) 
cnsc(list(C = c("pkg1","pkg2","pkg3"), D = c("pkg4","pkg5")))

### cnscinfun
fun <- function(...) cnscinfun()
fun(nsc1, nsc2, "stc3", "double word4", vec) 
fun(lst)

}
