/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import com.github.fommil.netlib.LAPACK;
import no.uib.cipr.matrix.JobEig;
import no.uib.cipr.matrix.JobEigRange;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.NotConvergedException;
import no.uib.cipr.matrix.SymmEVD;
import no.uib.cipr.matrix.SymmTridiagMatrix;
import org.netlib.util.intW;

public class SymmTridiagEVD
extends SymmEVD {
    private final double[] work;
    private final int[] iwork;
    private final JobEigRange range;
    private final int[] isuppz;
    private final double abstol;

    public SymmTridiagEVD(int n) {
        this(n, true);
    }

    public SymmTridiagEVD(int n, double abstol) {
        this(n, true, abstol);
    }

    public SymmTridiagEVD(int n, boolean vectors) {
        this(n, vectors, LAPACK.getInstance().dlamch("Safe minimum"));
    }

    public SymmTridiagEVD(int n, boolean vectors, double abstol) {
        super(n, vectors);
        this.abstol = abstol;
        this.range = JobEigRange.All;
        this.isuppz = new int[2 * Math.max(1, n)];
        double[] worksize = new double[1];
        int[] iworksize = new int[1];
        intW info = new intW(0);
        LAPACK.getInstance().dstevr(this.job.netlib(), this.range.netlib(), n, new double[0], new double[0], 0.0, 0.0, 0, 0, abstol, new intW(1), new double[0], new double[0], Matrices.ld(n), this.isuppz, worksize, -1, iworksize, -1, info);
        int lwork = 0;
        int liwork = 0;
        if (info.val != 0) {
            lwork = 20 * n;
            liwork = 10 * n;
        } else {
            lwork = (int)worksize[0];
            liwork = iworksize[0];
        }
        lwork = Math.max(1, lwork);
        liwork = Math.max(1, liwork);
        this.work = new double[lwork];
        this.iwork = new int[liwork];
    }

    public static SymmTridiagEVD factorize(Matrix A) throws NotConvergedException {
        return new SymmTridiagEVD(A.numRows()).factor(new SymmTridiagMatrix(A));
    }

    public SymmTridiagEVD factor(SymmTridiagMatrix A) throws NotConvergedException {
        if (A.numRows() != this.n) {
            throw new IllegalArgumentException("A.numRows() != n");
        }
        intW info = new intW(0);
        LAPACK.getInstance().dstevr(this.job.netlib(), this.range.netlib(), this.n, A.getDiagonal(), A.getOffDiagonal(), 0.0, 0.0, 0, 0, this.abstol, new intW(1), this.w, this.job == JobEig.All ? this.Z.getData() : new double[]{}, Matrices.ld(this.n), this.isuppz, this.work, this.work.length, this.iwork, this.iwork.length, info);
        if (info.val > 0) {
            throw new NotConvergedException(NotConvergedException.Reason.Iterations);
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return this;
    }
}

