/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.List;
import weka.core.Instance;
import weka.core.Instances;
import weka.gui.AttributeVisualizationPanel;
import weka.gui.beans.AbstractOffscreenChartRenderer;
import weka.gui.visualize.Plot2D;
import weka.gui.visualize.PlotData2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WekaOffscreenChartRenderer
extends AbstractOffscreenChartRenderer {
    @Override
    public String rendererName() {
        return "Weka Chart Renderer";
    }

    @Override
    public String optionsTipTextHTML() {
        return "<html><ul><li>-title=[chart title]</li><li>-color=[coloring/class attribute name]</li></html>";
    }

    @Override
    public BufferedImage renderXYLineChart(int width, int height, List<Instances> series, String xAxis, String yAxis, List<String> optionalArgs) throws Exception {
        BufferedImage osi = new BufferedImage(width, height, 1);
        String plotTitle = "Line chart";
        String userTitle = this.getOption(optionalArgs, "-title");
        plotTitle = userTitle != null ? userTitle : plotTitle;
        Plot2D offScreenPlot = new Plot2D();
        offScreenPlot.setSize(width, height);
        PlotData2D master = new PlotData2D(series.get(0));
        master.setPlotName(plotTitle);
        boolean[] connectPoints = new boolean[series.get(0).numInstances()];
        for (int i = 0; i < connectPoints.length; ++i) {
            connectPoints[i] = true;
        }
        master.setConnectPoints(connectPoints);
        offScreenPlot.setMasterPlot(master);
        Instances masterInstances = series.get(0);
        int xAx = this.getIndexOfAttribute(masterInstances, xAxis);
        int yAx = this.getIndexOfAttribute(masterInstances, yAxis);
        if (xAx < 0) {
            xAx = 0;
        }
        if (yAx < 0) {
            yAx = 0;
        }
        offScreenPlot.setXindex(xAx);
        offScreenPlot.setYindex(yAx);
        offScreenPlot.setCindex(masterInstances.numAttributes() - 1);
        String colorAtt = this.getOption(optionalArgs, "-color");
        int tempC = this.getIndexOfAttribute(masterInstances, colorAtt);
        if (tempC >= 0) {
            offScreenPlot.setCindex(tempC);
        }
        if (series.size() > 1) {
            for (Instances plotI : series) {
                PlotData2D plotD = new PlotData2D(plotI);
                connectPoints = new boolean[plotI.numInstances()];
                for (int i = 0; i < connectPoints.length; ++i) {
                    connectPoints[i] = true;
                }
                plotD.setConnectPoints(connectPoints);
                offScreenPlot.addPlot(plotD);
            }
        }
        Graphics g = osi.getGraphics();
        offScreenPlot.paintComponent(g);
        return osi;
    }

    @Override
    public BufferedImage renderXYScatterPlot(int width, int height, List<Instances> series, String xAxis, String yAxis, List<String> optionalArgs) throws Exception {
        int shapeSizeI;
        String shapeSize;
        String hasErrors;
        BufferedImage osi = new BufferedImage(width, height, 1);
        String plotTitle = "Scatter plot";
        String userTitle = this.getOption(optionalArgs, "-title");
        plotTitle = userTitle != null ? userTitle : plotTitle;
        Plot2D offScreenPlot = new Plot2D();
        offScreenPlot.setSize(width, height);
        PlotData2D master = new PlotData2D(series.get(0));
        master.setPlotName(plotTitle);
        master.m_displayAllPoints = true;
        offScreenPlot.setMasterPlot(master);
        Instances masterInstances = series.get(0);
        int xAx = this.getIndexOfAttribute(masterInstances, xAxis);
        int yAx = this.getIndexOfAttribute(masterInstances, yAxis);
        if (xAx < 0) {
            xAx = 0;
        }
        if (yAx < 0) {
            yAx = 0;
        }
        offScreenPlot.setXindex(xAx);
        offScreenPlot.setYindex(yAx);
        offScreenPlot.setCindex(masterInstances.numAttributes() - 1);
        String colorAtt = this.getOption(optionalArgs, "-color");
        int tempC = this.getIndexOfAttribute(masterInstances, colorAtt);
        if (tempC >= 0) {
            offScreenPlot.setCindex(tempC);
        }
        if ((hasErrors = this.getOption(optionalArgs, "-hasErrors")) != null) {
            int[] plotShapes = new int[masterInstances.numInstances()];
            for (int i = 0; i < plotShapes.length; ++i) {
                plotShapes[i] = 1000;
            }
            master.setShapeType(plotShapes);
        }
        if ((shapeSize = this.getOption(optionalArgs, "-shapeSize")) != null && shapeSize.length() > 0 && (shapeSizeI = this.getIndexOfAttribute(masterInstances, shapeSize)) >= 0) {
            int[] plotSizes = new int[masterInstances.numInstances()];
            for (int i = 0; i < masterInstances.numInstances(); ++i) {
                plotSizes[i] = (int)masterInstances.instance(i).value(shapeSizeI);
            }
            master.setShapeSize(plotSizes);
        }
        if (series.size() > 1) {
            for (Instances plotI : series) {
                int shapeSizeI2;
                PlotData2D plotD = new PlotData2D(plotI);
                plotD.m_displayAllPoints = true;
                offScreenPlot.addPlot(plotD);
                if (shapeSize != null && shapeSize.length() > 0 && (shapeSizeI2 = this.getIndexOfAttribute(plotI, shapeSize)) >= 0) {
                    int[] plotSizes = new int[plotI.numInstances()];
                    for (int i = 0; i < plotI.numInstances(); ++i) {
                        plotSizes[i] = (int)plotI.instance(i).value(shapeSizeI2);
                    }
                    plotD.setShapeSize(plotSizes);
                }
                if (hasErrors == null) continue;
                int[] plotShapes = new int[plotI.numInstances()];
                for (int i = 0; i < plotShapes.length; ++i) {
                    plotShapes[i] = 0;
                }
                plotD.setShapeType(plotShapes);
            }
        }
        Graphics g = osi.getGraphics();
        offScreenPlot.paintComponent(g);
        return osi;
    }

    @Override
    public BufferedImage renderHistogram(int width, int height, List<Instances> series, String attToPlot, List<String> optionalArgs) throws Exception {
        BufferedImage osi = new BufferedImage(width, height, 1);
        Instances toPlot = new Instances(series.get(0));
        for (int i = 1; i < series.size(); ++i) {
            Instances additional = series.get(i);
            for (Instance temp : additional) {
                toPlot.add(temp);
            }
        }
        int attIndex = this.getIndexOfAttribute(toPlot, attToPlot);
        if (attIndex < 0) {
            attIndex = 0;
        }
        String colorAtt = this.getOption(optionalArgs, "-color");
        int tempC = this.getIndexOfAttribute(toPlot, colorAtt);
        AttributeVisualizationPanel offScreenPlot = new AttributeVisualizationPanel();
        offScreenPlot.setSize(width, height);
        offScreenPlot.setInstances(toPlot);
        offScreenPlot.setAttribute(attIndex);
        if (tempC >= 0) {
            offScreenPlot.setColoringIndex(tempC);
        }
        Graphics g = osi.getGraphics();
        offScreenPlot.paintComponent(g);
        Thread.sleep(2000L);
        offScreenPlot.paintComponent(g);
        return osi;
    }
}

