/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.arffviewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import weka.core.Instances;
import weka.core.Undoable;
import weka.core.Utils;
import weka.core.converters.AbstractFileLoader;
import weka.gui.ComponentHelper;
import weka.gui.JTableHelper;
import weka.gui.ListSelectorDialog;
import weka.gui.arffviewer.ArffSortedTableModel;
import weka.gui.arffviewer.ArffTable;
import weka.gui.arffviewer.ArffTableCellRenderer;

public class ArffPanel
extends JPanel
implements ActionListener,
ChangeListener,
MouseListener,
Undoable {
    static final long serialVersionUID = -4697041150989513939L;
    public static final String TAB_INSTANCES = "Instances";
    private ArffTable m_TableArff;
    private JPopupMenu m_PopupHeader;
    private JPopupMenu m_PopupRows;
    private JLabel m_LabelName;
    private boolean m_ShowAttributeIndex;
    private JMenuItem menuItemMean;
    private JMenuItem menuItemSetAllValues;
    private JMenuItem menuItemSetMissingValues;
    private JMenuItem menuItemReplaceValues;
    private JMenuItem menuItemRenameAttribute;
    private JMenuItem menuItemAttributeAsClass;
    private JMenuItem menuItemDeleteAttribute;
    private JMenuItem menuItemDeleteAttributes;
    private JMenuItem menuItemSortInstances;
    private JMenuItem menuItemDeleteSelectedInstance;
    private JMenuItem menuItemDeleteAllSelectedInstances;
    private JMenuItem menuItemSearch;
    private JMenuItem menuItemClearSearch;
    private JMenuItem menuItemUndo;
    private JMenuItem menuItemCopy;
    private JMenuItem menuItemOptimalColWidth;
    private JMenuItem menuItemOptimalColWidths;
    private String m_Filename;
    private String m_Title;
    private int m_CurrentCol;
    private boolean m_Changed;
    private HashSet m_ChangeListeners;
    private String m_LastSearch;
    private String m_LastReplace;

    public ArffPanel() {
        this.initialize();
        this.createPanel();
    }

    public ArffPanel(String filename, AbstractFileLoader ... loaders) {
        this();
        this.loadFile(filename, loaders);
    }

    public ArffPanel(Instances data) {
        this();
        this.m_Filename = "";
        this.setInstances(data);
    }

    protected void initialize() {
        this.m_Filename = "";
        this.m_Title = "";
        this.m_CurrentCol = -1;
        this.m_LastSearch = "";
        this.m_LastReplace = "";
        this.m_ShowAttributeIndex = true;
        this.m_Changed = false;
        this.m_ChangeListeners = new HashSet();
    }

    protected void createPanel() {
        this.setLayout(new BorderLayout());
        this.menuItemMean = new JMenuItem("Get mean...");
        this.menuItemMean.addActionListener(this);
        this.menuItemSetAllValues = new JMenuItem("Set all values to...");
        this.menuItemSetAllValues.addActionListener(this);
        this.menuItemSetMissingValues = new JMenuItem("Set missing values to...");
        this.menuItemSetMissingValues.addActionListener(this);
        this.menuItemReplaceValues = new JMenuItem("Replace values with...");
        this.menuItemReplaceValues.addActionListener(this);
        this.menuItemRenameAttribute = new JMenuItem("Rename attribute...");
        this.menuItemRenameAttribute.addActionListener(this);
        this.menuItemAttributeAsClass = new JMenuItem("Attribute as class");
        this.menuItemAttributeAsClass.addActionListener(this);
        this.menuItemDeleteAttribute = new JMenuItem("Delete attribute");
        this.menuItemDeleteAttribute.addActionListener(this);
        this.menuItemDeleteAttributes = new JMenuItem("Delete attributes...");
        this.menuItemDeleteAttributes.addActionListener(this);
        this.menuItemSortInstances = new JMenuItem("Sort data (ascending)");
        this.menuItemSortInstances.addActionListener(this);
        this.menuItemOptimalColWidth = new JMenuItem("Optimal column width (current)");
        this.menuItemOptimalColWidth.addActionListener(this);
        this.menuItemOptimalColWidths = new JMenuItem("Optimal column width (all)");
        this.menuItemOptimalColWidths.addActionListener(this);
        this.menuItemUndo = new JMenuItem("Undo");
        this.menuItemUndo.addActionListener(this);
        this.menuItemCopy = new JMenuItem("Copy");
        this.menuItemCopy.addActionListener(this);
        this.menuItemSearch = new JMenuItem("Search...");
        this.menuItemSearch.addActionListener(this);
        this.menuItemClearSearch = new JMenuItem("Clear search");
        this.menuItemClearSearch.addActionListener(this);
        this.menuItemDeleteSelectedInstance = new JMenuItem("Delete selected instance");
        this.menuItemDeleteSelectedInstance.addActionListener(this);
        this.menuItemDeleteAllSelectedInstances = new JMenuItem("Delete ALL selected instances");
        this.menuItemDeleteAllSelectedInstances.addActionListener(this);
        this.m_TableArff = new ArffTable();
        this.m_TableArff.setToolTipText("Right click (or left+alt) for context menu");
        this.m_TableArff.getTableHeader().addMouseListener(this);
        this.m_TableArff.getTableHeader().setToolTipText("<html><b>Sort view:</b> left click = ascending / Shift + left click = descending<br><b>Menu:</b> right click (or left+alt)</html>");
        this.m_TableArff.getTableHeader().setDefaultRenderer(new ArffTableCellRenderer());
        this.m_TableArff.addChangeListener(this);
        this.m_TableArff.addMouseListener(this);
        JScrollPane pane = new JScrollPane(this.m_TableArff);
        this.add((Component)pane, "Center");
        this.m_LabelName = new JLabel();
        this.add((Component)this.m_LabelName, "North");
    }

    private void initPopupMenus() {
        this.m_PopupHeader = new JPopupMenu();
        this.m_PopupHeader.addMouseListener(this);
        this.m_PopupHeader.add(this.menuItemMean);
        if (!this.isReadOnly()) {
            this.m_PopupHeader.addSeparator();
            this.m_PopupHeader.add(this.menuItemSetAllValues);
            this.m_PopupHeader.add(this.menuItemSetMissingValues);
            this.m_PopupHeader.add(this.menuItemReplaceValues);
            this.m_PopupHeader.addSeparator();
            this.m_PopupHeader.add(this.menuItemRenameAttribute);
            this.m_PopupHeader.add(this.menuItemAttributeAsClass);
            this.m_PopupHeader.add(this.menuItemDeleteAttribute);
            this.m_PopupHeader.add(this.menuItemDeleteAttributes);
            this.m_PopupHeader.add(this.menuItemSortInstances);
        }
        this.m_PopupHeader.addSeparator();
        this.m_PopupHeader.add(this.menuItemOptimalColWidth);
        this.m_PopupHeader.add(this.menuItemOptimalColWidths);
        this.m_PopupRows = new JPopupMenu();
        this.m_PopupRows.addMouseListener(this);
        if (!this.isReadOnly()) {
            this.m_PopupRows.add(this.menuItemUndo);
            this.m_PopupRows.addSeparator();
        }
        this.m_PopupRows.add(this.menuItemCopy);
        this.m_PopupRows.addSeparator();
        this.m_PopupRows.add(this.menuItemSearch);
        this.m_PopupRows.add(this.menuItemClearSearch);
        if (!this.isReadOnly()) {
            this.m_PopupRows.addSeparator();
            this.m_PopupRows.add(this.menuItemDeleteSelectedInstance);
            this.m_PopupRows.add(this.menuItemDeleteAllSelectedInstances);
        }
    }

    private void setMenu() {
        ArffSortedTableModel model = (ArffSortedTableModel)this.m_TableArff.getModel();
        boolean isNull = model.getInstances() == null;
        boolean hasColumns = !isNull && model.getInstances().numAttributes() > 0;
        boolean hasRows = !isNull && model.getInstances().numInstances() > 0;
        boolean attSelected = hasColumns && this.m_CurrentCol > 0;
        boolean isNumeric = attSelected && model.getAttributeAt(this.m_CurrentCol).isNumeric();
        this.menuItemUndo.setEnabled(this.canUndo());
        this.menuItemCopy.setEnabled(true);
        this.menuItemSearch.setEnabled(true);
        this.menuItemClearSearch.setEnabled(true);
        this.menuItemMean.setEnabled(isNumeric);
        this.menuItemSetAllValues.setEnabled(attSelected);
        this.menuItemSetMissingValues.setEnabled(attSelected);
        this.menuItemReplaceValues.setEnabled(attSelected);
        this.menuItemRenameAttribute.setEnabled(attSelected);
        this.menuItemDeleteAttribute.setEnabled(attSelected);
        this.menuItemDeleteAttributes.setEnabled(attSelected);
        this.menuItemSortInstances.setEnabled(hasRows && attSelected);
        this.menuItemDeleteSelectedInstance.setEnabled(hasRows && this.m_TableArff.getSelectedRow() > -1);
        this.menuItemDeleteAllSelectedInstances.setEnabled(hasRows && this.m_TableArff.getSelectedRows().length > 0);
    }

    public ArffTable getTable() {
        return this.m_TableArff;
    }

    public String getTitle() {
        return this.m_Title;
    }

    public String getFilename() {
        return this.m_Filename;
    }

    public void setFilename(String filename) {
        this.m_Filename = filename;
        this.createTitle();
    }

    public Instances getInstances() {
        Instances result = null;
        if (this.m_TableArff.getModel() != null) {
            result = ((ArffSortedTableModel)this.m_TableArff.getModel()).getInstances();
        }
        return result;
    }

    public void setInstances(Instances data) {
        this.m_Filename = TAB_INSTANCES;
        this.createTitle();
        ArffSortedTableModel model = new ArffSortedTableModel(data);
        model.setShowAttributeIndex(this.m_ShowAttributeIndex);
        this.m_TableArff.setModel(model);
        this.clearUndo();
        this.setChanged(false);
        this.createName();
    }

    public Vector getAttributes() {
        Vector<String> result = new Vector<String>();
        for (int i = 0; i < this.getInstances().numAttributes(); ++i) {
            result.add(this.getInstances().attribute(i).name());
        }
        Collections.sort(result);
        return result;
    }

    public void setChanged(boolean changed) {
        if (!changed) {
            this.m_Changed = changed;
            this.createTitle();
        }
    }

    public boolean isChanged() {
        return this.m_Changed;
    }

    public boolean isReadOnly() {
        if (this.m_TableArff == null) {
            return true;
        }
        return ((ArffSortedTableModel)this.m_TableArff.getModel()).isReadOnly();
    }

    public void setReadOnly(boolean value) {
        if (this.m_TableArff != null) {
            ((ArffSortedTableModel)this.m_TableArff.getModel()).setReadOnly(value);
        }
    }

    public void setShowAttributeIndex(boolean value) {
        this.m_ShowAttributeIndex = value;
        if (this.m_TableArff != null) {
            ((ArffSortedTableModel)this.m_TableArff.getModel()).setShowAttributeIndex(value);
        }
    }

    public boolean getShowAttributeIndex() {
        return this.m_ShowAttributeIndex;
    }

    public boolean isUndoEnabled() {
        return ((ArffSortedTableModel)this.m_TableArff.getModel()).isUndoEnabled();
    }

    public void setUndoEnabled(boolean enabled) {
        ((ArffSortedTableModel)this.m_TableArff.getModel()).setUndoEnabled(enabled);
    }

    public void clearUndo() {
        ((ArffSortedTableModel)this.m_TableArff.getModel()).clearUndo();
    }

    public boolean canUndo() {
        return ((ArffSortedTableModel)this.m_TableArff.getModel()).canUndo();
    }

    public void undo() {
        if (this.canUndo()) {
            ((ArffSortedTableModel)this.m_TableArff.getModel()).undo();
            this.notifyListener();
        }
    }

    public void addUndoPoint() {
        ((ArffSortedTableModel)this.m_TableArff.getModel()).addUndoPoint();
        this.setMenu();
    }

    private void createTitle() {
        if (this.m_Filename.equals("")) {
            this.m_Title = "-none-";
        } else if (this.m_Filename.equals(TAB_INSTANCES)) {
            this.m_Title = TAB_INSTANCES;
        } else {
            try {
                File file = new File(this.m_Filename);
                this.m_Title = file.getName();
            }
            catch (Exception e) {
                this.m_Title = "-none-";
            }
        }
        if (this.isChanged()) {
            this.m_Title = this.m_Title + " *";
        }
    }

    private void createName() {
        ArffSortedTableModel model = (ArffSortedTableModel)this.m_TableArff.getModel();
        if (model != null && model.getInstances() != null) {
            this.m_LabelName.setText("Relation: " + model.getInstances().relationName());
        } else {
            this.m_LabelName.setText("");
        }
    }

    private void loadFile(String filename, AbstractFileLoader ... loaders) {
        ArffSortedTableModel model;
        this.m_Filename = filename;
        this.createTitle();
        if (filename.equals("")) {
            model = null;
        } else {
            model = new ArffSortedTableModel(filename, loaders);
            model.setShowAttributeIndex(this.getShowAttributeIndex());
        }
        this.m_TableArff.setModel(model);
        this.setChanged(false);
        this.createName();
    }

    private void calcMean() {
        if (this.m_CurrentCol == -1) {
            return;
        }
        ArffSortedTableModel model = (ArffSortedTableModel)this.m_TableArff.getModel();
        if (!model.getAttributeAt(this.m_CurrentCol).isNumeric()) {
            return;
        }
        double mean = 0.0;
        for (int i = 0; i < model.getRowCount(); ++i) {
            mean += model.getInstances().instance(i).value(this.m_CurrentCol - 1);
        }
        ComponentHelper.showMessageBox(this.getParent(), "Mean for attribute...", "Mean for attribute '" + this.m_TableArff.getPlainColumnName(this.m_CurrentCol) + "':\n\t" + Utils.doubleToString(mean /= (double)model.getRowCount(), 3), 2, -1);
    }

    private void setValues(Object o) {
        String msg;
        String title;
        String value = "";
        String valueNew = "";
        if (o == this.menuItemSetMissingValues) {
            title = "Replace missing values...";
            msg = "New value for MISSING values";
        } else if (o == this.menuItemSetAllValues) {
            title = "Set all values...";
            msg = "New value for ALL values";
        } else if (o == this.menuItemReplaceValues) {
            title = "Replace values...";
            msg = "Old value";
        } else {
            return;
        }
        value = ComponentHelper.showInputBox(this.m_TableArff.getParent(), title, msg, this.m_LastSearch);
        if (value == null) {
            return;
        }
        this.m_LastSearch = value;
        if (o == this.menuItemReplaceValues) {
            valueNew = ComponentHelper.showInputBox(this.m_TableArff.getParent(), title, "New value", this.m_LastReplace);
            if (valueNew == null) {
                return;
            }
            this.m_LastReplace = valueNew;
        }
        ArffSortedTableModel model = (ArffSortedTableModel)this.m_TableArff.getModel();
        model.setNotificationEnabled(false);
        this.addUndoPoint();
        model.setUndoEnabled(false);
        String valueCopy = value;
        String valueNewCopy = valueNew;
        for (int i = 0; i < this.m_TableArff.getRowCount(); ++i) {
            if (o == this.menuItemSetAllValues) {
                if (valueCopy.equals("NaN") || valueCopy.equals("?")) {
                    value = null;
                }
                model.setValueAt(value, i, this.m_CurrentCol);
                continue;
            }
            if (o == this.menuItemSetMissingValues && model.isMissingAt(i, this.m_CurrentCol)) {
                model.setValueAt(value, i, this.m_CurrentCol);
                continue;
            }
            if (o != this.menuItemReplaceValues || !model.getValueAt(i, this.m_CurrentCol).toString().equals(value)) continue;
            if (valueNewCopy.equals("NaN") || valueNewCopy.equals("?")) {
                valueNew = null;
            }
            model.setValueAt(valueNew, i, this.m_CurrentCol);
        }
        model.setUndoEnabled(true);
        model.setNotificationEnabled(true);
        model.notifyListener(new TableModelEvent(model, 0, model.getRowCount(), this.m_CurrentCol, 0));
        this.m_TableArff.repaint();
    }

    public void deleteAttribute() {
        if (this.m_CurrentCol == -1) {
            return;
        }
        ArffSortedTableModel model = (ArffSortedTableModel)this.m_TableArff.getModel();
        if (model.getAttributeAt(this.m_CurrentCol) == null) {
            return;
        }
        if (ComponentHelper.showMessageBox(this.getParent(), "Confirm...", "Do you really want to delete the attribute '" + model.getAttributeAt(this.m_CurrentCol).name() + "'?", 0, 3) != 0) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        model.deleteAttributeAt(this.m_CurrentCol);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void deleteAttributes() {
        JList list = new JList(this.getAttributes());
        ListSelectorDialog dialog = new ListSelectorDialog(null, list);
        int result = dialog.showDialog();
        if (result != 0) {
            return;
        }
        Object[] atts = list.getSelectedValues();
        if (ComponentHelper.showMessageBox(this.getParent(), "Confirm...", "Do you really want to delete these " + atts.length + " attributes?", 0, 3) != 0) {
            return;
        }
        ArffSortedTableModel model = (ArffSortedTableModel)this.m_TableArff.getModel();
        int[] indices = new int[atts.length];
        for (int i = 0; i < atts.length; ++i) {
            indices[i] = model.getAttributeColumn(atts[i].toString());
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        model.deleteAttributes(indices);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void attributeAsClass() {
        if (this.m_CurrentCol == -1) {
            return;
        }
        ArffSortedTableModel model = (ArffSortedTableModel)this.m_TableArff.getModel();
        if (model.getAttributeAt(this.m_CurrentCol) == null) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        model.attributeAsClassAt(this.m_CurrentCol);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void renameAttribute() {
        if (this.m_CurrentCol == -1) {
            return;
        }
        ArffSortedTableModel model = (ArffSortedTableModel)this.m_TableArff.getModel();
        if (model.getAttributeAt(this.m_CurrentCol) == null) {
            return;
        }
        String newName = ComponentHelper.showInputBox(this.getParent(), "Rename attribute...", "Enter new Attribute name", model.getAttributeAt(this.m_CurrentCol).name());
        if (newName == null) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        model.renameAttributeAt(this.m_CurrentCol, newName);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void deleteInstance() {
        int index = this.m_TableArff.getSelectedRow();
        if (index == -1) {
            return;
        }
        ((ArffSortedTableModel)this.m_TableArff.getModel()).deleteInstanceAt(index);
    }

    public void deleteInstances() {
        if (this.m_TableArff.getSelectedRow() == -1) {
            return;
        }
        int[] indices = this.m_TableArff.getSelectedRows();
        ((ArffSortedTableModel)this.m_TableArff.getModel()).deleteInstances(indices);
    }

    public void sortInstances() {
        if (this.m_CurrentCol == -1) {
            return;
        }
        ((ArffSortedTableModel)this.m_TableArff.getModel()).sortInstances(this.m_CurrentCol);
    }

    public void copyContent() {
        StringSelection selection = this.getTable().getStringSelection();
        if (selection == null) {
            return;
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(selection, selection);
    }

    public void search() {
        String searchString = ComponentHelper.showInputBox(this.getParent(), "Search...", "Enter the string to search for", this.m_LastSearch);
        if (searchString != null) {
            this.m_LastSearch = searchString;
        }
        this.getTable().setSearchString(searchString);
    }

    public void clearSearch() {
        this.getTable().setSearchString("");
    }

    public void setOptimalColWidth() {
        if (this.m_CurrentCol == -1) {
            return;
        }
        JTableHelper.setOptimalColumnWidth(this.getTable(), this.m_CurrentCol);
    }

    public void setOptimalColWidths() {
        JTableHelper.setOptimalColumnWidth(this.getTable());
    }

    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.menuItemMean) {
            this.calcMean();
        } else if (o == this.menuItemSetAllValues) {
            this.setValues(this.menuItemSetAllValues);
        } else if (o == this.menuItemSetMissingValues) {
            this.setValues(this.menuItemSetMissingValues);
        } else if (o == this.menuItemReplaceValues) {
            this.setValues(this.menuItemReplaceValues);
        } else if (o == this.menuItemRenameAttribute) {
            this.renameAttribute();
        } else if (o == this.menuItemAttributeAsClass) {
            this.attributeAsClass();
        } else if (o == this.menuItemDeleteAttribute) {
            this.deleteAttribute();
        } else if (o == this.menuItemDeleteAttributes) {
            this.deleteAttributes();
        } else if (o == this.menuItemDeleteSelectedInstance) {
            this.deleteInstance();
        } else if (o == this.menuItemDeleteAllSelectedInstances) {
            this.deleteInstances();
        } else if (o == this.menuItemSortInstances) {
            this.sortInstances();
        } else if (o == this.menuItemSearch) {
            this.search();
        } else if (o == this.menuItemClearSearch) {
            this.clearSearch();
        } else if (o == this.menuItemUndo) {
            this.undo();
        } else if (o == this.menuItemCopy) {
            this.copyContent();
        } else if (o == this.menuItemOptimalColWidth) {
            this.setOptimalColWidth();
        } else if (o == this.menuItemOptimalColWidths) {
            this.setOptimalColWidths();
        }
    }

    public void mouseClicked(MouseEvent e) {
        int col = this.m_TableArff.columnAtPoint(e.getPoint());
        boolean popup = e.getButton() == 3 && e.getClickCount() == 1 || e.getButton() == 1 && e.getClickCount() == 1 && e.isAltDown() && !e.isControlDown() && !e.isShiftDown();
        boolean bl = popup = popup && this.getInstances() != null;
        if (e.getSource() == this.m_TableArff.getTableHeader()) {
            this.m_CurrentCol = col;
            if (popup) {
                e.consume();
                this.setMenu();
                this.initPopupMenus();
                this.m_PopupHeader.show(e.getComponent(), e.getX(), e.getY());
            }
        } else if (e.getSource() == this.m_TableArff && popup) {
            e.consume();
            this.setMenu();
            this.initPopupMenus();
            this.m_PopupRows.show(e.getComponent(), e.getX(), e.getY());
        }
        if (e.getButton() == 1 && e.getClickCount() == 1 && !e.isAltDown() && col > -1) {
            this.m_TableArff.setSelectedColumn(col);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void stateChanged(ChangeEvent e) {
        this.m_Changed = true;
        this.createTitle();
        this.notifyListener();
    }

    public void notifyListener() {
        Iterator iter = this.m_ChangeListeners.iterator();
        while (iter.hasNext()) {
            ((ChangeListener)iter.next()).stateChanged(new ChangeEvent(this));
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.m_ChangeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.m_ChangeListeners.remove(l);
    }
}

