/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.sql;

import java.sql.ResultSet;
import java.util.HashSet;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import weka.gui.sql.ResultSetHelper;

public class ResultSetTableModel
implements TableModel {
    protected HashSet m_Listeners = new HashSet();
    protected Object[][] m_Data;
    protected ResultSetHelper m_Helper;

    public ResultSetTableModel(ResultSet rs) {
        this(rs, 0);
    }

    public ResultSetTableModel(ResultSet rs, int rows) {
        this.m_Helper = new ResultSetHelper(rs, rows);
        this.m_Data = this.m_Helper.getCells();
    }

    public void addTableModelListener(TableModelListener l) {
        this.m_Listeners.add(l);
    }

    public Class getColumnClass(int columnIndex) {
        Class result = null;
        if (this.m_Helper.getColumnClasses() != null && columnIndex >= 0 && columnIndex < this.getColumnCount()) {
            result = columnIndex == 0 ? Integer.class : this.m_Helper.getColumnClasses()[columnIndex - 1];
        }
        return result;
    }

    public int getColumnCount() {
        return this.m_Helper.getColumnCount() + 1;
    }

    public String getColumnName(int columnIndex) {
        String result = "";
        if (this.m_Helper.getColumnNames() != null && columnIndex >= 0 && columnIndex < this.getColumnCount()) {
            result = columnIndex == 0 ? "Row" : this.m_Helper.getColumnNames()[columnIndex - 1];
        }
        return result;
    }

    public int getRowCount() {
        return this.m_Data.length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result = null;
        if (rowIndex >= 0 && rowIndex < this.getRowCount() && columnIndex >= 0 && columnIndex < this.getColumnCount()) {
            result = columnIndex == 0 ? new Integer(rowIndex + 1) : this.m_Data[rowIndex][columnIndex - 1];
        }
        return result;
    }

    public boolean isNullAt(int rowIndex, int columnIndex) {
        return this.getValueAt(rowIndex, columnIndex) == null;
    }

    public boolean isNumericAt(int columnIndex) {
        boolean result = false;
        if (columnIndex >= 0 && columnIndex < this.getColumnCount()) {
            result = columnIndex == 0 ? true : (this.m_Helper.getNumericColumns() == null ? false : this.m_Helper.getNumericColumns()[columnIndex - 1]);
        }
        return result;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public void removeTableModelListener(TableModelListener l) {
        this.m_Listeners.remove(l);
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public void finalize() throws Throwable {
        try {
            this.m_Helper.getResultSet().close();
            this.m_Helper.getResultSet().getStatement().close();
            this.m_Helper = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_Data = null;
        super.finalize();
    }
}

