/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.gui.beans.BeanCustomizer;
import weka.gui.beans.CustomizerCloseRequester;
import weka.gui.beans.CustomizerClosingListener;
import weka.gui.beans.EnvironmentField;
import weka.gui.beans.ModelPerformanceChart;
import weka.gui.beans.OffscreenChartRenderer;
import weka.gui.beans.PluginManager;
import weka.gui.beans.WekaOffscreenChartRenderer;

public class ModelPerformanceChartCustomizer
extends JPanel
implements BeanCustomizer,
EnvironmentHandler,
CustomizerClosingListener,
CustomizerCloseRequester {
    private static final long serialVersionUID = 27802741348090392L;
    private ModelPerformanceChart m_modelPC;
    private Environment m_env = Environment.getSystemWide();
    private BeanCustomizer.ModifyListener m_modifyListener;
    private Window m_parent;
    private String m_rendererNameBack;
    private String m_xAxisBack;
    private String m_yAxisBack;
    private String m_widthBack;
    private String m_heightBack;
    private String m_optsBack;
    private JComboBox m_rendererCombo;
    private EnvironmentField m_xAxis;
    private EnvironmentField m_yAxis;
    private EnvironmentField m_width;
    private EnvironmentField m_height;
    private EnvironmentField m_opts;

    public ModelPerformanceChartCustomizer() {
        this.setLayout(new BorderLayout());
    }

    public void setObject(Object object) {
        this.m_modelPC = (ModelPerformanceChart)object;
        this.m_rendererNameBack = this.m_modelPC.getOffscreenRendererName();
        this.m_xAxisBack = this.m_modelPC.getOffscreenXAxis();
        this.m_yAxisBack = this.m_modelPC.getOffscreenYAxis();
        this.m_widthBack = this.m_modelPC.getOffscreenWidth();
        this.m_heightBack = this.m_modelPC.getOffscreenHeight();
        this.m_optsBack = this.m_modelPC.getOffscreenAdditionalOpts();
        this.setup();
    }

    private void setup() {
        JPanel holder = new JPanel();
        holder.setLayout(new GridLayout(6, 2));
        Vector<String> comboItems = new Vector<String>();
        comboItems.add("Weka Chart Renderer");
        Set<String> pluginRenderers = PluginManager.getPluginNamesOfType("weka.gui.beans.OffscreenChartRenderer");
        if (pluginRenderers != null) {
            for (String plugin : pluginRenderers) {
                comboItems.add(plugin);
            }
        }
        JLabel rendererLab = new JLabel("Renderer", 4);
        holder.add(rendererLab);
        this.m_rendererCombo = new JComboBox(comboItems);
        holder.add(this.m_rendererCombo);
        JLabel xLab = new JLabel("X-axis attribute", 4);
        xLab.setToolTipText("Attribute name or /first or /last or /<index>");
        this.m_xAxis = new EnvironmentField(this.m_env);
        this.m_xAxis.setText(this.m_xAxisBack);
        JLabel yLab = new JLabel("Y-axis attribute", 4);
        yLab.setToolTipText("Attribute name or /first or /last or /<index>");
        this.m_yAxis = new EnvironmentField(this.m_env);
        this.m_yAxis.setText(this.m_yAxisBack);
        JLabel widthLab = new JLabel("Chart width (pixels)", 4);
        this.m_width = new EnvironmentField(this.m_env);
        this.m_width.setText(this.m_widthBack);
        JLabel heightLab = new JLabel("Chart height (pixels)", 4);
        this.m_height = new EnvironmentField(this.m_env);
        this.m_height.setText(this.m_heightBack);
        final JLabel optsLab = new JLabel("Renderer options", 4);
        this.m_opts = new EnvironmentField(this.m_env);
        this.m_opts.setText(this.m_optsBack);
        holder.add(xLab);
        holder.add(this.m_xAxis);
        holder.add(yLab);
        holder.add(this.m_yAxis);
        holder.add(widthLab);
        holder.add(this.m_width);
        holder.add(heightLab);
        holder.add(this.m_height);
        holder.add(optsLab);
        holder.add(this.m_opts);
        this.add((Component)holder, "Center");
        String globalInfo = this.m_modelPC.globalInfo();
        globalInfo = globalInfo + " This dialog allows you to configure offscreen rendering options. Offscreen images are passed via 'image' connections.";
        JTextArea jt = new JTextArea();
        jt.setColumns(30);
        jt.setFont(new Font("SansSerif", 0, 12));
        jt.setEditable(false);
        jt.setLineWrap(true);
        jt.setWrapStyleWord(true);
        jt.setText(globalInfo);
        jt.setBackground(this.getBackground());
        JPanel jp = new JPanel();
        jp.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("About"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        jp.setLayout(new BorderLayout());
        jp.add((Component)jt, "Center");
        this.add((Component)jp, "North");
        this.addButtons();
        this.m_rendererCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ModelPerformanceChartCustomizer.this.setupRendererOptsTipText(optsLab);
            }
        });
        this.m_rendererCombo.setSelectedItem(this.m_rendererNameBack);
        this.setupRendererOptsTipText(optsLab);
    }

    private void setupRendererOptsTipText(JLabel optsLab) {
        String renderer = this.m_rendererCombo.getSelectedItem().toString();
        if (renderer.equalsIgnoreCase("weka chart renderer")) {
            WekaOffscreenChartRenderer rcr = new WekaOffscreenChartRenderer();
            String tipText = rcr.optionsTipTextHTML();
            tipText = tipText.replace("<html>", "<html>Comma separated list of options:<br>");
            optsLab.setToolTipText(tipText);
        } else {
            try {
                String tipText;
                Object rendererO = PluginManager.getPluginInstance("weka.gui.beans.OffscreenChartRenderer", renderer);
                if (rendererO != null && (tipText = ((OffscreenChartRenderer)rendererO).optionsTipTextHTML()) != null && tipText.length() > 0) {
                    optsLab.setToolTipText(tipText);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void addButtons() {
        JButton okBut = new JButton("OK");
        JButton cancelBut = new JButton("Cancel");
        JPanel butHolder = new JPanel();
        butHolder.setLayout(new GridLayout(1, 2));
        butHolder.add(okBut);
        butHolder.add(cancelBut);
        this.add((Component)butHolder, "South");
        okBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ModelPerformanceChartCustomizer.this.m_modelPC.setOffscreenXAxis(ModelPerformanceChartCustomizer.this.m_xAxis.getText());
                ModelPerformanceChartCustomizer.this.m_modelPC.setOffscreenYAxis(ModelPerformanceChartCustomizer.this.m_yAxis.getText());
                ModelPerformanceChartCustomizer.this.m_modelPC.setOffscreenWidth(ModelPerformanceChartCustomizer.this.m_width.getText());
                ModelPerformanceChartCustomizer.this.m_modelPC.setOffscreenHeight(ModelPerformanceChartCustomizer.this.m_height.getText());
                ModelPerformanceChartCustomizer.this.m_modelPC.setOffscreenAdditionalOpts(ModelPerformanceChartCustomizer.this.m_opts.getText());
                ModelPerformanceChartCustomizer.this.m_modelPC.setOffscreenRendererName(ModelPerformanceChartCustomizer.this.m_rendererCombo.getSelectedItem().toString());
                if (ModelPerformanceChartCustomizer.this.m_modifyListener != null) {
                    ModelPerformanceChartCustomizer.this.m_modifyListener.setModifiedStatus(ModelPerformanceChartCustomizer.this, true);
                }
                if (ModelPerformanceChartCustomizer.this.m_parent != null) {
                    ModelPerformanceChartCustomizer.this.m_parent.dispose();
                }
            }
        });
        cancelBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ModelPerformanceChartCustomizer.this.customizerClosing();
                if (ModelPerformanceChartCustomizer.this.m_parent != null) {
                    ModelPerformanceChartCustomizer.this.m_parent.dispose();
                }
            }
        });
    }

    public void setParentWindow(Window parent) {
        this.m_parent = parent;
    }

    public void customizerClosing() {
        this.m_modelPC.setOffscreenXAxis(this.m_xAxisBack);
        this.m_modelPC.setOffscreenYAxis(this.m_yAxisBack);
        this.m_modelPC.setOffscreenWidth(this.m_widthBack);
        this.m_modelPC.setOffscreenHeight(this.m_heightBack);
        this.m_modelPC.setOffscreenAdditionalOpts(this.m_optsBack);
        this.m_modelPC.setOffscreenRendererName(this.m_rendererNameBack);
    }

    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    public void setModifiedListener(BeanCustomizer.ModifyListener l) {
        this.m_modifyListener = l;
    }
}

