/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch.balltrees;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.EuclideanDistance;
import weka.core.Instance;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.neighboursearch.balltrees.BallNode;
import weka.core.neighboursearch.balltrees.BallSplitter;
import weka.core.neighboursearch.balltrees.BallTreeConstructor;
import weka.core.neighboursearch.balltrees.PointsClosestToFurthestChildren;

public class TopDownConstructor
extends BallTreeConstructor
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -5150140645091889979L;
    protected BallSplitter m_Splitter = new PointsClosestToFurthestChildren();

    public String globalInfo() {
        return "The class implementing the TopDown construction method of ball trees. It further uses one of a number of different splitting methods to split a ball while constructing the tree top down.\n\nFor more information see also:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.TECHREPORT);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Stephen M. Omohundro");
        result.setValue(TechnicalInformation.Field.YEAR, "1989");
        result.setValue(TechnicalInformation.Field.TITLE, "Five Balltree Construction Algorithms");
        result.setValue(TechnicalInformation.Field.MONTH, "December");
        result.setValue(TechnicalInformation.Field.NUMBER, "TR-89-063");
        result.setValue(TechnicalInformation.Field.INSTITUTION, "International Computer Science Institute");
        return result;
    }

    public BallNode buildTree() throws Exception {
        this.m_MaxDepth = 0;
        this.m_NumNodes = 0;
        this.m_NumLeaves = 1;
        this.m_Splitter.setInstances(this.m_Instances);
        this.m_Splitter.setInstanceList(this.m_InstList);
        this.m_Splitter.setEuclideanDistanceFunction((EuclideanDistance)this.m_DistanceFunction);
        BallNode root = new BallNode(0, this.m_InstList.length - 1, 0);
        root.setPivot(BallNode.calcCentroidPivot(this.m_InstList, this.m_Instances));
        root.setRadius(BallNode.calcRadius(this.m_InstList, this.m_Instances, root.getPivot(), this.m_DistanceFunction));
        this.splitNodes(root, this.m_MaxDepth + 1, root.m_Radius);
        return root;
    }

    protected void splitNodes(BallNode node, int depth, double rootRadius) throws Exception {
        if (node.m_NumInstances <= this.m_MaxInstancesInLeaf || rootRadius == 0.0 || node.m_Radius / rootRadius < this.m_MaxRelLeafRadius) {
            return;
        }
        --this.m_NumLeaves;
        this.m_Splitter.splitNode(node, this.m_NumNodes);
        this.m_NumNodes += 2;
        this.m_NumLeaves += 2;
        if (this.m_MaxDepth < depth) {
            this.m_MaxDepth = depth;
        }
        this.splitNodes(node.m_Left, depth + 1, rootRadius);
        this.splitNodes(node.m_Right, depth + 1, rootRadius);
        if (this.m_FullyContainChildBalls) {
            double radius = BallNode.calcRadius(node.m_Left, node.m_Right, node.getPivot(), this.m_DistanceFunction);
            Instance pivot = BallNode.calcPivot(node.m_Left, node.m_Right, this.m_Instances);
            node.setRadius(radius);
        }
    }

    public int[] addInstance(BallNode node, Instance inst) throws Exception {
        if (node.m_Left != null && node.m_Right != null) {
            double rightDist;
            double leftDist = this.m_DistanceFunction.distance(inst, node.m_Left.getPivot(), Double.POSITIVE_INFINITY);
            if (leftDist < (rightDist = this.m_DistanceFunction.distance(inst, node.m_Right.getPivot(), Double.POSITIVE_INFINITY))) {
                this.addInstance(node.m_Left, inst);
                this.processNodesAfterAddInstance(node.m_Right);
            } else {
                this.addInstance(node.m_Right, inst);
            }
            ++node.m_End;
        } else {
            if (node.m_Left != null || node.m_Right != null) {
                throw new Exception("Error: Only one leaf of the built ball tree is assigned. Please check code.");
            }
            int index = this.m_Instances.numInstances() - 1;
            int[] instList = new int[this.m_Instances.numInstances()];
            System.arraycopy(this.m_InstList, 0, instList, 0, node.m_End + 1);
            if (node.m_End < this.m_InstList.length - 1) {
                System.arraycopy(this.m_InstList, node.m_End + 2, instList, node.m_End + 2, this.m_InstList.length - node.m_End - 1);
            }
            instList[node.m_End + 1] = index;
            ++node.m_End;
            ++node.m_NumInstances;
            this.m_InstList = instList;
            this.m_Splitter.setInstanceList(this.m_InstList);
            if (node.m_NumInstances > this.m_MaxInstancesInLeaf) {
                this.m_Splitter.splitNode(node, this.m_NumNodes);
                this.m_NumNodes += 2;
            }
        }
        return this.m_InstList;
    }

    protected void processNodesAfterAddInstance(BallNode node) {
        ++node.m_Start;
        ++node.m_End;
        if (node.m_Left != null && node.m_Right != null) {
            this.processNodesAfterAddInstance(node.m_Left);
            this.processNodesAfterAddInstance(node.m_Right);
        }
    }

    public String ballSplitterTipText() {
        return "The BallSplitter algorithm set that would be used by the TopDown BallTree constructor.";
    }

    public BallSplitter getBallSplitter() {
        return this.m_Splitter;
    }

    public void setBallSplitter(BallSplitter splitter) {
        this.m_Splitter = splitter;
    }

    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>();
        newVector.addElement(new Option("\tBall splitting algorithm to use.", "S", 1, "-S <classname and options>"));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String optionString = Utils.getOption('S', options);
        if (optionString.length() != 0) {
            String[] nnSearchClassSpec = Utils.splitOptions(optionString);
            if (nnSearchClassSpec.length == 0) {
                throw new Exception("Invalid BallSplitter specification string.");
            }
            String className = nnSearchClassSpec[0];
            nnSearchClassSpec[0] = "";
            this.setBallSplitter((BallSplitter)Utils.forName(BallSplitter.class, className, nnSearchClassSpec));
        } else {
            this.setBallSplitter(new PointsClosestToFurthestChildren());
        }
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        result.add("-S");
        result.add(this.m_Splitter.getClass().getName());
        return result.toArray(new String[result.size()]);
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }
}

