/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules.part;

import weka.classifiers.rules.part.ClassifierDecList;
import weka.classifiers.trees.j48.Distribution;
import weka.classifiers.trees.j48.ModelSelection;
import weka.classifiers.trees.j48.NoSplit;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class PruneableDecList
extends ClassifierDecList {
    private static final long serialVersionUID = -7228103346297172921L;

    public PruneableDecList(ModelSelection toSelectLocModel, int minNum) {
        super(toSelectLocModel, minNum);
    }

    public void buildRule(Instances train, Instances test) throws Exception {
        this.buildDecList(train, test, false);
        this.cleanup(new Instances(train, 0));
    }

    public void buildDecList(Instances train, Instances test, boolean leaf) throws Exception {
        this.m_train = null;
        this.m_isLeaf = false;
        this.m_isEmpty = false;
        this.m_sons = null;
        this.indeX = 0;
        double sumOfWeights = train.sumOfWeights();
        NoSplit noSplit = new NoSplit(new Distribution(train));
        this.m_localModel = leaf ? noSplit : this.m_toSelectModel.selectModel(train, test);
        this.m_test = new Distribution(test, this.m_localModel);
        if (this.m_localModel.numSubsets() > 1) {
            int j;
            int ind;
            Instances[] localTrain = this.m_localModel.split(train);
            Instances[] localTest = this.m_localModel.split(test);
            train = null;
            test = null;
            this.m_sons = new ClassifierDecList[this.m_localModel.numSubsets()];
            int i = 0;
            do {
                ++i;
                ind = this.chooseIndex();
                if (ind == -1) {
                    for (j = 0; j < this.m_sons.length; ++j) {
                        if (this.m_sons[j] != null) continue;
                        this.m_sons[j] = this.getNewDecList(localTrain[j], localTest[j], true);
                    }
                    if (i < 2) {
                        this.m_localModel = noSplit;
                        this.m_isLeaf = true;
                        this.m_sons = null;
                        if (Utils.eq(sumOfWeights, 0.0)) {
                            this.m_isEmpty = true;
                        }
                        return;
                    }
                    ind = 0;
                    break;
                }
                this.m_sons[ind] = this.getNewDecList(localTrain[ind], localTest[ind], false);
            } while (i < this.m_sons.length && this.m_sons[ind].m_isLeaf);
            for (j = 0; j < this.m_sons.length && this.m_sons[j] != null && this.m_sons[j].m_isLeaf; ++j) {
            }
            if (j == this.m_sons.length) {
                this.pruneEnd();
                if (!this.m_isLeaf) {
                    this.indeX = this.chooseLastIndex();
                }
            } else {
                this.indeX = this.chooseLastIndex();
            }
        } else {
            this.m_isLeaf = true;
            if (Utils.eq(sumOfWeights, 0.0)) {
                this.m_isEmpty = true;
            }
        }
    }

    protected ClassifierDecList getNewDecList(Instances train, Instances test, boolean leaf) throws Exception {
        PruneableDecList newDecList = new PruneableDecList(this.m_toSelectModel, this.m_minNumObj);
        newDecList.buildDecList(train, test, leaf);
        return newDecList;
    }

    protected void pruneEnd() throws Exception {
        double errorsTree = this.errorsForTree();
        double errorsLeaf = this.errorsForLeaf();
        if (Utils.smOrEq(errorsLeaf, errorsTree)) {
            this.m_isLeaf = true;
            this.m_sons = null;
            this.m_localModel = new NoSplit(this.localModel().distribution());
        }
    }

    private double errorsForTree() throws Exception {
        if (this.m_isLeaf) {
            return this.errorsForLeaf();
        }
        double error = 0.0;
        for (int i = 0; i < this.m_sons.length; ++i) {
            if (Utils.eq(this.son(i).localModel().distribution().total(), 0.0)) {
                error += this.m_test.perBag(i) - this.m_test.perClassPerBag(i, this.localModel().distribution().maxClass());
                continue;
            }
            error += ((PruneableDecList)this.son(i)).errorsForTree();
        }
        return error;
    }

    private double errorsForLeaf() throws Exception {
        return this.m_test.total() - this.m_test.perClass(this.localModel().distribution().maxClass());
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }
}

