/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import weka.core.Attribute;
import weka.core.Instances;
import weka.gui.PropertySheetPanel;
import weka.gui.beans.BeanCustomizer;
import weka.gui.beans.ClassAssigner;
import weka.gui.beans.CustomizerCloseRequester;
import weka.gui.beans.CustomizerClosingListener;
import weka.gui.beans.DataFormatListener;
import weka.gui.beans.DataSetEvent;

public class ClassAssignerCustomizer
extends JPanel
implements BeanCustomizer,
CustomizerClosingListener,
CustomizerCloseRequester,
DataFormatListener {
    private static final long serialVersionUID = 476539385765301907L;
    private boolean m_displayColNames = false;
    private transient ClassAssigner m_classAssigner;
    private transient PropertyChangeSupport m_pcSupport = new PropertyChangeSupport(this);
    private transient PropertySheetPanel m_caEditor = new PropertySheetPanel();
    private transient JComboBox m_ClassCombo = new JComboBox();
    private transient JPanel m_holderP = new JPanel();
    private transient BeanCustomizer.ModifyListener m_modifyListener;
    private transient Window m_parent;
    private transient String m_backup;

    public ClassAssignerCustomizer() {
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.add((Component)new JLabel("ClassAssignerCustomizer"), "North");
        this.m_holderP.setLayout(new BorderLayout());
        this.m_holderP.setBorder(BorderFactory.createTitledBorder("Choose class attribute"));
        this.m_holderP.add((Component)this.m_ClassCombo, "Center");
        this.m_ClassCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ClassAssignerCustomizer.this.m_classAssigner != null && ClassAssignerCustomizer.this.m_displayColNames) {
                    ClassAssignerCustomizer.this.m_classAssigner.setClassColumn("" + ClassAssignerCustomizer.this.m_ClassCombo.getSelectedIndex());
                }
            }
        });
        this.add((Component)this.m_caEditor, "Center");
        this.addButtons();
    }

    private void addButtons() {
        JButton okBut = new JButton("OK");
        JButton cancelBut = new JButton("Cancel");
        JPanel butHolder = new JPanel();
        butHolder.setLayout(new GridLayout(1, 2));
        butHolder.add(okBut);
        butHolder.add(cancelBut);
        this.add((Component)butHolder, "South");
        okBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassAssignerCustomizer.this.m_modifyListener.setModifiedStatus(ClassAssignerCustomizer.this, true);
                if (ClassAssignerCustomizer.this.m_parent != null) {
                    ClassAssignerCustomizer.this.m_parent.dispose();
                }
            }
        });
        cancelBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassAssignerCustomizer.this.customizerClosing();
                if (ClassAssignerCustomizer.this.m_parent != null) {
                    ClassAssignerCustomizer.this.m_parent.dispose();
                }
            }
        });
    }

    private void setUpStandardSelection() {
        if (this.m_displayColNames) {
            this.remove(this.m_holderP);
            this.m_caEditor.setTarget(this.m_classAssigner);
            this.add((Component)this.m_caEditor, "Center");
            this.m_displayColNames = false;
        }
        this.validate();
        this.repaint();
    }

    private void setUpColumnSelection(Instances format) {
        if (!this.m_displayColNames) {
            this.remove(this.m_caEditor);
        }
        int existingClassCol = 0;
        String classColString = this.m_classAssigner.getClassColumn();
        if (classColString.trim().toLowerCase().compareTo("last") == 0 || classColString.equalsIgnoreCase("/last")) {
            existingClassCol = format.numAttributes() - 1;
        } else if (classColString.trim().toLowerCase().compareTo("first") != 0 && !classColString.equalsIgnoreCase("/first")) {
            Attribute classAtt = format.attribute(classColString);
            existingClassCol = classAtt != null ? classAtt.index() : ((existingClassCol = Integer.parseInt(classColString)) < 0 ? -1 : (existingClassCol > format.numAttributes() - 1 ? format.numAttributes() - 1 : --existingClassCol));
        }
        String[] attribNames = new String[format.numAttributes() + 1];
        attribNames[0] = "NO CLASS";
        for (int i = 1; i < attribNames.length; ++i) {
            String type = "(" + Attribute.typeToStringShort(format.attribute(i - 1)) + ") ";
            attribNames[i] = type + format.attribute(i - 1).name();
        }
        this.m_ClassCombo.setModel(new DefaultComboBoxModel<String>(attribNames));
        if (attribNames.length > 0) {
            this.m_ClassCombo.setSelectedIndex(existingClassCol + 1);
        }
        if (!this.m_displayColNames) {
            this.add((Component)this.m_holderP, "Center");
            this.m_displayColNames = true;
        }
        this.validate();
        this.repaint();
    }

    public void setObject(Object object) {
        if (this.m_classAssigner != (ClassAssigner)object) {
            this.m_classAssigner = (ClassAssigner)object;
            this.m_caEditor.setTarget(this.m_classAssigner);
            if (this.m_classAssigner.getConnectedFormat() != null) {
                this.setUpColumnSelection(this.m_classAssigner.getConnectedFormat());
            }
            this.m_backup = this.m_classAssigner.getClassColumn();
        }
    }

    public void customizerClosing() {
        if (this.m_classAssigner != null) {
            this.m_classAssigner.removeDataFormatListener(this);
        }
        if (this.m_backup != null) {
            this.m_classAssigner.setClassColumn(this.m_backup);
        }
    }

    public void newDataFormat(DataSetEvent dse) {
        if (dse.getDataSet() != null) {
            this.setUpColumnSelection(this.m_classAssigner.getConnectedFormat());
        } else {
            this.setUpStandardSelection();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.m_pcSupport.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.m_pcSupport.removePropertyChangeListener(pcl);
    }

    public void setModifiedListener(BeanCustomizer.ModifyListener l) {
        this.m_modifyListener = l;
    }

    public void setParentWindow(Window parent) {
        this.m_parent = parent;
    }
}

