/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.BestFirst;
import weka.attributeSelection.SubsetEvaluator;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Evaluation;
import weka.classifiers.lazy.IBk;
import weka.classifiers.rules.DecisionTableHashKey;
import weka.core.AdditionalMeasureProducer;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Discretize;
import weka.filters.unsupervised.attribute.Remove;

public class DecisionTable
extends AbstractClassifier
implements OptionHandler,
WeightedInstancesHandler,
AdditionalMeasureProducer,
TechnicalInformationHandler {
    static final long serialVersionUID = 2888557078165701326L;
    protected Hashtable<DecisionTableHashKey, double[]> m_entries;
    protected double[] m_classPriorCounts;
    protected double[] m_classPriors;
    protected int[] m_decisionFeatures;
    protected Filter m_disTransform;
    protected Remove m_delTransform;
    protected IBk m_ibk;
    protected Instances m_theInstances;
    protected Instances m_dtInstances;
    protected int m_numAttributes;
    private int m_numInstances;
    protected boolean m_classIsNominal;
    protected boolean m_useIBk;
    protected boolean m_displayRules;
    private int m_CVFolds;
    private Random m_rr;
    protected double m_majority;
    protected ASSearch m_search = new BestFirst();
    protected ASEvaluation m_evaluator;
    protected Evaluation m_evaluation;
    public static final int EVAL_DEFAULT = 1;
    public static final int EVAL_ACCURACY = 2;
    public static final int EVAL_RMSE = 3;
    public static final int EVAL_MAE = 4;
    public static final int EVAL_AUC = 5;
    public static final Tag[] TAGS_EVALUATION = new Tag[]{new Tag(1, "Default: accuracy (discrete class); RMSE (numeric class)"), new Tag(2, "Accuracy (discrete class only"), new Tag(3, "RMSE (of the class probabilities for discrete class)"), new Tag(4, "MAE (of the class probabilities for discrete class)"), new Tag(5, "AUC (area under the ROC curve - discrete class only)")};
    protected int m_evaluationMeasure = 1;
    protected boolean m_saveMemory = true;

    public String globalInfo() {
        return "Class for building and using a simple decision table majority classifier.\n\nFor more information see: \n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Ron Kohavi");
        result.setValue(TechnicalInformation.Field.TITLE, "The Power of Decision Tables");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "8th European Conference on Machine Learning");
        result.setValue(TechnicalInformation.Field.YEAR, "1995");
        result.setValue(TechnicalInformation.Field.PAGES, "174-189");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Springer");
        return result;
    }

    private void insertIntoTable(Instance inst, double[] instA) throws Exception {
        DecisionTableHashKey thekey = instA != null ? new DecisionTableHashKey(instA) : new DecisionTableHashKey(inst, inst.numAttributes(), false);
        double[] tempClassDist2 = this.m_entries.get(thekey);
        if (tempClassDist2 == null) {
            if (this.m_classIsNominal) {
                double[] newDist = new double[this.m_theInstances.classAttribute().numValues()];
                for (int i = 0; i < this.m_theInstances.classAttribute().numValues(); ++i) {
                    newDist[i] = 1.0;
                }
                newDist[(int)inst.classValue()] = inst.weight();
                this.m_entries.put(thekey, newDist);
            } else {
                double[] newDist = new double[]{inst.classValue() * inst.weight(), inst.weight()};
                this.m_entries.put(thekey, newDist);
            }
        } else if (this.m_classIsNominal) {
            int n = (int)inst.classValue();
            tempClassDist2[n] = tempClassDist2[n] + inst.weight();
            this.m_entries.put(thekey, tempClassDist2);
        } else {
            tempClassDist2[0] = tempClassDist2[0] + inst.classValue() * inst.weight();
            tempClassDist2[1] = tempClassDist2[1] + inst.weight();
            this.m_entries.put(thekey, tempClassDist2);
        }
    }

    double evaluateInstanceLeaveOneOut(Instance instance, double[] instA) throws Exception {
        DecisionTableHashKey thekey = new DecisionTableHashKey(instA);
        if (this.m_classIsNominal) {
            double[] tempDist = this.m_entries.get(thekey);
            if (tempDist == null) {
                throw new Error("This should never happen!");
            }
            double[] normDist = new double[tempDist.length];
            System.arraycopy(tempDist, 0, normDist, 0, tempDist.length);
            int n = (int)instance.classValue();
            normDist[n] = normDist[n] - instance.weight();
            boolean ok = false;
            for (double element : normDist) {
                if (!Utils.gr(element, 1.0)) continue;
                ok = true;
                break;
            }
            int n2 = (int)instance.classValue();
            this.m_classPriorCounts[n2] = this.m_classPriorCounts[n2] - instance.weight();
            double[] classPriors = (double[])this.m_classPriorCounts.clone();
            Utils.normalize(classPriors);
            if (!ok) {
                normDist = classPriors;
            }
            int n3 = (int)instance.classValue();
            this.m_classPriorCounts[n3] = this.m_classPriorCounts[n3] + instance.weight();
            Utils.normalize(normDist);
            if (this.m_evaluationMeasure == 5) {
                this.m_evaluation.evaluateModelOnceAndRecordPrediction(normDist, instance);
            } else {
                this.m_evaluation.evaluateModelOnce(normDist, instance);
            }
            return Utils.maxIndex(normDist);
        }
        double[] tempDist = this.m_entries.get(thekey);
        if (tempDist != null) {
            double[] normDist = new double[tempDist.length];
            System.arraycopy(tempDist, 0, normDist, 0, tempDist.length);
            normDist[0] = normDist[0] - instance.classValue() * instance.weight();
            normDist[1] = normDist[1] - instance.weight();
            if (Utils.eq(normDist[1], 0.0)) {
                double[] temp = new double[]{this.m_majority};
                this.m_evaluation.evaluateModelOnce(temp, instance);
                return this.m_majority;
            }
            double[] temp = new double[]{normDist[0] / normDist[1]};
            this.m_evaluation.evaluateModelOnce(temp, instance);
            return temp[0];
        }
        throw new Error("This should never happen!");
    }

    double evaluateFoldCV(Instances fold, int[] fs) throws Exception {
        Instance inst;
        int i;
        int numFold = fold.numInstances();
        int numCl = this.m_theInstances.classAttribute().numValues();
        double[][] class_distribs = new double[numFold][numCl];
        double[] instA = new double[fs.length];
        double acc = 0.0;
        int classI = this.m_theInstances.classIndex();
        double[] normDist = this.m_classIsNominal ? new double[numCl] : new double[2];
        for (i = 0; i < numFold; ++i) {
            inst = fold.instance(i);
            for (int j = 0; j < fs.length; ++j) {
                instA[j] = fs[j] == classI ? Double.MAX_VALUE : (inst.isMissing(fs[j]) ? Double.MAX_VALUE : inst.value(fs[j]));
            }
            DecisionTableHashKey thekey = new DecisionTableHashKey(instA);
            class_distribs[i] = this.m_entries.get(thekey);
            if (class_distribs[i] == null) {
                throw new Error("This should never happen!");
            }
            if (this.m_classIsNominal) {
                double[] dArray = class_distribs[i];
                int n = (int)inst.classValue();
                dArray[n] = dArray[n] - inst.weight();
            } else {
                double[] dArray = class_distribs[i];
                dArray[0] = dArray[0] - inst.classValue() * inst.weight();
                double[] dArray2 = class_distribs[i];
                dArray2[1] = dArray2[1] - inst.weight();
            }
            int n = (int)inst.classValue();
            this.m_classPriorCounts[n] = this.m_classPriorCounts[n] - inst.weight();
        }
        double[] classPriors = (double[])this.m_classPriorCounts.clone();
        Utils.normalize(classPriors);
        for (i = 0; i < numFold; ++i) {
            inst = fold.instance(i);
            System.arraycopy(class_distribs[i], 0, normDist, 0, normDist.length);
            if (this.m_classIsNominal) {
                boolean ok = false;
                for (double element : normDist) {
                    if (!Utils.gr(element, 1.0)) continue;
                    ok = true;
                    break;
                }
                if (!ok) {
                    normDist = (double[])classPriors.clone();
                }
                Utils.normalize(normDist);
                if (this.m_evaluationMeasure == 5) {
                    this.m_evaluation.evaluateModelOnceAndRecordPrediction(normDist, inst);
                    continue;
                }
                this.m_evaluation.evaluateModelOnce(normDist, inst);
                continue;
            }
            if (Utils.eq(normDist[1], 0.0)) {
                double[] temp = new double[]{this.m_majority};
                this.m_evaluation.evaluateModelOnce(temp, inst);
                continue;
            }
            double[] temp = new double[]{normDist[0] / normDist[1]};
            this.m_evaluation.evaluateModelOnce(temp, inst);
        }
        for (i = 0; i < numFold; ++i) {
            inst = fold.instance(i);
            int n = (int)inst.classValue();
            this.m_classPriorCounts[n] = this.m_classPriorCounts[n] + inst.weight();
            if (this.m_classIsNominal) {
                double[] dArray = class_distribs[i];
                int n2 = (int)inst.classValue();
                dArray[n2] = dArray[n2] + inst.weight();
                continue;
            }
            double[] dArray = class_distribs[i];
            dArray[0] = dArray[0] + inst.classValue() * inst.weight();
            double[] dArray3 = class_distribs[i];
            dArray3[1] = dArray3[1] + inst.weight();
        }
        return acc;
    }

    protected double estimatePerformance(BitSet feature_set, int num_atts) throws Exception {
        int j;
        Instance inst;
        int i;
        this.m_evaluation = new Evaluation(this.m_theInstances);
        int[] fs = new int[num_atts];
        double[] instA = new double[num_atts];
        int classI = this.m_theInstances.classIndex();
        int index = 0;
        for (i = 0; i < this.m_numAttributes; ++i) {
            if (!feature_set.get(i)) continue;
            fs[index++] = i;
        }
        this.m_entries = new Hashtable((int)((double)this.m_theInstances.numInstances() * 1.5));
        for (i = 0; i < this.m_numInstances; ++i) {
            inst = this.m_theInstances.instance(i);
            for (j = 0; j < fs.length; ++j) {
                instA[j] = fs[j] == classI ? Double.MAX_VALUE : (inst.isMissing(fs[j]) ? Double.MAX_VALUE : inst.value(fs[j]));
            }
            this.insertIntoTable(inst, instA);
        }
        if (this.m_CVFolds == 1) {
            for (i = 0; i < this.m_numInstances; ++i) {
                inst = this.m_theInstances.instance(i);
                for (j = 0; j < fs.length; ++j) {
                    instA[j] = fs[j] == classI ? Double.MAX_VALUE : (inst.isMissing(fs[j]) ? Double.MAX_VALUE : inst.value(fs[j]));
                }
                this.evaluateInstanceLeaveOneOut(inst, instA);
            }
        } else {
            this.m_theInstances.randomize(this.m_rr);
            this.m_theInstances.stratify(this.m_CVFolds);
            for (i = 0; i < this.m_CVFolds; ++i) {
                Instances insts = this.m_theInstances.testCV(this.m_CVFolds, i);
                this.evaluateFoldCV(insts, fs);
            }
        }
        switch (this.m_evaluationMeasure) {
            case 1: {
                if (this.m_classIsNominal) {
                    return this.m_evaluation.pctCorrect();
                }
                return -this.m_evaluation.rootMeanSquaredError();
            }
            case 2: {
                return this.m_evaluation.pctCorrect();
            }
            case 3: {
                return -this.m_evaluation.rootMeanSquaredError();
            }
            case 4: {
                return -this.m_evaluation.meanAbsoluteError();
            }
            case 5: {
                double[] classPriors = this.m_evaluation.getClassPriors();
                Utils.normalize(classPriors);
                double weightedAUC = 0.0;
                for (i = 0; i < this.m_theInstances.classAttribute().numValues(); ++i) {
                    double tempAUC = this.m_evaluation.areaUnderROC(i);
                    if (!Utils.isMissingValue(tempAUC)) {
                        weightedAUC += classPriors[i] * tempAUC;
                        continue;
                    }
                    System.err.println("Undefined AUC!!");
                }
                return weightedAUC;
            }
        }
        return 0.0;
    }

    protected void resetOptions() {
        this.m_entries = null;
        this.m_decisionFeatures = null;
        this.m_useIBk = false;
        this.m_CVFolds = 1;
        this.m_displayRules = false;
        this.m_evaluationMeasure = 1;
    }

    public DecisionTable() {
        this.resetOptions();
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(6);
        newVector.addElement(new Option("\tFull class name of search method, followed\n\tby its options.\n\teg: \"weka.attributeSelection.BestFirst -D 1\"\n\t(default weka.attributeSelection.BestFirst)", "S", 1, "-S <search method specification>"));
        newVector.addElement(new Option("\tUse cross validation to evaluate features.\n\tUse number of folds = 1 for leave one out CV.\n\t(Default = leave one out CV)", "X", 1, "-X <number of folds>"));
        newVector.addElement(new Option("\tPerformance evaluation measure to use for selecting attributes.\n\t(Default = accuracy for discrete class and rmse for numeric class)", "E", 1, "-E <acc | rmse | mae | auc>"));
        newVector.addElement(new Option("\tUse nearest neighbour instead of global table majority.", "I", 0, "-I"));
        newVector.addElement(new Option("\tDisplay decision table rules.\n", "R", 0, "-R"));
        newVector.addAll(Collections.list(super.listOptions()));
        newVector.addElement(new Option("", "", 0, "\nOptions specific to search method " + this.m_search.getClass().getName() + ":"));
        newVector.addAll(Collections.list(((OptionHandler)((Object)this.m_search)).listOptions()));
        return newVector.elements();
    }

    public String crossValTipText() {
        return "Sets the number of folds for cross validation (1 = leave one out).";
    }

    public void setCrossVal(int folds) {
        this.m_CVFolds = folds;
    }

    public int getCrossVal() {
        return this.m_CVFolds;
    }

    public String useIBkTipText() {
        return "Sets whether IBk should be used instead of the majority class.";
    }

    public void setUseIBk(boolean ibk) {
        this.m_useIBk = ibk;
    }

    public boolean getUseIBk() {
        return this.m_useIBk;
    }

    public String displayRulesTipText() {
        return "Sets whether rules are to be printed.";
    }

    public void setDisplayRules(boolean rules) {
        this.m_displayRules = rules;
    }

    public boolean getDisplayRules() {
        return this.m_displayRules;
    }

    public String searchTipText() {
        return "The search method used to find good attribute combinations for the decision table.";
    }

    public void setSearch(ASSearch search) {
        this.m_search = search;
    }

    public ASSearch getSearch() {
        return this.m_search;
    }

    public String evaluationMeasureTipText() {
        return "The measure used to evaluate the performance of attribute combinations used in the decision table.";
    }

    public SelectedTag getEvaluationMeasure() {
        return new SelectedTag(this.m_evaluationMeasure, TAGS_EVALUATION);
    }

    public void setEvaluationMeasure(SelectedTag newMethod) {
        if (newMethod.getTags() == TAGS_EVALUATION) {
            this.m_evaluationMeasure = newMethod.getSelectedTag().getID();
        }
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String[] searchSpec;
        String searchString;
        this.resetOptions();
        super.setOptions(options);
        String optionString = Utils.getOption('X', options);
        if (optionString.length() != 0) {
            this.m_CVFolds = Integer.parseInt(optionString);
        }
        this.m_useIBk = Utils.getFlag('I', options);
        this.m_displayRules = Utils.getFlag('R', options);
        optionString = Utils.getOption('E', options);
        if (optionString.length() != 0) {
            if (optionString.equals("acc")) {
                this.setEvaluationMeasure(new SelectedTag(2, TAGS_EVALUATION));
            } else if (optionString.equals("rmse")) {
                this.setEvaluationMeasure(new SelectedTag(3, TAGS_EVALUATION));
            } else if (optionString.equals("mae")) {
                this.setEvaluationMeasure(new SelectedTag(4, TAGS_EVALUATION));
            } else if (optionString.equals("auc")) {
                this.setEvaluationMeasure(new SelectedTag(5, TAGS_EVALUATION));
            } else {
                throw new IllegalArgumentException("Invalid evaluation measure");
            }
        }
        if ((searchString = Utils.getOption('S', options)).length() == 0) {
            searchString = BestFirst.class.getName();
        }
        if ((searchSpec = Utils.splitOptions(searchString)).length == 0) {
            throw new IllegalArgumentException("Invalid search specification string");
        }
        String searchName = searchSpec[0];
        searchSpec[0] = "";
        this.setSearch(ASSearch.forName(searchName, searchSpec));
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-X");
        options.add("" + this.m_CVFolds);
        if (this.m_evaluationMeasure != 1) {
            options.add("-E");
            switch (this.m_evaluationMeasure) {
                case 2: {
                    options.add("acc");
                    break;
                }
                case 3: {
                    options.add("rmse");
                    break;
                }
                case 4: {
                    options.add("mae");
                    break;
                }
                case 5: {
                    options.add("auc");
                }
            }
        }
        if (this.m_useIBk) {
            options.add("-I");
        }
        if (this.m_displayRules) {
            options.add("-R");
        }
        options.add("-S");
        options.add("" + this.getSearchSpec());
        Collections.addAll(options, super.getOptions());
        return options.toArray(new String[0]);
    }

    protected String getSearchSpec() {
        ASSearch s = this.getSearch();
        if (s instanceof OptionHandler) {
            return s.getClass().getName() + " " + Utils.joinOptions(((OptionHandler)((Object)s)).getOptions());
        }
        return s.getClass().getName();
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        if (this.m_evaluationMeasure != 2 && this.m_evaluationMeasure != 5) {
            result.enable(Capabilities.Capability.NUMERIC_CLASS);
            result.enable(Capabilities.Capability.DATE_CLASS);
        }
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    protected void setUpEvaluator() throws Exception {
        this.m_evaluator = new DummySubsetEvaluator();
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        this.m_theInstances = new Instances(data);
        this.m_theInstances.deleteWithMissingClass();
        this.m_rr = new Random(1L);
        if (this.m_theInstances.classAttribute().isNominal()) {
            this.m_classPriorCounts = new double[data.classAttribute().numValues()];
            Arrays.fill(this.m_classPriorCounts, 1.0);
            for (int i = 0; i < data.numInstances(); ++i) {
                Instance curr = data.instance(i);
                int n = (int)curr.classValue();
                this.m_classPriorCounts[n] = this.m_classPriorCounts[n] + curr.weight();
            }
            this.m_classPriors = (double[])this.m_classPriorCounts.clone();
            Utils.normalize(this.m_classPriors);
        }
        this.setUpEvaluator();
        if (this.m_theInstances.classAttribute().isNumeric()) {
            this.m_disTransform = new Discretize();
            this.m_classIsNominal = false;
            ((Discretize)this.m_disTransform).setBins(10);
            ((Discretize)this.m_disTransform).setInvertSelection(true);
            String rangeList = "";
            rangeList = rangeList + (this.m_theInstances.classIndex() + 1);
            ((Discretize)this.m_disTransform).setAttributeIndices(rangeList);
        } else {
            this.m_disTransform = new weka.filters.supervised.attribute.Discretize();
            ((weka.filters.supervised.attribute.Discretize)this.m_disTransform).setUseBetterEncoding(true);
            this.m_classIsNominal = true;
        }
        this.m_disTransform.setInputFormat(this.m_theInstances);
        this.m_theInstances = Filter.useFilter(this.m_theInstances, this.m_disTransform);
        this.m_numAttributes = this.m_theInstances.numAttributes();
        this.m_numInstances = this.m_theInstances.numInstances();
        this.m_majority = this.m_theInstances.meanOrMode(this.m_theInstances.classAttribute());
        int[] selected = this.m_search.search(this.m_evaluator, this.m_theInstances);
        this.m_decisionFeatures = new int[selected.length + 1];
        System.arraycopy(selected, 0, this.m_decisionFeatures, 0, selected.length);
        this.m_decisionFeatures[this.m_decisionFeatures.length - 1] = this.m_theInstances.classIndex();
        this.m_delTransform = new Remove();
        this.m_delTransform.setInvertSelection(true);
        this.m_delTransform.setAttributeIndicesArray(this.m_decisionFeatures);
        this.m_delTransform.setInputFormat(this.m_theInstances);
        this.m_dtInstances = Filter.useFilter(this.m_theInstances, this.m_delTransform);
        this.m_numAttributes = this.m_dtInstances.numAttributes();
        this.m_entries = new Hashtable((int)((double)this.m_dtInstances.numInstances() * 1.5));
        for (int i = 0; i < this.m_numInstances; ++i) {
            Instance inst = this.m_dtInstances.instance(i);
            this.insertIntoTable(inst, null);
        }
        if (this.m_useIBk) {
            this.m_ibk = new IBk();
            this.m_ibk.buildClassifier(this.m_theInstances);
        }
        if (this.m_saveMemory) {
            this.m_theInstances = new Instances(this.m_theInstances, 0);
            this.m_dtInstances = new Instances(this.m_dtInstances, 0);
        }
        this.m_evaluation = null;
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        this.m_disTransform.input(instance);
        this.m_disTransform.batchFinished();
        instance = this.m_disTransform.output();
        this.m_delTransform.input(instance);
        this.m_delTransform.batchFinished();
        instance = this.m_delTransform.output();
        DecisionTableHashKey thekey = new DecisionTableHashKey(instance, instance.numAttributes(), false);
        double[] tempDist = this.m_entries.get(thekey);
        if (tempDist == null) {
            tempDist = this.m_useIBk ? this.m_ibk.distributionForInstance(instance) : (!this.m_classIsNominal ? new double[]{this.m_majority} : (double[])this.m_classPriors.clone());
        } else if (!this.m_classIsNominal) {
            double[] normDist = new double[]{tempDist[0] / tempDist[1]};
            tempDist = normDist;
        } else {
            double[] normDist = new double[tempDist.length];
            System.arraycopy(tempDist, 0, normDist, 0, tempDist.length);
            Utils.normalize(normDist);
            tempDist = normDist;
        }
        return tempDist;
    }

    public String printFeatures() {
        String s = "";
        for (int i = 0; i < this.m_decisionFeatures.length; ++i) {
            s = i == 0 ? "" + (this.m_decisionFeatures[i] + 1) : s + "," + (this.m_decisionFeatures[i] + 1);
        }
        return s;
    }

    public double measureNumRules() {
        return this.m_entries.size();
    }

    @Override
    public Enumeration<String> enumerateMeasures() {
        Vector<String> newVector = new Vector<String>(1);
        newVector.addElement("measureNumRules");
        return newVector.elements();
    }

    @Override
    public double getMeasure(String additionalMeasureName) {
        if (additionalMeasureName.compareToIgnoreCase("measureNumRules") == 0) {
            return this.measureNumRules();
        }
        throw new IllegalArgumentException(additionalMeasureName + " not supported (DecisionTable)");
    }

    public String toString() {
        if (this.m_entries == null) {
            return "Decision Table: No model built yet.";
        }
        StringBuffer text = new StringBuffer();
        text.append("Decision Table:\n\nNumber of training instances: " + this.m_numInstances + "\nNumber of Rules : " + this.m_entries.size() + "\n");
        if (this.m_useIBk) {
            text.append("Non matches covered by IB1.\n");
        } else {
            text.append("Non matches covered by Majority class.\n");
        }
        text.append(this.m_search.toString());
        text.append("Evaluation (for feature selection): CV ");
        if (this.m_CVFolds > 1) {
            text.append("(" + this.m_CVFolds + " fold) ");
        } else {
            text.append("(leave one out) ");
        }
        text.append("\nFeature set: " + this.printFeatures());
        if (this.m_displayRules) {
            int i;
            int maxColWidth = 0;
            for (int i2 = 0; i2 < this.m_dtInstances.numAttributes(); ++i2) {
                if (this.m_dtInstances.attribute(i2).name().length() > maxColWidth) {
                    maxColWidth = this.m_dtInstances.attribute(i2).name().length();
                }
                if (!this.m_classIsNominal && i2 == this.m_dtInstances.classIndex()) continue;
                Enumeration<Object> e = this.m_dtInstances.attribute(i2).enumerateValues();
                while (e.hasMoreElements()) {
                    String ss = (String)e.nextElement();
                    if (ss.length() <= maxColWidth) continue;
                    maxColWidth = ss.length();
                }
            }
            text.append("\n\nRules:\n");
            StringBuffer tm = new StringBuffer();
            for (i = 0; i < this.m_dtInstances.numAttributes(); ++i) {
                if (this.m_dtInstances.classIndex() == i) continue;
                int d = maxColWidth - this.m_dtInstances.attribute(i).name().length();
                tm.append(this.m_dtInstances.attribute(i).name());
                for (int j = 0; j < d + 1; ++j) {
                    tm.append(" ");
                }
            }
            tm.append(this.m_dtInstances.attribute(this.m_dtInstances.classIndex()).name() + "  ");
            for (i = 0; i < tm.length() + 10; ++i) {
                text.append("=");
            }
            text.append("\n");
            text.append(tm);
            text.append("\n");
            for (i = 0; i < tm.length() + 10; ++i) {
                text.append("=");
            }
            text.append("\n");
            Enumeration<DecisionTableHashKey> e = this.m_entries.keys();
            while (e.hasMoreElements()) {
                DecisionTableHashKey tt = e.nextElement();
                text.append(tt.toString(this.m_dtInstances, maxColWidth));
                double[] ClassDist = this.m_entries.get(tt);
                if (this.m_classIsNominal) {
                    int m = Utils.maxIndex(ClassDist);
                    try {
                        text.append(this.m_dtInstances.classAttribute().value(m) + "\n");
                    }
                    catch (Exception ee) {
                        System.out.println(ee.getMessage());
                    }
                    continue;
                }
                text.append(ClassDist[0] / ClassDist[1] + "\n");
            }
            for (int i3 = 0; i3 < tm.length() + 10; ++i3) {
                text.append("=");
            }
            text.append("\n");
            text.append("\n");
        }
        return text.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10153 $");
    }

    public static void main(String[] argv) {
        DecisionTable.runClassifier(new DecisionTable(), argv);
    }

    private class DummySubsetEvaluator
    extends ASEvaluation
    implements SubsetEvaluator {
        private static final long serialVersionUID = 3927442457704974150L;

        private DummySubsetEvaluator() {
        }

        @Override
        public void buildEvaluator(Instances data) throws Exception {
        }

        @Override
        public double evaluateSubset(BitSet subset) throws Exception {
            int fc = 0;
            for (int jj = 0; jj < DecisionTable.this.m_numAttributes; ++jj) {
                if (!subset.get(jj)) continue;
                ++fc;
            }
            return DecisionTable.this.estimatePerformance(subset, fc);
        }
    }
}

