/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.EventSetDescriptor;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import weka.core.Environment;
import weka.gui.Logger;
import weka.gui.ResultHistoryPanel;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.ImageEvent;
import weka.gui.beans.ImageListener;
import weka.gui.beans.KFStep;
import weka.gui.beans.UserRequestAcceptor;
import weka.gui.beans.Visible;

@KFStep(category="Visualization", toolTipText="Display static images")
public class ImageViewer
extends JPanel
implements ImageListener,
BeanCommon,
Visible,
Serializable,
UserRequestAcceptor {
    private static final long serialVersionUID = 7976930810628389750L;
    protected ImageDisplayer m_plotter;
    protected ResultHistoryPanel m_history;
    private transient JFrame m_resultsFrame = null;
    protected BeanVisual m_visual = new BeanVisual("ImageVisualizer", "weka/gui/beans/icons/StripChart.gif", "weka/gui/beans/icons/StripChart_animated.gif");
    protected transient Logger m_logger = null;
    protected transient Environment m_env;

    public ImageViewer() {
        this.useDefaultVisual();
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
        this.m_env = Environment.getSystemWide();
        this.m_plotter = new ImageDisplayer();
        this.m_plotter.setBorder(BorderFactory.createTitledBorder("Image"));
        this.m_plotter.setMinimumSize(new Dimension(810, 610));
        this.m_plotter.setPreferredSize(new Dimension(810, 610));
        this.setUpResultHistory();
    }

    public String globalInfo() {
        return "Display static images";
    }

    @Override
    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/StripChart.gif", "weka/gui/beans/icons/StripChart_animated.gif");
        this.m_visual.setText("ImageViewer");
    }

    @Override
    public void setVisual(BeanVisual newVisual) {
        this.m_visual = newVisual;
    }

    @Override
    public BeanVisual getVisual() {
        return this.m_visual;
    }

    @Override
    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    @Override
    public String getCustomName() {
        return this.m_visual.getText();
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean isBusy() {
        return false;
    }

    @Override
    public void setLog(Logger logger) {
        this.m_logger = logger;
    }

    @Override
    public boolean connectionAllowed(EventSetDescriptor esd) {
        return this.connectionAllowed(esd.getName());
    }

    @Override
    public boolean connectionAllowed(String eventName) {
        return true;
    }

    @Override
    public void connectionNotification(String eventName, Object source) {
    }

    @Override
    public void disconnectionNotification(String eventName, Object source) {
    }

    @Override
    public synchronized void acceptImage(ImageEvent imageE) {
        BufferedImage image = imageE.getImage();
        String name = new SimpleDateFormat("HH:mm:ss:SS").format(new Date());
        name = "Image at " + name;
        this.m_history.addResult(name, new StringBuffer());
        this.m_history.addObject(name, image);
        this.m_plotter.setImage(image);
        this.m_plotter.repaint();
    }

    protected void showResults() {
        if (this.m_resultsFrame == null) {
            if (this.m_history == null) {
                this.setUpResultHistory();
            }
            this.m_resultsFrame = new JFrame("Image Viewer");
            this.m_resultsFrame.getContentPane().setLayout(new BorderLayout());
            this.m_resultsFrame.getContentPane().add((Component)new MainPanel(this.m_history, this.m_plotter), "Center");
            this.m_resultsFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    ImageViewer.this.m_resultsFrame.dispose();
                    ImageViewer.this.m_resultsFrame = null;
                }
            });
            this.m_resultsFrame.pack();
            this.m_resultsFrame.setVisible(true);
        } else {
            this.m_resultsFrame.toFront();
        }
    }

    private void setUpResultHistory() {
        if (this.m_history == null) {
            this.m_history = new ResultHistoryPanel(null);
        }
        this.m_history.setBorder(BorderFactory.createTitledBorder("Image list"));
        this.m_history.setHandleRightClicks(false);
        this.m_history.getList().addMouseListener(new ResultHistoryPanel.RMouseAdapter(){
            private static final long serialVersionUID = -4984130887963944249L;

            @Override
            public void mouseClicked(MouseEvent e) {
                String name;
                Object pic;
                int index = ImageViewer.this.m_history.getList().locationToIndex(e.getPoint());
                if (index != -1 && (pic = ImageViewer.this.m_history.getNamedObject(name = ImageViewer.this.m_history.getNameAtIndex(index))) instanceof BufferedImage) {
                    ImageViewer.this.m_plotter.setImage((BufferedImage)pic);
                    ImageViewer.this.m_plotter.repaint();
                }
            }
        });
        this.m_history.getList().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ListSelectionModel lm = (ListSelectionModel)e.getSource();
                    for (int i = e.getFirstIndex(); i <= e.getLastIndex(); ++i) {
                        String name;
                        Object pic;
                        if (!lm.isSelectedIndex(i)) continue;
                        if (i == -1 || (pic = ImageViewer.this.m_history.getNamedObject(name = ImageViewer.this.m_history.getNameAtIndex(i))) == null || !(pic instanceof BufferedImage)) break;
                        ImageViewer.this.m_plotter.setImage((BufferedImage)pic);
                        ImageViewer.this.m_plotter.repaint();
                        break;
                    }
                }
            }
        });
    }

    @Override
    public Enumeration<String> enumerateRequests() {
        Vector<String> newVector = new Vector<String>(0);
        newVector.addElement("Show results");
        return newVector.elements();
    }

    @Override
    public void performRequest(String request) {
        if (request.compareTo("Show results") != 0) {
            throw new IllegalArgumentException(request + " not supported (ImageViewer)");
        }
        this.showResults();
    }

    private static class ImageDisplayer
    extends JPanel {
        private static final long serialVersionUID = 4161957589912537357L;
        private BufferedImage m_image;

        private ImageDisplayer() {
        }

        public void setImage(BufferedImage image) {
            this.m_image = image;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.m_image != null) {
                int plotWidth = this.m_image.getWidth();
                int plotHeight = this.m_image.getHeight();
                int ourWidth = this.getWidth();
                int ourHeight = this.getHeight();
                int x = 0;
                int y = 0;
                if (plotWidth < ourWidth) {
                    x = (ourWidth - plotWidth) / 2;
                }
                if (plotHeight < ourHeight) {
                    y = (ourHeight - plotHeight) / 2;
                }
                g.drawImage(this.m_image, x, y, this);
            }
        }
    }

    private static class MainPanel
    extends JPanel {
        private static final long serialVersionUID = 5648976848887609072L;

        public MainPanel(ResultHistoryPanel p, ImageDisplayer id) {
            this.setLayout(new BorderLayout());
            JPanel topP = new JPanel();
            topP.setLayout(new BorderLayout());
            topP.add((Component)new JScrollPane(id), "Center");
            topP.add((Component)p, "West");
            this.add((Component)topP, "Center");
        }
    }
}

