/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import weka.core.Attribute;
import weka.core.AttributeLocator;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;

public class RelationalLocator
extends AttributeLocator {
    private static final long serialVersionUID = 4646872277151854732L;

    public RelationalLocator(Instances data) {
        super(data, 4);
    }

    public RelationalLocator(Instances data, int fromIndex, int toIndex) {
        super(data, 4, fromIndex, toIndex);
    }

    public RelationalLocator(Instances data, int[] indices) {
        super(data, 4, indices);
    }

    public static void copyRelationalValues(Instance inst, Instances destDataset, AttributeLocator strAtts) {
        if (inst.dataset() == null) {
            throw new IllegalArgumentException("Instance has no dataset assigned!!");
        }
        if (inst.dataset().numAttributes() != destDataset.numAttributes()) {
            throw new IllegalArgumentException("Src and Dest differ in # of attributes!!");
        }
        RelationalLocator.copyRelationalValues(inst, true, inst.dataset(), strAtts, destDataset, strAtts);
    }

    public static void copyRelationalValues(Instance instance, boolean instSrcCompat, Instances srcDataset, AttributeLocator srcLoc, Instances destDataset, AttributeLocator destLoc) {
        if (srcDataset == destDataset) {
            return;
        }
        if (srcLoc.getAttributeIndices().length != destLoc.getAttributeIndices().length) {
            throw new IllegalArgumentException("Src and Dest relational indices differ in length!!");
        }
        if (srcLoc.getLocatorIndices().length != destLoc.getLocatorIndices().length) {
            throw new IllegalArgumentException("Src and Dest locator indices differ in length!!");
        }
        for (int i = 0; i < srcLoc.getAttributeIndices().length; ++i) {
            int instIndex = instSrcCompat ? srcLoc.getActualIndex(srcLoc.getAttributeIndices()[i]) : destLoc.getActualIndex(destLoc.getAttributeIndices()[i]);
            Attribute src = srcDataset.attribute(srcLoc.getActualIndex(srcLoc.getAttributeIndices()[i]));
            Attribute dest = destDataset.attribute(destLoc.getActualIndex(destLoc.getAttributeIndices()[i]));
            if (instance.isMissing(instIndex)) continue;
            int valIndex = dest.addRelation(src.relation((int)instance.value(instIndex)));
            instance.setValue(instIndex, (double)valIndex);
        }
        int[] srcIndices = srcLoc.getLocatorIndices();
        int[] destIndices = destLoc.getLocatorIndices();
        for (int i = 0; i < srcIndices.length; ++i) {
            int index;
            int n = index = instSrcCompat ? srcLoc.getActualIndex(srcIndices[i]) : destLoc.getActualIndex(destIndices[i]);
            if (instance.isMissing(index)) continue;
            Instances rel = instSrcCompat ? instance.relationalValue(index) : instance.relationalValue(index);
            AttributeLocator srcRelAttsNew = srcLoc.getLocator(srcIndices[i]);
            Instances srcDatasetNew = srcRelAttsNew.getData();
            AttributeLocator destRelAttsNew = destLoc.getLocator(destIndices[i]);
            Instances destDatasetNew = destRelAttsNew.getData();
            for (int n2 = 0; n2 < rel.numInstances(); ++n2) {
                RelationalLocator.copyRelationalValues(rel.instance(n2), instSrcCompat, srcDatasetNew, srcRelAttsNew, destDatasetNew, destRelAttsNew);
            }
        }
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5953 $");
    }
}

