/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.mi;

import weka.core.Optimization;
import weka.core.RevisionUtils;

class TLDSimple_Optm
extends Optimization {
    private double[] num;
    private double sSq;
    private double[] xBar;

    TLDSimple_Optm() {
    }

    public void setNum(double[] n) {
        this.num = n;
    }

    public void setSgmSq(double s) {
        this.sSq = s;
    }

    public void setXBar(double[] x) {
        this.xBar = x;
    }

    protected double objectiveFunction(double[] x) {
        int numExs = this.num.length;
        double NLL = 0.0;
        double w = x[0];
        double m = x[1];
        for (int j = 0; j < numExs; ++j) {
            if (Double.isNaN(this.xBar[j])) continue;
            double bag = 0.0;
            if (Double.isNaN(bag += Math.log(w * this.num[j] + this.sSq)) && m_Debug) {
                System.out.println("???????????1: " + w + " " + m + "|x-: " + this.xBar[j] + "|n: " + this.num[j] + "|S^2: " + this.sSq);
            }
            if (Double.isNaN(bag += this.num[j] * (m - this.xBar[j]) * (m - this.xBar[j]) / (w * this.num[j] + this.sSq)) && m_Debug) {
                System.out.println("???????????2: " + w + " " + m + "|x-: " + this.xBar[j] + "|n: " + this.num[j] + "|S^2: " + this.sSq);
            }
            NLL += bag;
        }
        return NLL;
    }

    protected double[] evaluateGradient(double[] x) {
        double[] g = new double[x.length];
        int numExs = this.num.length;
        double w = x[0];
        double m = x[1];
        double dw = 0.0;
        double dm = 0.0;
        for (int j = 0; j < numExs; ++j) {
            if (Double.isNaN(this.xBar[j])) continue;
            dw += this.num[j] / (w * this.num[j] + this.sSq) - this.num[j] * this.num[j] * (m - this.xBar[j]) * (m - this.xBar[j]) / ((w * this.num[j] + this.sSq) * (w * this.num[j] + this.sSq));
            dm += 2.0 * this.num[j] * (m - this.xBar[j]) / (w * this.num[j] + this.sSq);
        }
        g[0] = dw;
        g[1] = dm;
        return g;
    }

    protected double[] evaluateHessian(double[] x, int index) {
        double[] h = new double[x.length];
        int numExs = this.num.length;
        switch (index) {
            case 0: {
                double w = x[0];
                double m = x[1];
                for (int j = 0; j < numExs; ++j) {
                    if (Double.isNaN(this.xBar[j])) continue;
                    h[0] = h[0] + (2.0 * Math.pow(this.num[j], 3.0) * (m - this.xBar[j]) * (m - this.xBar[j]) / Math.pow(w * this.num[j] + this.sSq, 3.0) - this.num[j] * this.num[j] / ((w * this.num[j] + this.sSq) * (w * this.num[j] + this.sSq)));
                    h[1] = h[1] - 2.0 * (m - this.xBar[j]) * this.num[j] * this.num[j] / ((this.num[j] * w + this.sSq) * (this.num[j] * w + this.sSq));
                }
                break;
            }
            case 1: {
                double w = x[0];
                double m = x[1];
                for (int j = 0; j < numExs; ++j) {
                    if (Double.isNaN(this.xBar[j])) continue;
                    h[0] = h[0] - 2.0 * (m - this.xBar[j]) * this.num[j] * this.num[j] / ((this.num[j] * w + this.sSq) * (this.num[j] * w + this.sSq));
                    h[1] = h[1] + 2.0 * this.num[j] / (w * this.num[j] + this.sSq);
                }
                break;
            }
        }
        return h;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5481 $");
    }
}

