/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.evaluation.output.prediction;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.evaluation.output.prediction.AbstractOutput;
import weka.core.Instance;
import weka.core.Option;
import weka.core.Utils;

public class CSV
extends AbstractOutput {
    private static final long serialVersionUID = 3401604538169573720L;
    protected String m_Delimiter = ",";

    public String globalInfo() {
        return "Outputs the predictions as CSV.";
    }

    public String getDisplay() {
        return "CSV";
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.add(enm.nextElement());
        }
        result.addElement(new Option("\tWhether to use TAB as separator instead of comma.\n\t(default: comma)", "use-tab", 0, "-use-tab"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.setUseTab(Utils.getFlag("use-tab", options));
        super.setOptions(options);
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        if (this.getUseTab()) {
            result.add("-use-tab");
        }
        return result.toArray(new String[result.size()]);
    }

    public void setUseTab(boolean value) {
        this.m_Delimiter = value ? "\t" : ",";
    }

    public boolean getUseTab() {
        return this.m_Delimiter.equals("\t");
    }

    public String useTabTipText() {
        return "Whether to use TAB instead of COMMA as column separator.";
    }

    protected void doPrintHeader() {
        if (this.m_Header.classAttribute().isNominal()) {
            if (this.m_OutputDistribution) {
                this.append("inst#" + this.m_Delimiter + "actual" + this.m_Delimiter + "predicted" + this.m_Delimiter + "error" + this.m_Delimiter + "distribution");
                for (int i = 1; i < this.m_Header.classAttribute().numValues(); ++i) {
                    this.append(this.m_Delimiter);
                }
            } else {
                this.append("inst#" + this.m_Delimiter + "actual" + this.m_Delimiter + "predicted" + this.m_Delimiter + "error" + this.m_Delimiter + "prediction");
            }
        } else {
            this.append("inst#" + this.m_Delimiter + "actual" + this.m_Delimiter + "predicted" + this.m_Delimiter + "error");
        }
        if (this.m_Attributes != null) {
            this.append(this.m_Delimiter);
            boolean first = true;
            for (int i = 0; i < this.m_Header.numAttributes(); ++i) {
                if (i == this.m_Header.classIndex() || !this.m_Attributes.isInRange(i)) continue;
                if (!first) {
                    this.append(this.m_Delimiter);
                }
                this.append(this.m_Header.attribute(i).name());
                first = false;
            }
        }
        this.append("\n");
    }

    protected String attributeValuesString(Instance instance) {
        StringBuffer text = new StringBuffer();
        if (this.m_Attributes != null) {
            this.m_Attributes.setUpper(instance.numAttributes() - 1);
            boolean first = true;
            for (int i = 0; i < instance.numAttributes(); ++i) {
                if (!this.m_Attributes.isInRange(i) || i == instance.classIndex()) continue;
                if (!first) {
                    text.append(this.m_Delimiter);
                }
                text.append(instance.toString(i));
                first = false;
            }
        }
        return text.toString();
    }

    protected void doPrintClassification(Classifier classifier, Instance inst, int index) throws Exception {
        int prec = this.m_NumDecimals;
        Instance withMissing = (Instance)inst.copy();
        withMissing.setDataset(inst.dataset());
        withMissing.setMissing(withMissing.classIndex());
        double predValue = classifier.classifyInstance(withMissing);
        this.append("" + (index + 1));
        if (inst.dataset().classAttribute().isNumeric()) {
            if (inst.classIsMissing()) {
                this.append(this.m_Delimiter + "?");
            } else {
                this.append(this.m_Delimiter + Utils.doubleToString(inst.classValue(), prec));
            }
            if (Utils.isMissingValue(predValue)) {
                this.append(this.m_Delimiter + "?");
            } else {
                this.append(this.m_Delimiter + Utils.doubleToString(predValue, prec));
            }
            if (Utils.isMissingValue(predValue) || inst.classIsMissing()) {
                this.append(this.m_Delimiter + "?");
            } else {
                this.append(this.m_Delimiter + Utils.doubleToString(predValue - inst.classValue(), prec));
            }
        } else {
            this.append(this.m_Delimiter + ((int)inst.classValue() + 1) + ":" + inst.toString(inst.classIndex()));
            if (Utils.isMissingValue(predValue)) {
                this.append(this.m_Delimiter + "?");
            } else {
                this.append(this.m_Delimiter + ((int)predValue + 1) + ":" + inst.dataset().classAttribute().value((int)predValue));
            }
            if (!Utils.isMissingValue(predValue) && !inst.classIsMissing() && (int)predValue + 1 != (int)inst.classValue() + 1) {
                this.append(this.m_Delimiter + "+");
            } else {
                this.append(this.m_Delimiter + "");
            }
            if (this.m_OutputDistribution) {
                if (Utils.isMissingValue(predValue)) {
                    this.append(this.m_Delimiter + "?");
                } else {
                    this.append(this.m_Delimiter);
                    double[] dist = classifier.distributionForInstance(withMissing);
                    for (int n = 0; n < dist.length; ++n) {
                        if (n > 0) {
                            this.append(this.m_Delimiter);
                        }
                        if (n == (int)predValue) {
                            this.append("*");
                        }
                        this.append(Utils.doubleToString(dist[n], prec));
                    }
                }
            } else if (Utils.isMissingValue(predValue)) {
                this.append(this.m_Delimiter + "?");
            } else {
                this.append(this.m_Delimiter + Utils.doubleToString(classifier.distributionForInstance(withMissing)[(int)predValue], prec));
            }
        }
        if (this.m_Attributes != null) {
            this.append(this.m_Delimiter + this.attributeValuesString(withMissing));
        }
        this.append("\n");
    }

    protected void doPrintFooter() {
    }
}

