/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.SubsetEvaluator;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.supervised.attribute.Discretize;

public class ConsistencySubsetEval
extends ASEvaluation
implements SubsetEvaluator,
TechnicalInformationHandler {
    static final long serialVersionUID = -2880323763295270402L;
    private Instances m_trainInstances;
    private int m_classIndex;
    private int m_numAttribs;
    private int m_numInstances;
    private Discretize m_disTransform;
    private Hashtable m_table;

    public String globalInfo() {
        return "ConsistencySubsetEval :\n\nEvaluates the worth of a subset of attributes by the level of consistency in the class values when the training instances are projected onto the subset of attributes. \n\nConsistency of any subset can never be lower than that of the full set of attributes, hence the usual practice is to use this subset evaluator in conjunction with a Random or Exhaustive search which looks for the smallest subset with consistency equal to that of the full set of attributes.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "H. Liu and R. Setiono");
        result.setValue(TechnicalInformation.Field.TITLE, "A probabilistic approach to feature selection - A filter solution");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "13th International Conference on Machine Learning");
        result.setValue(TechnicalInformation.Field.YEAR, "1996");
        result.setValue(TechnicalInformation.Field.PAGES, "319-327");
        return result;
    }

    public ConsistencySubsetEval() {
        this.resetOptions();
    }

    private void resetOptions() {
        this.m_trainInstances = null;
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    public void buildEvaluator(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        this.m_trainInstances = new Instances(data);
        this.m_trainInstances.deleteWithMissingClass();
        this.m_classIndex = this.m_trainInstances.classIndex();
        this.m_numAttribs = this.m_trainInstances.numAttributes();
        this.m_numInstances = this.m_trainInstances.numInstances();
        this.m_disTransform = new Discretize();
        this.m_disTransform.setUseBetterEncoding(true);
        this.m_disTransform.setInputFormat(this.m_trainInstances);
        this.m_trainInstances = Filter.useFilter(this.m_trainInstances, this.m_disTransform);
    }

    public double evaluateSubset(BitSet subset) throws Exception {
        int i;
        int count = 0;
        for (i = 0; i < this.m_numAttribs; ++i) {
            if (!subset.get(i)) continue;
            ++count;
        }
        double[] instArray = new double[count];
        int index = 0;
        int[] fs = new int[count];
        for (i = 0; i < this.m_numAttribs; ++i) {
            if (!subset.get(i)) continue;
            fs[index++] = i;
        }
        this.m_table = new Hashtable((int)((double)this.m_numInstances * 1.5));
        for (i = 0; i < this.m_numInstances; ++i) {
            Instance inst = this.m_trainInstances.instance(i);
            for (int j = 0; j < fs.length; ++j) {
                if (fs[j] == this.m_classIndex) {
                    throw new Exception("A subset should not contain the class!");
                }
                instArray[j] = inst.isMissing(fs[j]) ? Double.MAX_VALUE : inst.value(fs[j]);
            }
            this.insertIntoTable(inst, instArray);
        }
        return this.consistencyCount();
    }

    private double consistencyCount() {
        Enumeration e = this.m_table.keys();
        double count = 0.0;
        while (e.hasMoreElements()) {
            hashKey tt = (hashKey)e.nextElement();
            double[] classDist = (double[])this.m_table.get(tt);
            count += Utils.sum(classDist);
            int max = Utils.maxIndex(classDist);
            count -= classDist[max];
        }
        return 1.0 - (count /= (double)this.m_numInstances);
    }

    private void insertIntoTable(Instance inst, double[] instA) throws Exception {
        hashKey thekey = new hashKey(instA);
        double[] tempClassDist2 = (double[])this.m_table.get(thekey);
        if (tempClassDist2 == null) {
            double[] newDist = new double[this.m_trainInstances.classAttribute().numValues()];
            newDist[(int)inst.classValue()] = inst.weight();
            this.m_table.put(thekey, newDist);
        } else {
            int n = (int)inst.classValue();
            tempClassDist2[n] = tempClassDist2[n] + inst.weight();
            this.m_table.put(thekey, tempClassDist2);
        }
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        if (this.m_trainInstances == null) {
            text.append("\tConsistency subset evaluator has not been built yet\n");
        } else {
            text.append("\tConsistency Subset Evaluator\n");
        }
        return text.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5447 $");
    }

    public static void main(String[] args) {
        ConsistencySubsetEval.runEvaluator(new ConsistencySubsetEval(), args);
    }

    public class hashKey
    implements Serializable,
    RevisionHandler {
        static final long serialVersionUID = 6144138512017017408L;
        private double[] attributes;
        private boolean[] missing;
        private int key;

        public hashKey(Instance t, int numAtts) throws Exception {
            int cindex = t.classIndex();
            this.key = -999;
            this.attributes = new double[numAtts];
            this.missing = new boolean[numAtts];
            for (int i = 0; i < numAtts; ++i) {
                if (i == cindex) {
                    this.missing[i] = true;
                    continue;
                }
                this.missing[i] = t.isMissing(i);
                if (this.missing[i]) continue;
                this.attributes[i] = t.value(i);
            }
        }

        public String toString(Instances t, int maxColWidth) {
            int cindex = t.classIndex();
            StringBuffer text = new StringBuffer();
            for (int i = 0; i < this.attributes.length; ++i) {
                if (i == cindex) continue;
                if (this.missing[i]) {
                    text.append("?");
                    for (int j = 0; j < maxColWidth; ++j) {
                        text.append(" ");
                    }
                    continue;
                }
                String ss = t.attribute(i).value((int)this.attributes[i]);
                StringBuffer sb = new StringBuffer(ss);
                for (int j = 0; j < maxColWidth - ss.length() + 1; ++j) {
                    sb.append(" ");
                }
                text.append(sb);
            }
            return text.toString();
        }

        public hashKey(double[] t) {
            int l = t.length;
            this.key = -999;
            this.attributes = new double[l];
            this.missing = new boolean[l];
            for (int i = 0; i < l; ++i) {
                if (t[i] == Double.MAX_VALUE) {
                    this.missing[i] = true;
                    continue;
                }
                this.missing[i] = false;
                this.attributes[i] = t[i];
            }
        }

        public int hashCode() {
            int hv = 0;
            if (this.key != -999) {
                return this.key;
            }
            for (int i = 0; i < this.attributes.length; ++i) {
                if (this.missing[i]) {
                    hv += i * 13;
                    continue;
                }
                hv = (int)((double)hv + (double)(i * 5) * (this.attributes[i] + 1.0));
            }
            if (this.key == -999) {
                this.key = hv;
            }
            return hv;
        }

        public boolean equals(Object b) {
            if (b == null || !b.getClass().equals(this.getClass())) {
                return false;
            }
            boolean ok = true;
            if (b instanceof hashKey) {
                hashKey n = (hashKey)b;
                for (int i = 0; i < this.attributes.length; ++i) {
                    boolean l = n.missing[i];
                    if (this.missing[i] || l) {
                        if ((!this.missing[i] || l) && (this.missing[i] || !l)) continue;
                        ok = false;
                    } else {
                        if (this.attributes[i] == n.attributes[i]) continue;
                        ok = false;
                    }
                    break;
                }
            } else {
                return false;
            }
            return ok;
        }

        public void print_hash_code() {
            System.out.println("Hash val: " + this.hashCode());
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5447 $");
        }
    }
}

