/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.clusterers.Clusterer;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.stemmers.Stemmer;
import weka.core.tokenizers.Tokenizer;

public abstract class RWekaInterfaces {
    public static double[] classifyInstances(Classifier classifier, Instances instances) throws Exception {
        int n = instances.numInstances();
        double[] dArray = new double[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            try {
                dArray[i] = classifier.classifyInstance(instances.instance(i));
                continue;
            }
            catch (Exception exception) {
                ++n2;
                dArray[i] = Double.NaN;
            }
        }
        if (n2 > 0) {
            System.out.println(n2 + " instances not classified");
        }
        return dArray;
    }

    public static double[] clusterInstances(Clusterer clusterer, Instances instances) throws Exception {
        int n = instances.numInstances();
        double[] dArray = new double[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            try {
                dArray[i] = clusterer.clusterInstance(instances.instance(i));
                if (!(dArray[i] < 0.0)) continue;
                dArray[i] = Double.NaN;
                continue;
            }
            catch (Exception exception) {
                ++n2;
                dArray[i] = Double.NaN;
            }
        }
        if (n2 > 0) {
            System.out.println(n2 + " instances not classified");
        }
        return dArray;
    }

    public static double[] distributionForInstances(Classifier classifier, Instances instances) throws Exception {
        int n = instances.numInstances();
        int n2 = instances.numClasses();
        double[] dArray = new double[n * n2];
        double[] dArray2 = new double[n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            dArray2 = classifier.distributionForInstance(instances.instance(i));
            int n4 = 0;
            while (n4 < n2) {
                dArray[n3] = dArray2[n4];
                ++n4;
                ++n3;
            }
        }
        return dArray;
    }

    public static double[] distributionForInstances(Clusterer clusterer, Instances instances) throws Exception {
        int n = instances.numInstances();
        int n2 = clusterer.numberOfClusters();
        double[] dArray = new double[n * n2];
        double[] dArray2 = new double[n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            dArray2 = clusterer.distributionForInstance(instances.instance(i));
            int n4 = 0;
            while (n4 < n2) {
                dArray[n3] = dArray2[n4];
                ++n4;
                ++n3;
            }
        }
        return dArray;
    }

    public static void addInstances(Instances instances, double[] dArray, int n) throws Exception {
        int n2 = instances.numAttributes();
        if (dArray.length / n2 != n) {
            throw new Exception("invalid number of rows 'nrow'");
        }
        for (int i = 0; i < n; ++i) {
            DenseInstance denseInstance = new DenseInstance(n2);
            for (int j = 0; j < n2; ++j) {
                denseInstance.setValue(j, dArray[i + j * n]);
            }
            instances.add((Instance)denseInstance);
        }
    }

    public static double[] getAttributeWeights(Instances instances) throws Exception {
        int n = instances.numAttributes();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = instances.attribute(i).weight();
        }
        return dArray;
    }

    public static double[] getInstanceWeights(Instances instances) throws Exception {
        int n = instances.numInstances();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = instances.instance(i).weight();
        }
        return dArray;
    }

    public static String[] stem(Stemmer stemmer, String[] stringArray) throws Exception {
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = stemmer.stem(stringArray[i]);
        }
        return stringArray2;
    }

    public static String[] formatDate(Attribute attribute, double[] dArray, String string) {
        String[] stringArray = new String[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            stringArray[i] = Double.isNaN(dArray[i]) ? string : attribute.formatDate(dArray[i]);
        }
        return stringArray;
    }

    public static double[] parseDate(Attribute attribute, String[] stringArray, String string) {
        double[] dArray = new double[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                if (stringArray[i].equals(string)) {
                    dArray[i] = Double.NaN;
                    continue;
                }
                dArray[i] = attribute.parseDate(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                dArray[i] = Double.NaN;
            }
        }
        return dArray;
    }

    public static String[] tokenize(Tokenizer tokenizer, String[] stringArray, String[] stringArray2) throws Exception {
        tokenizer.setOptions(stringArray);
        Vector vector = new Vector();
        for (int i = 0; i < stringArray2.length; ++i) {
            if (stringArray2[i].length() == 0) continue;
            tokenizer.tokenize(stringArray2[i]);
            Vector<String> vector2 = new Vector<String>();
            while (tokenizer.hasMoreElements()) {
                vector2.add(tokenizer.nextElement());
            }
            vector.addAll(vector2);
        }
        return vector.toArray(new String[vector.size()]);
    }
}

