/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.RandomizableSingleClassifierEnhancer;
import weka.classifiers.meta.Bagging;
import weka.classifiers.meta.generators.GaussianGenerator;
import weka.classifiers.meta.generators.Generator;
import weka.classifiers.meta.generators.InstanceHandler;
import weka.classifiers.meta.generators.Mean;
import weka.classifiers.meta.generators.NominalAttributeGenerator;
import weka.classifiers.meta.generators.NominalGenerator;
import weka.classifiers.meta.generators.NumericAttributeGenerator;
import weka.classifiers.meta.generators.Ranged;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.AddValues;
import weka.filters.unsupervised.attribute.MergeManyValues;

public class OneClassClassifier
extends RandomizableSingleClassifierEnhancer
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 6199125385010158931L;
    protected double m_TargetRejectionRate = 0.1;
    protected double m_Threshold = 0.5;
    protected ArrayList m_Generators;
    protected String m_TargetClassLabel = "target";
    protected int m_NumRepeats = 10;
    protected double m_PercentHeldout = 10.0;
    protected double m_ProportionGenerated = 0.5;
    protected NumericAttributeGenerator m_DefaultNumericGenerator = new GaussianGenerator();
    protected NominalAttributeGenerator m_DefaultNominalGenerator = new NominalGenerator();
    protected AddValues m_AddOutlierFilter;
    protected boolean m_UseLaplaceCorrection = false;
    protected MergeManyValues m_MergeFilter;
    public static final String OUTLIER_LABEL = "outlier";
    protected boolean m_UseDensityOnly = false;
    protected boolean m_UseInstanceWeights = false;
    protected Random m_Random;

    public OneClassClassifier() {
        this.m_Classifier = new Bagging();
    }

    public String globalInfo() {
        return "Performs one-class classification on a dataset.\n\nClassifier reduces the class being classified to just a single class, and learns the datawithout using any information from other classes.  The testing stage will classify as 'target'or 'outlier' - so in order to calculate the outlier pass rate the dataset must contain informationfrom more than one class.\n\nAlso, the output varies depending on whether the label 'outlier' exists in the instances usedto build the classifier.  If so, then 'outlier' will be predicted, if not, then the label willbe considered missing when the prediction does not favour the target class.  The 'outlier' classwill not be used to build the model if there are instances of this class in the dataset.  It cansimply be used as a flag, you do not need to relabel any classes.\n\nFor more information, see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.CONFERENCE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Kathryn Hempstalk and Eibe Frank and Ian H. Witten");
        result.setValue(TechnicalInformation.Field.YEAR, "2008");
        result.setValue(TechnicalInformation.Field.TITLE, "One-Class Classification by Combining Density and Class Probability Estimation");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Proceedings of the 12th European Conference on Principles and Practice of Knowledge Discovery in Databases and 19th European Conference on Machine Learning, ECMLPKDD2008");
        result.setValue(TechnicalInformation.Field.VOLUME, "Vol. 5211");
        result.setValue(TechnicalInformation.Field.PAGES, "505--519");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Springer");
        result.setValue(TechnicalInformation.Field.ADDRESS, "Berlin");
        result.setValue(TechnicalInformation.Field.SERIES, "Lecture Notes in Computer Science");
        result.setValue(TechnicalInformation.Field.LOCATION, "Antwerp, Belgium");
        result.setValue(TechnicalInformation.Field.MONTH, "September");
        return result;
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tSets the target rejection rate\n\t(default: 0.1)", "trr", 1, "-trr <rate>"));
        result.addElement(new Option("\tSets the target class label\n\t(default: 'target')", "tcl", 1, "-tcl <label>"));
        result.addElement(new Option("\tSets the number of times to repeat cross validation\n\tto find the threshold\n\t(default: 10)", "cvr", 1, "-cvr <rep>"));
        result.addElement(new Option("\tSets the proportion of generated data\n\t(default: 0.5)", "P", 1, "-P <prop>"));
        result.addElement(new Option("\tSets the percentage of heldout data for each cross validation\n\tfold\n\t(default: 10)", "cvf", 1, "-cvf <perc>"));
        result.addElement(new Option("\tSets the numeric generator\n\t(default: " + GaussianGenerator.class.getName() + ")", "num", 1, "-num <classname + options>"));
        result.addElement(new Option("\tSets the nominal generator\n\t(default: " + NominalGenerator.class.getName() + ")", "nom", 1, "-nom <classname + options>"));
        result.addElement(new Option("\tSets whether to correct the number of classes to two,\n\tif omitted no correction will be made.", "L", 1, "-L"));
        result.addElement(new Option("\tSets whether to exclusively use the density estimate.", "E", 0, "-E"));
        result.addElement(new Option("\tSets whether to use instance weights.", "I", 0, "-I"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            result.addElement((Option)enu.nextElement());
        }
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String[] tmpOptions;
        String tmpStr = Utils.getOption("num", options);
        if (tmpStr.length() != 0) {
            tmpOptions = Utils.splitOptions(tmpStr);
            tmpStr = tmpOptions[0];
            tmpOptions[0] = "";
            this.setNumericGenerator((NumericAttributeGenerator)Utils.forName(Generator.class, tmpStr, tmpOptions));
        } else {
            this.setNumericGenerator((NumericAttributeGenerator)Utils.forName(Generator.class, this.defaultNumericGeneratorString(), null));
        }
        tmpStr = Utils.getOption("nom", options);
        if (tmpStr.length() != 0) {
            tmpOptions = Utils.splitOptions(tmpStr);
            tmpStr = tmpOptions[0];
            tmpOptions[0] = "";
            this.setNominalGenerator((NominalAttributeGenerator)Utils.forName(Generator.class, tmpStr, tmpOptions));
        } else {
            this.setNominalGenerator((NominalAttributeGenerator)Utils.forName(Generator.class, this.defaultNominalGeneratorString(), null));
        }
        tmpStr = Utils.getOption("trr", options);
        if (tmpStr.length() != 0) {
            this.setTargetRejectionRate(Double.parseDouble(tmpStr));
        } else {
            this.setTargetRejectionRate(0.1);
        }
        tmpStr = Utils.getOption("tcl", options);
        if (tmpStr.length() != 0) {
            this.setTargetClassLabel(tmpStr);
        } else {
            this.setTargetClassLabel("target");
        }
        tmpStr = Utils.getOption("cvr", options);
        if (tmpStr.length() != 0) {
            this.setNumRepeats(Integer.parseInt(tmpStr));
        } else {
            this.setNumRepeats(10);
        }
        tmpStr = Utils.getOption("cvf", options);
        if (tmpStr.length() != 0) {
            this.setPercentageHeldout(Double.parseDouble(tmpStr));
        } else {
            this.setPercentageHeldout(10.0);
        }
        tmpStr = Utils.getOption("P", options);
        if (tmpStr.length() != 0) {
            this.setProportionGenerated(Double.parseDouble(tmpStr));
        } else {
            this.setProportionGenerated(0.5);
        }
        this.setUseLaplaceCorrection(Utils.getFlag('L', options));
        this.setDensityOnly(Utils.getFlag('E', options));
        this.setUseInstanceWeights(Utils.getFlag('I', options));
        super.setOptions(options);
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-num");
        result.add(this.m_DefaultNumericGenerator.getClass().getName() + " " + Utils.joinOptions(((Generator)((Object)this.m_DefaultNumericGenerator)).getOptions()));
        result.add("-nom");
        result.add(this.m_DefaultNominalGenerator.getClass().getName() + " " + Utils.joinOptions(((Generator)((Object)this.m_DefaultNominalGenerator)).getOptions()));
        result.add("-trr");
        result.add("" + this.m_TargetRejectionRate);
        result.add("-tcl");
        result.add("" + this.m_TargetClassLabel);
        result.add("-cvr");
        result.add("" + this.m_NumRepeats);
        result.add("-cvf");
        result.add("" + this.m_PercentHeldout);
        result.add("-P");
        result.add("" + this.m_ProportionGenerated);
        if (this.m_UseLaplaceCorrection) {
            result.add("-L");
        }
        if (this.m_UseDensityOnly) {
            result.add("-E");
        }
        if (this.m_UseInstanceWeights) {
            result.add("-I");
        }
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    public boolean getDensityOnly() {
        return this.m_UseDensityOnly;
    }

    public void setDensityOnly(boolean density) {
        this.m_UseDensityOnly = density;
    }

    public String densityOnlyTipText() {
        return "If true, the density estimate will be used by itself.";
    }

    public double getTargetRejectionRate() {
        return this.m_TargetRejectionRate;
    }

    public void setTargetRejectionRate(double rate) {
        this.m_TargetRejectionRate = rate;
    }

    public String targetRejectionRateTipText() {
        return "The target rejection rate, ie, the proportion of target class samples that will be rejected in order to build a threshold.";
    }

    public String getTargetClassLabel() {
        return this.m_TargetClassLabel;
    }

    public void setTargetClassLabel(String label) {
        this.m_TargetClassLabel = label;
    }

    public String targetClassLabelTipText() {
        return "The class label to perform one-class classification on.";
    }

    public int getNumRepeats() {
        return this.m_NumRepeats;
    }

    public void setNumRepeats(int repeats) {
        this.m_NumRepeats = repeats;
    }

    public String numRepeatsTipText() {
        return "The number of repeats for (internal) cross-validation.";
    }

    public void setProportionGenerated(double prop) {
        this.m_ProportionGenerated = prop;
    }

    public double getProportionGenerated() {
        return this.m_ProportionGenerated;
    }

    public String proportionGeneratedTipText() {
        return "The proportion of data that will be generated compared to the target class label.";
    }

    public void setPercentageHeldout(double percent) {
        this.m_PercentHeldout = percent;
    }

    public double getPercentageHeldout() {
        return this.m_PercentHeldout;
    }

    public String percentageHeldoutTipText() {
        return "The percentage of data that will be heldout in each iteration of (internal) cross-validation.";
    }

    public NumericAttributeGenerator getNumericGenerator() {
        return this.m_DefaultNumericGenerator;
    }

    public void setNumericGenerator(NumericAttributeGenerator agen) {
        this.m_DefaultNumericGenerator = agen;
    }

    public String numericGeneratorTipText() {
        return "The numeric data generator to use.";
    }

    public NominalAttributeGenerator getNominalGenerator() {
        return this.m_DefaultNominalGenerator;
    }

    public void setNominalGenerator(NominalAttributeGenerator agen) {
        this.m_DefaultNominalGenerator = agen;
    }

    public String nominalGeneratorTipText() {
        return "The nominal data generator to use.";
    }

    public boolean getUseLaplaceCorrection() {
        return this.m_UseLaplaceCorrection;
    }

    public void setUseLaplaceCorrection(boolean newuse) {
        this.m_UseLaplaceCorrection = newuse;
    }

    public String useLaplaceCorrectionTipText() {
        return "If true, then Laplace correction will be used (reduces the number of class labels to two, target and outlier class, regardless of how many class labels actually exist) - useful for classifiers that use the number of class labels to make use of a Laplace value based on the unseen class.";
    }

    public void setUseInstanceWeights(boolean newuse) {
        this.m_UseInstanceWeights = newuse;
    }

    public boolean getUseInstanceWeights() {
        return this.m_UseInstanceWeights;
    }

    public String useInstanceWeightsTipText() {
        return "If true, the weighting on instances is based on their prevalence in the data.";
    }

    protected String defaultClassifierString() {
        return "weka.classifiers.meta.Bagging";
    }

    protected String defaultNumericGeneratorString() {
        return "weka.classifiers.meta.generators.GaussianGenerator";
    }

    protected String defaultNominalGeneratorString() {
        return "weka.classifiers.meta.generators.NominalGenerator";
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAllClasses();
        result.disableAllClassDependencies();
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        return result;
    }

    public void buildClassifier(Instances data) throws Exception {
        int j;
        int attCount;
        Instance anInst;
        int i;
        if (this.m_Classifier == null) {
            throw new Exception("No base classifier has been set!");
        }
        this.getCapabilities().testWithFail(data);
        Instances newData = new Instances(data);
        this.m_Random = new Random(this.m_Seed);
        Attribute classAttribute = newData.classAttribute();
        double targetClassValue = classAttribute.indexOfValue(this.m_TargetClassLabel);
        if (targetClassValue == -1.0) {
            throw new Exception("Target class value doesn't exist!");
        }
        int index = 0;
        while (index < newData.numInstances()) {
            Instance aninst = newData.instance(index);
            if (aninst.classValue() != targetClassValue) {
                newData.delete(index);
                continue;
            }
            ++index;
        }
        if (newData.numInstances() == 0) {
            throw new Exception("No instances found belonging to the target class!");
        }
        this.m_AddOutlierFilter = new AddValues();
        this.m_AddOutlierFilter.setAttributeIndex("" + (newData.classIndex() + 1));
        this.m_AddOutlierFilter.setLabels(OUTLIER_LABEL);
        this.m_AddOutlierFilter.setInputFormat(newData);
        newData = Filter.useFilter(newData, this.m_AddOutlierFilter);
        if (this.m_UseLaplaceCorrection) {
            newData = this.mergeToTwo(newData);
        }
        this.m_Generators = new ArrayList();
        int numAttributes = newData.numAttributes();
        double[] lowranges = new double[numAttributes - 1];
        double[] highranges = new double[numAttributes - 1];
        double[] means = new double[numAttributes - 1];
        double[] stddevs = new double[numAttributes - 1];
        double[] instanceCount = new double[numAttributes - 1];
        int[] attrIndexes = new int[numAttributes - 1];
        for (i = 0; i < numAttributes - 1; ++i) {
            lowranges[i] = Double.MAX_VALUE;
            highranges[i] = -1.7976931348623157E308;
            means[i] = 0.0;
            stddevs[i] = 0.0;
            attrIndexes[i] = 0;
            instanceCount[i] = 0.0;
        }
        for (i = 0; i < newData.numInstances(); ++i) {
            anInst = newData.instance(i);
            attCount = 0;
            for (j = 0; j < numAttributes; ++j) {
                if (j == newData.classIndex()) continue;
                double attVal = anInst.value(j);
                if (!anInst.isMissing(j)) {
                    if (attVal > highranges[attCount]) {
                        highranges[attCount] = attVal;
                    }
                    if (attVal < lowranges[attCount]) {
                        lowranges[attCount] = attVal;
                    }
                    int n = attCount;
                    means[n] = means[n] + attVal;
                    int n2 = attCount;
                    instanceCount[n2] = instanceCount[n2] + 1.0;
                }
                attrIndexes[attCount] = j;
                ++attCount;
            }
        }
        for (i = 0; i < numAttributes - 1; ++i) {
            if (!(instanceCount[i] > 0.0)) continue;
            means[i] = means[i] / instanceCount[i];
        }
        for (i = 0; i < newData.numInstances(); ++i) {
            anInst = newData.instance(i);
            attCount = 0;
            for (j = 0; j < numAttributes - 1; ++j) {
                if (!(instanceCount[j] > 0.0)) continue;
                int n = attCount;
                stddevs[n] = stddevs[n] + Math.pow(anInst.value(j) - means[attCount], 2.0);
                ++attCount;
            }
        }
        for (i = 0; i < numAttributes - 1; ++i) {
            if (!(instanceCount[i] > 0.0)) continue;
            stddevs[i] = Math.sqrt(stddevs[i] / instanceCount[i]);
        }
        for (i = 0; i < numAttributes - 1; ++i) {
            Generator agen;
            if (newData.attribute(attrIndexes[i]).isNominal()) {
                agen = ((Generator)((Object)this.m_DefaultNominalGenerator)).copy();
                ((NominalAttributeGenerator)((Object)agen)).buildGenerator(newData, newData.attribute(attrIndexes[i]));
            } else {
                agen = ((Generator)((Object)this.m_DefaultNumericGenerator)).copy();
                if (agen instanceof Ranged) {
                    ((Ranged)((Object)agen)).setLowerRange(lowranges[i]);
                    ((Ranged)((Object)agen)).setUpperRange(highranges[i]);
                }
                if (agen instanceof Mean) {
                    ((Mean)((Object)agen)).setMean(means[i]);
                    ((Mean)((Object)agen)).setStandardDeviation(stddevs[i]);
                }
                if (agen instanceof InstanceHandler) {
                    StringBuffer sb = new StringBuffer("@relation OneClass-SingleAttribute\n\n");
                    sb.append("@attribute tempName numeric\n\n");
                    sb.append("@data\n\n");
                    Enumeration instancesEnum = newData.enumerateInstances();
                    while (instancesEnum.hasMoreElements()) {
                        Instance aninst = (Instance)instancesEnum.nextElement();
                        if (aninst.isMissing(attrIndexes[i])) continue;
                        sb.append("" + aninst.value(attrIndexes[i]) + "\n");
                    }
                    sb.append("\n\n");
                    Instances removed = new Instances(new StringReader(sb.toString()));
                    removed.deleteWithMissing(0);
                    ((InstanceHandler)((Object)agen)).buildGenerator(removed);
                }
            }
            this.m_Generators.add(agen);
        }
        ArrayList<Double> thresholds = new ArrayList<Double>();
        for (int i2 = 0; i2 < this.m_NumRepeats; ++i2) {
            Instances copyData = new Instances(newData);
            Instances heldout = new Instances(newData, 0);
            int k = 0;
            while ((double)k < (double)newData.numInstances() / this.m_PercentHeldout) {
                int anindex = this.m_Random.nextInt(copyData.numInstances());
                heldout.add(copyData.instance(anindex));
                copyData.delete(anindex);
                ++k;
            }
            this.generateData(copyData);
            if (!this.m_UseDensityOnly) {
                this.m_Classifier.buildClassifier(copyData);
            }
            double[] scores = new double[heldout.numInstances()];
            Enumeration iterInst = heldout.enumerateInstances();
            int classIndex = heldout.classAttribute().indexOfValue(this.m_TargetClassLabel);
            int count = 0;
            while (iterInst.hasMoreElements()) {
                Instance anInst2 = (Instance)iterInst.nextElement();
                scores[count] = this.getProbXGivenC(anInst2, classIndex);
                ++count;
            }
            Arrays.sort(scores);
            int passposition = (int)((double)heldout.numInstances() * this.m_TargetRejectionRate);
            if (passposition >= heldout.numInstances()) {
                passposition = heldout.numInstances() - 1;
            }
            thresholds.add(new Double(scores[passposition]));
        }
        this.m_Threshold = 0.0;
        for (int k = 0; k < thresholds.size(); ++k) {
            this.m_Threshold += ((Double)thresholds.get(k)).doubleValue();
        }
        this.m_Threshold /= (double)thresholds.size();
        this.generateData(newData);
        if (!this.m_UseDensityOnly) {
            this.m_Classifier.buildClassifier(newData);
        }
    }

    protected Instances mergeToTwo(Instances newData) throws Exception {
        this.m_MergeFilter = new MergeManyValues();
        this.m_MergeFilter.setAttributeIndex("" + (newData.classIndex() + 1));
        StringBuffer sb = new StringBuffer("");
        Attribute theAttr = newData.classAttribute();
        for (int i = 0; i < theAttr.numValues(); ++i) {
            if (theAttr.value(i).equalsIgnoreCase(OUTLIER_LABEL) || theAttr.value(i).equalsIgnoreCase(this.m_TargetClassLabel)) continue;
            sb.append(i + 1 + ",");
        }
        String mergeList = sb.toString();
        if (mergeList.length() != 0) {
            mergeList = mergeList.substring(0, mergeList.length() - 1);
            int classIndex = newData.classIndex();
            newData.setClassIndex(-1);
            this.m_MergeFilter.setMergeValueRange(mergeList);
            this.m_MergeFilter.setLabel(OUTLIER_LABEL);
            this.m_MergeFilter.setInputFormat(newData);
            newData = Filter.useFilter(newData, this.m_MergeFilter);
            newData.setClassIndex(classIndex);
        } else {
            this.m_MergeFilter = null;
        }
        return newData;
    }

    protected double getProbXGivenC(Instance instance, int targetClassIndex) throws Exception {
        double probC = 1.0 - this.m_ProportionGenerated;
        double probXgivenA = 0.0;
        int count = 0;
        for (int i = 0; i < instance.numAttributes(); ++i) {
            if (i == instance.classIndex()) continue;
            Generator agen = (Generator)this.m_Generators.get(count);
            if (!instance.isMissing(i)) {
                probXgivenA += agen.getLogProbabilityOf(instance.value(i));
            }
            ++count;
        }
        if (this.m_UseDensityOnly) {
            return probXgivenA;
        }
        double[] distribution = this.m_Classifier.distributionForInstance(instance);
        double probCgivenX = distribution[targetClassIndex];
        if (probCgivenX == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        double top = Math.log(1.0 - probC) + Math.log(probCgivenX);
        double bottom = Math.log(probC) + Math.log(1.0 - probCgivenX);
        return top - bottom + probXgivenA;
    }

    protected Instances generateData(Instances targetData) {
        double totalInstances = (double)targetData.numInstances() / (1.0 - this.m_ProportionGenerated);
        int numInstances = (int)(totalInstances - (double)targetData.numInstances());
        if (this.m_UseInstanceWeights) {
            for (int i = 0; i < targetData.numInstances(); ++i) {
                targetData.instance(i).setWeight(0.5 * (1.0 / (1.0 - this.m_ProportionGenerated)));
            }
        }
        for (int j = 0; j < numInstances; ++j) {
            DenseInstance anInst = new DenseInstance(targetData.numAttributes());
            anInst.setDataset(targetData);
            int position = 0;
            for (int i = 0; i < targetData.numAttributes(); ++i) {
                if (targetData.classIndex() != i) {
                    Generator agen = (Generator)this.m_Generators.get(position);
                    anInst.setValue(i, agen.generate());
                    ++position;
                    continue;
                }
                anInst.setValue(i, OUTLIER_LABEL);
                if (!this.m_UseInstanceWeights) continue;
                anInst.setWeight(0.5 * (1.0 / this.m_ProportionGenerated));
            }
            targetData.add(anInst);
        }
        return targetData;
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        Instance filtered = (Instance)instance.copy();
        this.m_AddOutlierFilter.input(instance);
        filtered = this.m_AddOutlierFilter.output();
        if (this.m_UseLaplaceCorrection && this.m_MergeFilter != null) {
            this.m_MergeFilter.input(filtered);
            filtered = this.m_MergeFilter.output();
        }
        double[] dist = new double[instance.numClasses()];
        double probForOutlierClass = 1.0 / (1.0 + Math.exp(this.getProbXGivenC(filtered, filtered.classAttribute().indexOfValue(this.m_TargetClassLabel)) - this.m_Threshold));
        if (this.getProbXGivenC(filtered, filtered.classAttribute().indexOfValue(this.m_TargetClassLabel)) == Double.POSITIVE_INFINITY) {
            probForOutlierClass = 0.0;
        }
        dist[instance.classAttribute().indexOfValue((String)this.m_TargetClassLabel)] = 1.0 - probForOutlierClass;
        if (instance.classAttribute().indexOfValue(OUTLIER_LABEL) == -1) {
            dist[instance.classAttribute().indexOfValue((String)this.m_TargetClassLabel)] = this.getProbXGivenC(filtered, filtered.classAttribute().indexOfValue(this.m_TargetClassLabel)) >= this.m_Threshold ? 1.0 : 0.0;
        } else {
            dist[instance.classAttribute().indexOfValue((String)OUTLIER_LABEL)] = probForOutlierClass;
        }
        return dist;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("\n\nClassifier Model\n" + this.m_Classifier.toString());
        return result.toString();
    }

    public String getRevision() {
        return "$Revision: 5987 $";
    }

    public static void main(String[] args) {
        OneClassClassifier.runClassifier(new OneClassClassifier(), args);
    }
}

