/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48;

import java.io.Serializable;
import weka.classifiers.trees.j48.Distribution;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;

public abstract class ClassifierSplitModel
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 4280730118393457457L;
    protected Distribution m_distribution;
    protected int m_numSubsets;

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return object;
    }

    public abstract void buildClassifier(Instances var1) throws Exception;

    public final boolean checkModel() {
        return this.m_numSubsets > 0;
    }

    public final double classifyInstance(Instance instance) throws Exception {
        int n = this.whichSubset(instance);
        if (n > -1) {
            return this.m_distribution.maxClass(n);
        }
        return this.m_distribution.maxClass();
    }

    public double classProb(int n, Instance instance, int n2) throws Exception {
        if (n2 > -1) {
            return this.m_distribution.prob(n, n2);
        }
        double[] dArray = this.weights(instance);
        if (dArray == null) {
            return this.m_distribution.prob(n);
        }
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i] * this.m_distribution.prob(n, i);
        }
        return d;
    }

    public double classProbLaplace(int n, Instance instance, int n2) throws Exception {
        if (n2 > -1) {
            return this.m_distribution.laplaceProb(n, n2);
        }
        double[] dArray = this.weights(instance);
        if (dArray == null) {
            return this.m_distribution.laplaceProb(n);
        }
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i] * this.m_distribution.laplaceProb(n, i);
        }
        return d;
    }

    public double codingCost() {
        return 0.0;
    }

    public final Distribution distribution() {
        return this.m_distribution;
    }

    public abstract String leftSide(Instances var1);

    public abstract String rightSide(int var1, Instances var2);

    public final String dumpLabel(int n, Instances instances) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(instances.classAttribute().value(this.m_distribution.maxClass(n)));
        stringBuffer.append(" (" + Utils.roundDouble(this.m_distribution.perBag(n), 2));
        if (Utils.gr(this.m_distribution.numIncorrect(n), 0.0)) {
            stringBuffer.append("/" + Utils.roundDouble(this.m_distribution.numIncorrect(n), 2));
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public final String sourceClass(int n, Instances instances) throws Exception {
        System.err.println("sourceClass");
        return new StringBuffer(this.m_distribution.maxClass(n)).toString();
    }

    public abstract String sourceExpression(int var1, Instances var2);

    public final String dumpModel(Instances instances) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.m_numSubsets; ++i) {
            stringBuffer.append(this.leftSide(instances) + this.rightSide(i, instances) + ": ");
            stringBuffer.append(this.dumpLabel(i, instances) + "\n");
        }
        return stringBuffer.toString();
    }

    public final int numSubsets() {
        return this.m_numSubsets;
    }

    public void resetDistribution(Instances instances) throws Exception {
        this.m_distribution = new Distribution(instances, this);
    }

    public final Instances[] split(Instances instances) throws Exception {
        int n;
        Instances[] instancesArray = new Instances[this.m_numSubsets];
        for (n = 0; n < this.m_numSubsets; ++n) {
            instancesArray[n] = new Instances(instances, instances.numInstances());
        }
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance instance = instances.instance(i);
            double[] dArray = this.weights(instance);
            int n2 = this.whichSubset(instance);
            if (n2 > -1) {
                instancesArray[n2].add(instance);
                continue;
            }
            for (n = 0; n < this.m_numSubsets; ++n) {
                if (!Utils.gr(dArray[n], 0.0)) continue;
                double d = dArray[n] * instance.weight();
                instancesArray[n].add(instance);
                instancesArray[n].lastInstance().setWeight(d);
            }
        }
        for (n = 0; n < this.m_numSubsets; ++n) {
            instancesArray[n].compactify();
        }
        return instancesArray;
    }

    public abstract double[] weights(Instance var1);

    public abstract int whichSubset(Instance var1) throws Exception;
}

