/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.rules.ZeroR;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class WAODE
extends Classifier
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 2170978824284697882L;
    private double[] m_ClassCounts;
    private double[] m_AttCounts;
    private double[][] m_AttAttCounts;
    private double[][][] m_ClassAttAttCounts;
    private int[] m_NumAttValues;
    private int m_TotalAttValues;
    private int m_NumClasses;
    private int m_NumAttributes;
    private int m_NumInstances;
    private int m_ClassIndex;
    private int[] m_StartAttIndex;
    private double[] m_mutualInformation;
    private Instances m_Header = null;
    private boolean m_Internals = false;
    private Classifier m_ZeroR;

    public String globalInfo() {
        return "WAODE contructs the model called Weightily Averaged One-Dependence Estimators.\n\nFor more information, see\n\n" + this.getTechnicalInformation().toString();
    }

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        vector.addElement(new Option("\tWhether to print some more internals.\n\t(default: no)", "I", 0, "-I"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        this.setInternals(Utils.getFlag('I', stringArray));
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        if (this.getInternals()) {
            vector.add("-I");
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String internalsTipText() {
        return "Prints more internals of the classifier.";
    }

    public void setInternals(boolean bl) {
        this.m_Internals = bl;
    }

    public boolean getInternals() {
        return this.m_Internals;
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "L. Jiang and H. Zhang");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Weightily Averaged One-Dependence Estimators");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "Proceedings of the 9th Biennial Pacific Rim International Conference on Artificial Intelligence, PRICAI 2006");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2006");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "970-974");
        technicalInformation.setValue(TechnicalInformation.Field.SERIES, "LNAI");
        technicalInformation.setValue(TechnicalInformation.Field.VOLUME, "4099");
        return technicalInformation;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        int n;
        this.getCapabilities().testWithFail(instances);
        if (instances.numAttributes() == 1) {
            System.err.println("Cannot build model (only class attribute present in data!), using ZeroR model instead!");
            this.m_ZeroR = new ZeroR();
            this.m_ZeroR.buildClassifier(instances);
            return;
        }
        this.m_ZeroR = null;
        this.m_NumClasses = instances.numClasses();
        this.m_ClassIndex = instances.classIndex();
        this.m_NumAttributes = instances.numAttributes();
        this.m_NumInstances = instances.numInstances();
        this.m_TotalAttValues = 0;
        this.m_StartAttIndex = new int[this.m_NumAttributes];
        this.m_NumAttValues = new int[this.m_NumAttributes];
        for (n = 0; n < this.m_NumAttributes; ++n) {
            if (n != this.m_ClassIndex) {
                this.m_StartAttIndex[n] = this.m_TotalAttValues;
                this.m_NumAttValues[n] = instances.attribute(n).numValues();
                this.m_TotalAttValues += this.m_NumAttValues[n];
                continue;
            }
            this.m_StartAttIndex[n] = -1;
            this.m_NumAttValues[n] = this.m_NumClasses;
        }
        this.m_ClassCounts = new double[this.m_NumClasses];
        this.m_AttCounts = new double[this.m_TotalAttValues];
        this.m_AttAttCounts = new double[this.m_TotalAttValues][this.m_TotalAttValues];
        this.m_ClassAttAttCounts = new double[this.m_NumClasses][this.m_TotalAttValues][this.m_TotalAttValues];
        this.m_Header = new Instances(instances, 0);
        for (n = 0; n < this.m_NumInstances; ++n) {
            int n2;
            int n3;
            int n4 = n3 = (int)instances.instance(n).classValue();
            this.m_ClassCounts[n4] = this.m_ClassCounts[n4] + 1.0;
            int[] nArray = new int[this.m_NumAttributes];
            for (n2 = 0; n2 < this.m_NumAttributes; ++n2) {
                if (n2 == this.m_ClassIndex) {
                    nArray[n2] = -1;
                    continue;
                }
                nArray[n2] = this.m_StartAttIndex[n2] + (int)instances.instance(n).value(n2);
                int n5 = nArray[n2];
                this.m_AttCounts[n5] = this.m_AttCounts[n5] + 1.0;
            }
            for (n2 = 0; n2 < this.m_NumAttributes; ++n2) {
                if (nArray[n2] == -1) continue;
                for (int i = 0; i < this.m_NumAttributes; ++i) {
                    if (nArray[i] == -1) continue;
                    double[] dArray = this.m_AttAttCounts[nArray[n2]];
                    int n6 = nArray[i];
                    dArray[n6] = dArray[n6] + 1.0;
                    double[] dArray2 = this.m_ClassAttAttCounts[n3][nArray[n2]];
                    int n7 = nArray[i];
                    dArray2[n7] = dArray2[n7] + 1.0;
                }
            }
        }
        this.m_mutualInformation = new double[this.m_NumAttributes];
        for (n = 0; n < this.m_NumAttributes; ++n) {
            if (n == this.m_ClassIndex) continue;
            this.m_mutualInformation[n] = this.mutualInfo(n);
        }
    }

    private double mutualInfo(int n) {
        int n2;
        int n3;
        double d = 0.0;
        int n4 = this.m_StartAttIndex[n];
        double[] dArray = new double[this.m_NumClasses];
        double[] dArray2 = new double[this.m_NumAttValues[n]];
        double[][] dArray3 = new double[this.m_NumClasses][this.m_NumAttValues[n]];
        for (n3 = 0; n3 < this.m_NumClasses; ++n3) {
            dArray[n3] = this.m_ClassCounts[n3] / (double)this.m_NumInstances;
        }
        for (n3 = 0; n3 < this.m_NumAttValues[n]; ++n3) {
            dArray2[n3] = this.m_AttCounts[n4 + n3] / (double)this.m_NumInstances;
        }
        for (n3 = 0; n3 < this.m_NumClasses; ++n3) {
            for (n2 = 0; n2 < this.m_NumAttValues[n]; ++n2) {
                dArray3[n3][n2] = this.m_ClassAttAttCounts[n3][n4 + n2][n4 + n2] / (double)this.m_NumInstances;
            }
        }
        for (n3 = 0; n3 < this.m_NumClasses; ++n3) {
            for (n2 = 0; n2 < this.m_NumAttValues[n]; ++n2) {
                d += dArray3[n3][n2] * this.log2(dArray3[n3][n2], dArray[n3] * dArray2[n2]);
            }
        }
        return d;
    }

    private double log2(double d, double d2) {
        if (d < Utils.SMALL || d2 < Utils.SMALL) {
            return 0.0;
        }
        return Math.log(d / d2) / Math.log(2.0);
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        int n;
        if (this.m_ZeroR != null) {
            return this.m_ZeroR.distributionForInstance(instance);
        }
        double[] dArray = new double[this.m_NumClasses];
        int[] nArray = new int[this.m_NumAttributes];
        for (n = 0; n < this.m_NumAttributes; ++n) {
            nArray[n] = n == this.m_ClassIndex ? -1 : this.m_StartAttIndex[n] + (int)instance.value(n);
        }
        n = 0;
        while (n < this.m_NumClasses) {
            dArray[n] = 0.0;
            double d = 1.0;
            double d2 = 0.0;
            for (int i = 0; i < this.m_NumAttributes; ++i) {
                if (nArray[i] == -1) continue;
                d = (this.m_ClassAttAttCounts[n][nArray[i]][nArray[i]] + 1.0 / (double)(this.m_NumClasses * this.m_NumAttValues[i])) / ((double)this.m_NumInstances + 1.0);
                for (int j = 0; j < this.m_NumAttributes; ++j) {
                    if (nArray[j] == -1 || j == i) continue;
                    d *= (this.m_ClassAttAttCounts[n][nArray[i]][nArray[j]] + 1.0 / (double)this.m_NumAttValues[j]) / (this.m_ClassAttAttCounts[n][nArray[i]][nArray[i]] + 1.0);
                }
                d2 += this.m_mutualInformation[i];
                int n2 = n;
                dArray[n2] = dArray[n2] + this.m_mutualInformation[i] * d;
            }
            int n3 = n++;
            dArray[n3] = dArray[n3] / d2;
        }
        if (!Double.isNaN(Utils.sum(dArray))) {
            Utils.normalize(dArray);
        }
        return dArray;
    }

    public String toString() {
        StringBuffer stringBuffer;
        if (this.m_ZeroR != null) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(this.getClass().getName().replaceAll(".*\\.", "") + "\n");
            stringBuffer.append(this.getClass().getName().replaceAll(".*\\.", "").replaceAll(".", "=") + "\n\n");
            stringBuffer.append("Warning: No model could be built, hence ZeroR model is used:\n\n");
            stringBuffer.append(this.m_ZeroR.toString());
        } else {
            String string = this.getClass().getName().replaceAll(".*\\.", "");
            stringBuffer = new StringBuffer();
            stringBuffer.append(string + "\n");
            stringBuffer.append(string.replaceAll(".", "=") + "\n\n");
            if (this.m_Header == null) {
                stringBuffer.append("No Model built yet.\n");
            } else if (this.getInternals()) {
                stringBuffer.append("Mutual information of attributes with class attribute:\n");
                for (int i = 0; i < this.m_Header.numAttributes(); ++i) {
                    if (i == this.m_Header.classIndex()) continue;
                    stringBuffer.append(i + 1 + ". " + this.m_Header.attribute(i).name() + ": " + Utils.doubleToString(this.m_mutualInformation[i], 6) + "\n");
                }
            } else {
                stringBuffer.append("Model built successfully.\n");
            }
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        WAODE.runClassifier(new WAODE(), stringArray);
    }
}

