/*
 * Decompiled with CFR 0.152.
 */
package weka.associations;

import java.io.Serializable;
import java.util.Hashtable;
import weka.associations.ItemSet;
import weka.associations.RuleGeneration;
import weka.core.Instances;

public class RuleItem
implements Comparable,
Serializable {
    private static final long serialVersionUID = -3761299128347476534L;
    protected ItemSet m_premise;
    protected ItemSet m_consequence;
    protected double m_accuracy;
    protected int m_genTime;

    public RuleItem() {
    }

    public RuleItem(RuleItem ruleItem) {
        this.m_premise = ruleItem.m_premise;
        this.m_consequence = ruleItem.m_consequence;
        this.m_accuracy = ruleItem.m_accuracy;
        this.m_genTime = ruleItem.m_genTime;
    }

    public RuleItem(ItemSet itemSet, ItemSet itemSet2, int n, int n2, double[] dArray, Hashtable hashtable) {
        this.m_premise = itemSet;
        this.m_consequence = itemSet2;
        this.m_accuracy = RuleGeneration.expectation(n2, this.m_premise.m_counter, dArray, hashtable);
        if (Double.isNaN(this.m_accuracy) || this.m_accuracy < 0.0) {
            this.m_accuracy = Double.MIN_VALUE;
        }
        this.m_consequence.m_counter = n2;
        this.m_genTime = n;
    }

    public RuleItem generateRuleItem(ItemSet itemSet, ItemSet itemSet2, Instances instances, int n, int n2, double[] dArray, Hashtable hashtable) {
        int n3;
        ItemSet itemSet3 = new ItemSet(instances.numInstances());
        itemSet3.m_items = new int[itemSet2.m_items.length];
        System.arraycopy(itemSet.m_items, 0, itemSet3.m_items, 0, itemSet.m_items.length);
        for (n3 = 0; n3 < itemSet2.m_items.length; ++n3) {
            if (itemSet2.m_items[n3] == -1) continue;
            itemSet3.m_items[n3] = itemSet2.m_items[n3];
        }
        for (n3 = 0; n3 < instances.numInstances(); ++n3) {
            itemSet3.upDateCounter(instances.instance(n3));
        }
        n3 = itemSet3.support();
        if (n3 > n2) {
            RuleItem ruleItem = new RuleItem(itemSet, itemSet2, n, n3, dArray, hashtable);
            return ruleItem;
        }
        return null;
    }

    public int compareTo(Object object) {
        if (this.m_accuracy == ((RuleItem)object).m_accuracy) {
            if (this.m_genTime == ((RuleItem)object).m_genTime) {
                return 0;
            }
            if (this.m_genTime > ((RuleItem)object).m_genTime) {
                return -1;
            }
            if (this.m_genTime < ((RuleItem)object).m_genTime) {
                return 1;
            }
        }
        if (this.m_accuracy < ((RuleItem)object).m_accuracy) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return this.m_premise.equals(((RuleItem)object).m_premise) && this.m_consequence.equals(((RuleItem)object).m_consequence);
    }

    public double accuracy() {
        return this.m_accuracy;
    }

    public ItemSet premise() {
        return this.m_premise;
    }

    public ItemSet consequence() {
        return this.m_consequence;
    }
}

