/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.DistanceFunction;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.neighboursearch.PerformanceStats;

public class EuclideanDistance
implements DistanceFunction,
OptionHandler,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1068606253458807903L;
    protected Instances m_Data;
    protected boolean m_DontNormalize = false;
    protected double m_NumAttributesUsed;
    protected double[][] m_Ranges;
    public static final int R_MIN = 0;
    public static final int R_MAX = 1;
    public static final int R_WIDTH = 2;

    public EuclideanDistance() {
    }

    public EuclideanDistance(Instances instances) {
        this.m_Data = instances;
        this.initializeRanges();
        this.setNumAttributesUsed();
    }

    public String globalInfo() {
        return "Implementing Euclidean distance (or similarity) function.\n\nOne object defines not one distance but the data model in which the distances between objects of that data model can be computed.\n\nAttention: For efficiency reasons the use of consistency checks (like are the data models of the two instances exactly the same), is low.";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.add(new Option("\tTurns off the normalization of attribute \n\tvalues in distance calculation.", "D", 0, "-D"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setDontNormalize(Utils.getFlag('D', stringArray));
    }

    public String[] getOptions() {
        String[] stringArray = new String[]{this.getDontNormalize() ? "-D" : ""};
        return stringArray;
    }

    public void setInstances(Instances instances) {
        this.m_Data = instances;
        this.initializeRanges();
        this.setNumAttributesUsed();
    }

    public Instances getInstances() {
        return this.m_Data;
    }

    public String dontNormalizeTipText() {
        return "Whether if the normalization of attributes should be turned off for distance calculation (Default: false i.e. attribute values are normalized). ";
    }

    public void setDontNormalize(boolean bl) {
        this.m_DontNormalize = bl;
    }

    public boolean getDontNormalize() {
        return this.m_DontNormalize;
    }

    public void update(Instance instance) {
        this.updateRanges(instance);
    }

    public double distance(Instance instance, Instance instance2) {
        return Math.sqrt(this.distance(instance, instance2, Double.POSITIVE_INFINITY));
    }

    public double distance(Instance instance, Instance instance2, PerformanceStats performanceStats) {
        return Math.sqrt(this.distance(instance, instance2, Double.POSITIVE_INFINITY, performanceStats, false));
    }

    public double distance(Instance instance, Instance instance2, double d) {
        return this.distance(instance, instance2, d, null, false);
    }

    public double distance(Instance instance, Instance instance2, double d, boolean bl) {
        return this.distance(instance, instance2, d, null, bl);
    }

    public double distance(Instance instance, Instance instance2, double d, PerformanceStats performanceStats) {
        return this.distance(instance, instance2, d, performanceStats, false);
    }

    public double distance(Instance instance, Instance instance2, double d, PerformanceStats performanceStats, boolean bl) {
        double d2 = 0.0;
        if (bl) {
            this.OOPS("Instance1: " + instance);
            this.OOPS("Instance2: " + instance2);
            this.OOPS("cutOffValue: " + d);
        }
        int n = 0;
        int n2 = 0;
        while (n < instance.numValues() || n2 < instance2.numValues()) {
            double d3;
            int n3 = n >= instance.numValues() ? this.m_Data.numAttributes() : instance.index(n);
            int n4 = n2 >= instance2.numValues() ? this.m_Data.numAttributes() : instance2.index(n2);
            if (n3 == this.m_Data.classIndex()) {
                ++n;
                continue;
            }
            if (n4 == this.m_Data.classIndex()) {
                ++n2;
                continue;
            }
            if (bl) {
                System.out.println("valueSparse(p1): " + instance.valueSparse(n) + " valueSparse(p2): " + instance2.valueSparse(n2));
            }
            if (n3 == n4) {
                d3 = this.difference(n3, instance.valueSparse(n), instance2.valueSparse(n2));
                ++n;
                ++n2;
            } else if (n3 > n4) {
                d3 = this.difference(n4, 0.0, instance2.valueSparse(n2));
                ++n2;
            } else {
                d3 = this.difference(n3, instance.valueSparse(n), 0.0);
                ++n;
            }
            if (bl) {
                System.out.println("diff: " + d3);
            }
            if (performanceStats != null) {
                performanceStats.incrCoordCount();
            }
            if ((d2 += d3 * d3) > d) {
                return Double.POSITIVE_INFINITY;
            }
            if (!bl) continue;
            System.out.println("distance: " + d2);
        }
        if (bl) {
            this.OOPS("Instance 1: " + instance);
            this.OOPS("Instance 2: " + instance2);
            this.OOPS("distance: " + d2);
            this.OOPS("AttribsUsed: " + this.m_NumAttributesUsed);
            this.OOPS("distance/AttribsUsed: " + Math.sqrt(d2 / this.m_NumAttributesUsed));
        }
        return d2;
    }

    public void postProcessDistances(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Math.sqrt(dArray[i]);
        }
    }

    private double difference(int n, double d, double d2) {
        switch (this.m_Data.attribute(n).type()) {
            case 1: {
                if (Instance.isMissingValue(d) || Instance.isMissingValue(d2) || (int)d != (int)d2) {
                    return 1.0;
                }
                return 0.0;
            }
            case 0: {
                if (Instance.isMissingValue(d) || Instance.isMissingValue(d2)) {
                    double d3;
                    if (Instance.isMissingValue(d) && Instance.isMissingValue(d2)) {
                        if (!this.m_DontNormalize) {
                            return 1.0;
                        }
                        return this.m_Ranges[n][1] - this.m_Ranges[n][0];
                    }
                    if (Instance.isMissingValue(d2)) {
                        d3 = !this.m_DontNormalize ? this.norm(d, n) : d;
                    } else {
                        double d4 = d3 = !this.m_DontNormalize ? this.norm(d2, n) : d2;
                    }
                    if (!this.m_DontNormalize && d3 < 0.5) {
                        d3 = 1.0 - d3;
                    } else if (this.m_DontNormalize) {
                        if (this.m_Ranges[n][1] - d3 > d3 - this.m_Ranges[n][0]) {
                            return this.m_Ranges[n][1] - d3;
                        }
                        return d3 - this.m_Ranges[n][0];
                    }
                    return d3;
                }
                return !this.m_DontNormalize ? this.norm(d, n) - this.norm(d2, n) : d - d2;
            }
        }
        return 0.0;
    }

    public double sqDifference(int n, double d, double d2) {
        double d3 = this.difference(n, d, d2);
        return d3 * d3;
    }

    private double norm(double d, int n) {
        if (Double.isNaN(this.m_Ranges[n][0]) || this.m_Ranges[n][1] == this.m_Ranges[n][0]) {
            return 0.0;
        }
        return (d - this.m_Ranges[n][0]) / this.m_Ranges[n][2];
    }

    public double getMiddle(double[] dArray) {
        double d = dArray[0] + dArray[2] * 0.5;
        return d;
    }

    public int closestPoint(Instance instance, Instances instances, int[] nArray) throws Exception {
        double d = 2.147483647E9;
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            double d2 = this.distance(instance, instances.instance(nArray[i]), Double.POSITIVE_INFINITY);
            if (!(d2 < d)) continue;
            d = d2;
            n = i;
        }
        return nArray[n];
    }

    public boolean valueIsSmallerEqual(Instance instance, int n, double d) {
        return instance.value(n) <= d;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private void OOPS(String string) {
        System.out.println(string);
    }

    private void setNumAttributesUsed() {
        this.m_NumAttributesUsed = 0.0;
        if (this.m_Data != null) {
            for (int i = 0; i < this.m_Data.numAttributes(); ++i) {
                if (i == this.m_Data.classIndex() || !this.m_Data.attribute(i).isNominal() && !this.m_Data.attribute(i).isNumeric()) continue;
                this.m_NumAttributesUsed += 1.0;
            }
        }
    }

    public double[][] initializeRanges() {
        if (this.m_Data == null) {
            this.m_Ranges = null;
            return null;
        }
        int n = this.m_Data.numAttributes();
        double[][] dArray = new double[n][3];
        if (this.m_Data.numInstances() <= 0) {
            this.initializeRangesEmpty(n, dArray);
            this.m_Ranges = dArray;
            return dArray;
        }
        this.updateRangesFirst(this.m_Data.instance(0), n, dArray);
        for (int i = 1; i < this.m_Data.numInstances(); ++i) {
            this.updateRanges(this.m_Data.instance(i), n, dArray);
        }
        this.m_Ranges = dArray;
        return dArray;
    }

    public double[][] initializeRanges(int[] nArray) throws Exception {
        if (this.m_Data == null) {
            throw new Exception("No instances supplied.");
        }
        int n = this.m_Data.numAttributes();
        double[][] dArray = new double[n][3];
        if (this.m_Data.numInstances() <= 0) {
            this.initializeRangesEmpty(n, dArray);
            return dArray;
        }
        this.updateRangesFirst(this.m_Data.instance(nArray[0]), n, dArray);
        for (int i = 1; i < nArray.length; ++i) {
            this.updateRanges(this.m_Data.instance(nArray[i]), n, dArray);
        }
        return dArray;
    }

    public double[][] initializeRanges(int[] nArray, int n, int n2) throws Exception {
        if (this.m_Data == null) {
            throw new Exception("No instances supplied.");
        }
        int n3 = this.m_Data.numAttributes();
        double[][] dArray = new double[n3][3];
        if (this.m_Data.numInstances() <= 0) {
            this.initializeRangesEmpty(n3, dArray);
            return dArray;
        }
        this.updateRangesFirst(this.m_Data.instance(nArray[n]), n3, dArray);
        for (int i = n + 1; i <= n2; ++i) {
            this.updateRanges(this.m_Data.instance(nArray[i]), n3, dArray);
        }
        return dArray;
    }

    public void initializeRangesEmpty(int n, double[][] dArray) {
        for (int i = 0; i < n; ++i) {
            dArray[i][0] = Double.POSITIVE_INFINITY;
            dArray[i][1] = Double.NEGATIVE_INFINITY;
            dArray[i][2] = Double.POSITIVE_INFINITY;
        }
    }

    public void updateRangesFirst(Instance instance, int n, double[][] dArray) {
        for (int i = 0; i < n; ++i) {
            if (!instance.isMissing(i)) {
                dArray[i][0] = instance.value(i);
                dArray[i][1] = instance.value(i);
                dArray[i][2] = 0.0;
                continue;
            }
            dArray[i][0] = Double.POSITIVE_INFINITY;
            dArray[i][1] = Double.NEGATIVE_INFINITY;
            dArray[i][2] = Double.POSITIVE_INFINITY;
        }
    }

    private void updateRanges(Instance instance, int n, double[][] dArray) {
        for (int i = 0; i < n; ++i) {
            double d = instance.value(i);
            if (instance.isMissing(i)) continue;
            if (d < dArray[i][0]) {
                dArray[i][0] = d;
                dArray[i][2] = dArray[i][1] - dArray[i][0];
                if (!(d > dArray[i][1])) continue;
                dArray[i][1] = d;
                dArray[i][2] = dArray[i][1] - dArray[i][0];
                continue;
            }
            if (!(d > dArray[i][1])) continue;
            dArray[i][1] = d;
            dArray[i][2] = dArray[i][1] - dArray[i][0];
        }
    }

    public double[][] updateRanges(Instance instance, double[][] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            double d = instance.value(i);
            if (instance.isMissing(i)) continue;
            if (d < dArray[i][0]) {
                dArray[i][0] = d;
                dArray[i][2] = dArray[i][1] - dArray[i][0];
                continue;
            }
            if (!(instance.value(i) > dArray[i][1])) continue;
            dArray[i][1] = d;
            dArray[i][2] = dArray[i][1] - dArray[i][0];
        }
        return dArray;
    }

    public void updateRanges(Instance instance) {
        this.m_Ranges = this.updateRanges(instance, this.m_Ranges);
    }

    public void printRanges(double[][] dArray) {
        this.OOPS("printRanges");
        for (int i = 0; i < dArray.length; ++i) {
            this.OOPS(" " + i + "-MIN " + dArray[i][0]);
            this.OOPS(" " + i + "-MAX " + dArray[i][1]);
            this.OOPS(" " + i + "-WIDTH " + dArray[i][2]);
        }
    }

    public boolean inRanges(Instance instance, double[][] dArray) {
        boolean bl = true;
        for (int i = 0; bl && i < dArray.length; ++i) {
            if (instance.isMissing(i)) continue;
            double d = instance.value(i);
            boolean bl2 = bl = d <= dArray[i][1];
            if (!bl) continue;
            bl = d >= dArray[i][0];
        }
        return bl;
    }

    public void printRanges(Instances instances, double[][] dArray) {
        System.out.println("printRanges");
        for (int i = 0; i < instances.numAttributes(); ++i) {
            System.out.print("Attribute " + i + " MIN: " + dArray[i][0]);
            System.out.print(" MAX: " + dArray[i][1]);
            System.out.print(" WIDTH: " + dArray[i][2]);
            System.out.println(" ");
        }
    }

    public boolean rangesSet() {
        return this.m_Ranges != null;
    }

    public double[][] getRanges() throws Exception {
        if (this.m_Ranges == null) {
            throw new Exception("Ranges not yet set.");
        }
        return this.m_Ranges;
    }

    public static void main(String[] stringArray) {
        try {
            BufferedReader bufferedReader = null;
            if (stringArray.length > 1) {
                throw new Exception("Usage: EuclideanDistance <filename>");
            }
            bufferedReader = stringArray.length == 0 ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new FileReader(stringArray[0]));
            Instances instances = new Instances(bufferedReader);
            EuclideanDistance euclideanDistance = new EuclideanDistance(instances);
            System.out.println("test:\n " + euclideanDistance);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

