/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.neural;

import weka.classifiers.functions.neural.NeuralConnection;
import weka.classifiers.functions.neural.NeuralMethod;
import weka.classifiers.functions.neural.NeuralNode;

public class SigmoidUnit
implements NeuralMethod {
    private static final long serialVersionUID = -5162958458177475652L;

    public double outputValue(NeuralNode neuralNode) {
        double[] dArray = neuralNode.getWeights();
        NeuralConnection[] neuralConnectionArray = neuralNode.getInputs();
        double d = dArray[0];
        for (int i = 0; i < neuralNode.getNumInputs(); ++i) {
            d += neuralConnectionArray[i].outputValue(true) * dArray[i + 1];
        }
        d = d < -45.0 ? 0.0 : (d > 45.0 ? 1.0 : 1.0 / (1.0 + Math.exp(-d)));
        return d;
    }

    public double errorValue(NeuralNode neuralNode) {
        NeuralConnection[] neuralConnectionArray = neuralNode.getOutputs();
        int[] nArray = neuralNode.getOutputNums();
        double d = 0.0;
        for (int i = 0; i < neuralNode.getNumOutputs(); ++i) {
            d += neuralConnectionArray[i].errorValue(true) * neuralConnectionArray[i].weightValue(nArray[i]);
        }
        double d2 = neuralNode.outputValue(false);
        return d *= d2 * (1.0 - d2);
    }

    public void updateWeights(NeuralNode neuralNode, double d, double d2) {
        NeuralConnection[] neuralConnectionArray = neuralNode.getInputs();
        double[] dArray = neuralNode.getChangeInWeights();
        double[] dArray2 = neuralNode.getWeights();
        double d3 = 0.0;
        d3 = d * neuralNode.errorValue(false);
        double d4 = d3 + d2 * dArray[0];
        dArray2[0] = dArray2[0] + d4;
        dArray[0] = d4;
        int n = neuralNode.getNumInputs() + 1;
        for (int i = 1; i < n; ++i) {
            d4 = d3 * neuralConnectionArray[i - 1].outputValue(false);
            int n2 = i;
            dArray2[n2] = dArray2[n2] + (d4 += d2 * dArray[i]);
            dArray[i] = d4;
        }
    }
}

