/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.rules.ZeroR;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WekaException;

public class OneR
extends Classifier
implements OptionHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -2459427002147861445L;
    private OneRRule m_rule;
    private int m_minBucketSize = 6;
    private Classifier m_ZeroR;

    public String globalInfo() {
        return "Class for building and using a 1R classifier; in other words, uses the minimum-error attribute for prediction, discretizing numeric attributes. For more information, see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "R.C. Holte");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1993");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Very simple classification rules perform well on most commonly used datasets");
        technicalInformation.setValue(TechnicalInformation.Field.JOURNAL, "Machine Learning");
        technicalInformation.setValue(TechnicalInformation.Field.VOLUME, "11");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "63-91");
        return technicalInformation;
    }

    public double classifyInstance(Instance instance) throws Exception {
        int n;
        if (this.m_ZeroR != null) {
            return this.m_ZeroR.classifyInstance(instance);
        }
        if (instance.isMissing(this.m_rule.m_attr)) {
            if (this.m_rule.m_missingValueClass != -1) {
                return this.m_rule.m_missingValueClass;
            }
            return 0.0;
        }
        if (this.m_rule.m_attr.isNominal()) {
            n = (int)instance.value(this.m_rule.m_attr);
        } else {
            for (n = 0; n < this.m_rule.m_breakpoints.length && instance.value(this.m_rule.m_attr) >= this.m_rule.m_breakpoints[n]; ++n) {
            }
        }
        return this.m_rule.m_classifications[n];
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        boolean bl = true;
        this.getCapabilities().testWithFail(instances);
        Instances instances2 = new Instances(instances);
        instances2.deleteWithMissingClass();
        if (instances2.numAttributes() == 1) {
            System.err.println("Cannot build model (only class attribute present in data!), using ZeroR model instead!");
            this.m_ZeroR = new ZeroR();
            this.m_ZeroR.buildClassifier(instances2);
            return;
        }
        this.m_ZeroR = null;
        Enumeration enumeration = instances.enumerateAttributes();
        while (enumeration.hasMoreElements()) {
            try {
                OneRRule oneRRule = this.newRule((Attribute)enumeration.nextElement(), instances2);
                if (bl || oneRRule.m_correct > this.m_rule.m_correct) {
                    this.m_rule = oneRRule;
                }
                bl = false;
            }
            catch (Exception exception) {}
        }
        if (bl) {
            throw new WekaException("No attributes found to work with!");
        }
    }

    public OneRRule newRule(Attribute attribute, Instances instances) throws Exception {
        int[] nArray = new int[instances.classAttribute().numValues()];
        OneRRule oneRRule = attribute.isNominal() ? this.newNominalRule(attribute, instances, nArray) : this.newNumericRule(attribute, instances, nArray);
        oneRRule.m_missingValueClass = Utils.maxIndex(nArray);
        if (nArray[oneRRule.m_missingValueClass] == 0) {
            oneRRule.m_missingValueClass = -1;
        } else {
            oneRRule.m_correct += nArray[oneRRule.m_missingValueClass];
        }
        return oneRRule;
    }

    public OneRRule newNominalRule(Attribute attribute, Instances instances, int[] nArray) throws Exception {
        Serializable serializable;
        int[][] nArray2 = new int[attribute.numValues()][instances.classAttribute().numValues()];
        Enumeration enumeration = instances.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            serializable = (Instance)enumeration.nextElement();
            if (((Instance)serializable).isMissing(attribute)) {
                int n = (int)((Instance)serializable).classValue();
                nArray[n] = nArray[n] + 1;
                continue;
            }
            int[] nArray3 = nArray2[(int)((Instance)serializable).value(attribute)];
            int n = (int)((Instance)serializable).classValue();
            nArray3[n] = nArray3[n] + 1;
        }
        serializable = new OneRRule(instances, attribute);
        for (int i = 0; i < attribute.numValues(); ++i) {
            int n;
            ((OneRRule)serializable).m_classifications[i] = n = Utils.maxIndex(nArray2[i]);
            ((OneRRule)serializable).m_correct += nArray2[i][n];
        }
        return serializable;
    }

    public OneRRule newNumericRule(Attribute attribute, Instances instances, int[] nArray) throws Exception {
        int[] nArray2 = new int[instances.numInstances()];
        double[] dArray = new double[instances.numInstances()];
        int[] nArray3 = new int[instances.classAttribute().numValues()];
        int n = 0;
        int n2 = instances.numInstances();
        instances.sort(attribute);
        while (n2 > 0 && instances.instance(n2 - 1).isMissing(attribute)) {
            int n3 = (int)instances.instance(--n2).classValue();
            nArray[n3] = nArray[n3] + 1;
        }
        int n4 = 0;
        int n5 = 0;
        while (n4 < n2) {
            int n6;
            int n7;
            for (n7 = 0; n7 < nArray3.length; ++n7) {
                nArray3[n7] = 0;
            }
            do {
                int n8 = n6 = (int)instances.instance(n4++).classValue();
                nArray3[n8] = nArray3[n8] + 1;
            } while (nArray3[n6] < this.m_minBucketSize && n4 < n2);
            while (n4 < n2 && (int)instances.instance(n4).classValue() == n6) {
                int n9 = n6;
                nArray3[n9] = nArray3[n9] + 1;
                ++n4;
            }
            while (n4 < n2 && instances.instance(n4 - 1).value(attribute) == instances.instance(n4).value(attribute)) {
                int n10 = (int)instances.instance(n4++).classValue();
                nArray3[n10] = nArray3[n10] + 1;
            }
            for (n7 = 0; n7 < nArray3.length; ++n7) {
                if (nArray3[n7] <= nArray3[n6]) continue;
                n6 = n7;
            }
            if (n5 > 0) {
                if (nArray3[nArray2[n5 - 1]] == nArray3[n6]) {
                    n6 = nArray2[n5 - 1];
                }
                if (n6 == nArray2[n5 - 1]) {
                    --n5;
                }
            }
            n += nArray3[n6];
            nArray2[n5] = n6;
            if (n4 < n2) {
                dArray[n5] = (instances.instance(n4 - 1).value(attribute) + instances.instance(n4).value(attribute)) / 2.0;
            }
            ++n5;
        }
        if (n5 == 0) {
            throw new Exception("Only missing values in the training data!");
        }
        OneRRule oneRRule = new OneRRule(instances, attribute, n5);
        oneRRule.m_correct = n;
        for (int i = 0; i < n5; ++i) {
            ((OneRRule)oneRRule).m_classifications[i] = nArray2[i];
            if (i >= n5 - 1) continue;
            ((OneRRule)oneRRule).m_breakpoints[i] = dArray[i];
        }
        return oneRRule;
    }

    public Enumeration listOptions() {
        String string = "\tThe minimum number of objects in a bucket (default: 6).";
        Vector<Option> vector = new Vector<Option>(1);
        vector.addElement(new Option(string, "B", 1, "-B <minimum bucket size>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('B', stringArray);
        this.m_minBucketSize = string.length() != 0 ? Integer.parseInt(string) : 6;
    }

    public String[] getOptions() {
        String[] stringArray = new String[2];
        int n = 0;
        stringArray[n++] = "-B";
        stringArray[n++] = "" + this.m_minBucketSize;
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String toString() {
        if (this.m_ZeroR != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getClass().getName().replaceAll(".*\\.", "") + "\n");
            stringBuffer.append(this.getClass().getName().replaceAll(".*\\.", "").replaceAll(".", "=") + "\n\n");
            stringBuffer.append("Warning: No model could be built, hence ZeroR model is used:\n\n");
            stringBuffer.append(this.m_ZeroR.toString());
            return stringBuffer.toString();
        }
        if (this.m_rule == null) {
            return "OneR: No model built yet.";
        }
        return this.m_rule.toString();
    }

    public String minBucketSizeTipText() {
        return "The minimum bucket size used for discretizing numeric attributes.";
    }

    public int getMinBucketSize() {
        return this.m_minBucketSize;
    }

    public void setMinBucketSize(int n) {
        this.m_minBucketSize = n;
    }

    public static void main(String[] stringArray) {
        OneR.runClassifier(new OneR(), stringArray);
    }

    private class OneRRule
    implements Serializable {
        static final long serialVersionUID = 1152814630957092281L;
        private Attribute m_class;
        private int m_numInst;
        private Attribute m_attr;
        private int m_correct;
        private int[] m_classifications;
        private int m_missingValueClass = -1;
        private double[] m_breakpoints;

        public OneRRule(Instances instances, Attribute attribute) throws Exception {
            this.m_class = instances.classAttribute();
            this.m_numInst = instances.numInstances();
            this.m_attr = attribute;
            this.m_correct = 0;
            this.m_classifications = new int[this.m_attr.numValues()];
        }

        public OneRRule(Instances instances, Attribute attribute, int n) throws Exception {
            this.m_class = instances.classAttribute();
            this.m_numInst = instances.numInstances();
            this.m_attr = attribute;
            this.m_correct = 0;
            this.m_classifications = new int[n];
            this.m_breakpoints = new double[n - 1];
        }

        public String toString() {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.m_attr.name() + ":\n");
                for (int i = 0; i < this.m_classifications.length; ++i) {
                    stringBuffer.append("\t");
                    if (this.m_attr.isNominal()) {
                        stringBuffer.append(this.m_attr.value(i));
                    } else if (i < this.m_breakpoints.length) {
                        stringBuffer.append("< " + this.m_breakpoints[i]);
                    } else if (i > 0) {
                        stringBuffer.append(">= " + this.m_breakpoints[i - 1]);
                    } else {
                        stringBuffer.append("not ?");
                    }
                    stringBuffer.append("\t-> " + this.m_class.value(this.m_classifications[i]) + "\n");
                }
                if (this.m_missingValueClass != -1) {
                    stringBuffer.append("\t?\t-> " + this.m_class.value(this.m_missingValueClass) + "\n");
                }
                stringBuffer.append("(" + this.m_correct + "/" + this.m_numInst + " instances correct)\n");
                return stringBuffer.toString();
            }
            catch (Exception exception) {
                return "Can't print OneR classifier!";
            }
        }
    }
}

