/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.attributeSelection.AttributeEvaluator;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.Capabilities;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class OneRAttributeEval
extends AttributeEvaluator
implements OptionHandler {
    static final long serialVersionUID = 4386514823886856980L;
    private Instances m_trainInstances;
    private int m_classIndex;
    private int m_numAttribs;
    private int m_numInstances;
    private int m_randomSeed;
    private int m_folds;
    private boolean m_evalUsingTrainingData;
    private int m_minBucketSize;

    public String globalInfo() {
        return "OneRAttributeEval :\n\nEvaluates the worth of an attribute by using the OneR classifier.\n";
    }

    public String seedTipText() {
        return "Set the seed for use in cross validation.";
    }

    public void setSeed(int n) {
        this.m_randomSeed = n;
    }

    public int getSeed() {
        return this.m_randomSeed;
    }

    public String foldsTipText() {
        return "Set the number of folds for cross validation.";
    }

    public void setFolds(int n) {
        this.m_folds = n;
        if (this.m_folds < 2) {
            this.m_folds = 2;
        }
    }

    public int getFolds() {
        return this.m_folds;
    }

    public String evalUsingTrainingDataTipText() {
        return "Use the training data to evaluate attributes rather than cross validation.";
    }

    public void setEvalUsingTrainingData(boolean bl) {
        this.m_evalUsingTrainingData = bl;
    }

    public String minimumBucketSizeTipText() {
        return "The minimum number of objects in a bucket (passed to OneR).";
    }

    public void setMinimumBucketSize(int n) {
        this.m_minBucketSize = n;
    }

    public int getMinimumBucketSize() {
        return this.m_minBucketSize;
    }

    public boolean getEvalUsingTrainingData() {
        return this.m_evalUsingTrainingData;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(4);
        vector.addElement(new Option("\tRandom number seed for cross validation\n\t(default = 1)", "S", 1, "-S <seed>"));
        vector.addElement(new Option("\tNumber of folds for cross validation\n\t(default = 10)", "F", 1, "-F <folds>"));
        vector.addElement(new Option("\tUse training data for evaluation rather than cross validaton", "D", 0, "-D"));
        vector.addElement(new Option("\tMinimum number of objects in a bucket\n\t(passed on to OneR, default = 6)", "B", 1, "-B <minimum bucket size>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('S', stringArray);
        if (string.length() != 0) {
            this.setSeed(Integer.parseInt(string));
        }
        if ((string = Utils.getOption('F', stringArray)).length() != 0) {
            this.setFolds(Integer.parseInt(string));
        }
        if ((string = Utils.getOption('B', stringArray)).length() != 0) {
            this.setMinimumBucketSize(Integer.parseInt(string));
        }
        this.setEvalUsingTrainingData(Utils.getFlag('D', stringArray));
        Utils.checkForRemainingOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = new String[7];
        int n = 0;
        if (this.getEvalUsingTrainingData()) {
            stringArray[n++] = "-D";
        }
        stringArray[n++] = "-S";
        stringArray[n++] = "" + this.getSeed();
        stringArray[n++] = "-F";
        stringArray[n++] = "" + this.getFolds();
        stringArray[n++] = "-B";
        stringArray[n++] = "" + this.getMinimumBucketSize();
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public OneRAttributeEval() {
        this.resetOptions();
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return capabilities;
    }

    public void buildEvaluator(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        this.m_trainInstances = instances;
        this.m_classIndex = this.m_trainInstances.classIndex();
        this.m_numAttribs = this.m_trainInstances.numAttributes();
        this.m_numInstances = this.m_trainInstances.numInstances();
    }

    protected void resetOptions() {
        this.m_trainInstances = null;
        this.m_randomSeed = 1;
        this.m_folds = 10;
        this.m_evalUsingTrainingData = false;
        this.m_minBucketSize = 6;
    }

    public double evaluateAttribute(int n) throws Exception {
        int[] nArray = new int[2];
        Remove remove = new Remove();
        remove.setInvertSelection(true);
        Instances instances = new Instances(this.m_trainInstances);
        nArray[0] = n;
        nArray[1] = instances.classIndex();
        remove.setAttributeIndicesArray(nArray);
        remove.setInputFormat(instances);
        instances = Filter.useFilter(instances, remove);
        Evaluation evaluation = new Evaluation(instances);
        String[] stringArray = new String[]{"-B", "" + this.getMinimumBucketSize()};
        Classifier classifier = Classifier.forName("weka.classifiers.rules.OneR", stringArray);
        if (this.m_evalUsingTrainingData) {
            classifier.buildClassifier(instances);
            evaluation.evaluateModel(classifier, instances);
        } else {
            evaluation.crossValidateModel(classifier, instances, this.m_folds, new Random(this.m_randomSeed));
        }
        double d = evaluation.errorRate();
        return (1.0 - d) * 100.0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_trainInstances == null) {
            stringBuffer.append("\tOneR feature evaluator has not been built yet");
        } else {
            stringBuffer.append("\tOneR feature evaluator.\n\n");
            stringBuffer.append("\tUsing ");
            if (this.m_evalUsingTrainingData) {
                stringBuffer.append("training data for evaluation of attributes.");
            } else {
                stringBuffer.append("" + this.getFolds() + " fold cross validation for evaluating " + "attributes.");
            }
            stringBuffer.append("\n\tMinimum bucket size for OneR: " + this.getMinimumBucketSize());
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        OneRAttributeEval.runEvaluator(new OneRAttributeEval(), stringArray);
    }
}

