/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.arffviewer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Undoable;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.ConverterUtils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Reorder;
import weka.gui.ComponentHelper;

public class ArffTableModel
implements TableModel,
Undoable {
    private HashSet m_Listeners = new HashSet();
    private Instances m_Data = null;
    private boolean m_NotificationEnabled = true;
    private boolean m_UndoEnabled = true;
    private boolean m_IgnoreChanges = false;
    private Vector m_UndoList = new Vector();
    private boolean m_ReadOnly = false;

    private ArffTableModel() {
    }

    public ArffTableModel(String string) {
        this();
        if (string != null && !string.equals("")) {
            this.loadFile(string);
        }
    }

    public ArffTableModel(Instances instances) {
        this();
        this.m_Data = instances;
    }

    public boolean isNotificationEnabled() {
        return this.m_NotificationEnabled;
    }

    public void setNotificationEnabled(boolean bl) {
        this.m_NotificationEnabled = bl;
    }

    public boolean isUndoEnabled() {
        return this.m_UndoEnabled;
    }

    public void setUndoEnabled(boolean bl) {
        this.m_UndoEnabled = bl;
    }

    public boolean isReadOnly() {
        return this.m_ReadOnly;
    }

    public void setReadOnly(boolean bl) {
        this.m_ReadOnly = bl;
    }

    private void loadFile(String string) {
        AbstractFileLoader abstractFileLoader = ConverterUtils.getLoaderForFile(string);
        if (abstractFileLoader != null) {
            try {
                abstractFileLoader.setFile(new File(string));
                this.m_Data = abstractFileLoader.getDataSet();
            }
            catch (Exception exception) {
                ComponentHelper.showMessageBox(null, "Error loading file...", exception.toString(), 2, 0);
                System.out.println(exception);
                this.m_Data = null;
            }
        }
    }

    public void setInstances(Instances instances) {
        this.m_Data = instances;
    }

    public Instances getInstances() {
        return this.m_Data;
    }

    public Attribute getAttributeAt(int n) {
        if (n > 0 && n < this.getColumnCount()) {
            return this.m_Data.attribute(n - 1);
        }
        return null;
    }

    public int getType(int n) {
        return this.getType(0, n);
    }

    public int getType(int n, int n2) {
        int n3 = 2;
        if (n >= 0 && n < this.getRowCount() && n2 > 0 && n2 < this.getColumnCount()) {
            n3 = this.m_Data.instance(n).attribute(n2 - 1).type();
        }
        return n3;
    }

    public void deleteAttributeAt(int n) {
        this.deleteAttributeAt(n, true);
    }

    public void deleteAttributeAt(int n, boolean bl) {
        if (n > 0 && n < this.getColumnCount()) {
            if (!this.m_IgnoreChanges) {
                this.addUndoPoint();
            }
            this.m_Data.deleteAttributeAt(n - 1);
            if (bl) {
                this.notifyListener(new TableModelEvent(this, -1));
            }
        }
    }

    public void deleteAttributes(int[] nArray) {
        Arrays.sort(nArray);
        this.addUndoPoint();
        this.m_IgnoreChanges = true;
        for (int i = nArray.length - 1; i >= 0; --i) {
            this.deleteAttributeAt(nArray[i], false);
        }
        this.m_IgnoreChanges = false;
        this.notifyListener(new TableModelEvent(this, -1));
    }

    public void renameAttributeAt(int n, String string) {
        if (n > 0 && n < this.getColumnCount()) {
            this.addUndoPoint();
            this.m_Data.renameAttribute(n - 1, string);
            this.notifyListener(new TableModelEvent(this, -1));
        }
    }

    public void attributeAsClassAt(int n) {
        if (n > 0 && n < this.getColumnCount()) {
            this.addUndoPoint();
            try {
                String string = "";
                for (int i = 1; i < this.m_Data.numAttributes() + 1; ++i) {
                    if (i == n) continue;
                    if (!string.equals("")) {
                        string = string + ",";
                    }
                    string = string + Integer.toString(i);
                }
                if (!string.equals("")) {
                    string = string + ",";
                }
                string = string + Integer.toString(n);
                Reorder reorder = new Reorder();
                reorder.setAttributeIndices(string);
                reorder.setInputFormat(this.m_Data);
                this.m_Data = Filter.useFilter(this.m_Data, reorder);
                this.m_Data.setClassIndex(this.m_Data.numAttributes() - 1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.undo();
            }
            this.notifyListener(new TableModelEvent(this, -1));
        }
    }

    public void deleteInstanceAt(int n) {
        this.deleteInstanceAt(n, true);
    }

    public void deleteInstanceAt(int n, boolean bl) {
        if (n >= 0 && n < this.getRowCount()) {
            if (!this.m_IgnoreChanges) {
                this.addUndoPoint();
            }
            this.m_Data.delete(n);
            if (bl) {
                this.notifyListener(new TableModelEvent(this, n, n, -1, -1));
            }
        }
    }

    public void deleteInstances(int[] nArray) {
        Arrays.sort(nArray);
        this.addUndoPoint();
        this.m_IgnoreChanges = true;
        for (int i = nArray.length - 1; i >= 0; --i) {
            this.deleteInstanceAt(nArray[i], false);
        }
        this.m_IgnoreChanges = false;
        this.notifyListener(new TableModelEvent(this, nArray[0], nArray[nArray.length - 1], -1, -1));
    }

    public void sortInstances(int n) {
        if (n > 0 && n < this.getColumnCount()) {
            this.addUndoPoint();
            this.m_Data.sort(n - 1);
            this.notifyListener(new TableModelEvent(this));
        }
    }

    public int getAttributeColumn(String string) {
        int n = -1;
        for (int i = 0; i < this.m_Data.numAttributes(); ++i) {
            if (!this.m_Data.attribute(i).name().equals(string)) continue;
            n = i + 1;
            break;
        }
        return n;
    }

    public Class getColumnClass(int n) {
        Class clazz = null;
        if (n >= 0 && n < this.getColumnCount()) {
            clazz = n == 0 ? Integer.class : (this.getType(n) == 0 ? Double.class : String.class);
        }
        return clazz;
    }

    public int getColumnCount() {
        int n = 1;
        if (this.m_Data != null) {
            n += this.m_Data.numAttributes();
        }
        return n;
    }

    private boolean isClassIndex(int n) {
        int n2 = this.m_Data.classIndex();
        boolean bl = n2 == -1 && this.m_Data.numAttributes() == n || n2 == n - 1;
        return bl;
    }

    public String getColumnName(int n) {
        String string = "";
        if (n >= 0 && n < this.getColumnCount()) {
            if (n == 0) {
                string = "<html><center>No.<br><font size=\"-2\">&nbsp;</font></center></html>";
            } else if (this.m_Data != null && n - 1 < this.m_Data.numAttributes()) {
                string = "<html><center>";
                string = this.isClassIndex(n) ? string + "<b>" + this.m_Data.attribute(n - 1).name() + "</b>" : string + this.m_Data.attribute(n - 1).name();
                switch (this.getType(n)) {
                    case 3: {
                        string = string + "<br><font size=\"-2\">Date</font>";
                        break;
                    }
                    case 1: {
                        string = string + "<br><font size=\"-2\">Nominal</font>";
                        break;
                    }
                    case 2: {
                        string = string + "<br><font size=\"-2\">String</font>";
                        break;
                    }
                    case 0: {
                        string = string + "<br><font size=\"-2\">Numeric</font>";
                        break;
                    }
                    case 4: {
                        string = string + "<br><font size=\"-2\">Relational</font>";
                        break;
                    }
                    default: {
                        string = string + "<br><font size=\"-2\">???</font>";
                    }
                }
                string = string + "</center></html>";
            }
        }
        return string;
    }

    public int getRowCount() {
        if (this.m_Data == null) {
            return 0;
        }
        return this.m_Data.numInstances();
    }

    public boolean isMissingAt(int n, int n2) {
        boolean bl = false;
        if (n >= 0 && n < this.getRowCount() && n2 > 0 && n2 < this.getColumnCount()) {
            bl = this.m_Data.instance(n).isMissing(n2 - 1);
        }
        return bl;
    }

    public double getInstancesValueAt(int n, int n2) {
        double d = -1.0;
        if (n >= 0 && n < this.getRowCount() && n2 > 0 && n2 < this.getColumnCount()) {
            d = this.m_Data.instance(n).value(n2 - 1);
        }
        return d;
    }

    public Object getValueAt(int n, int n2) {
        String string;
        Object object = null;
        if (n >= 0 && n < this.getRowCount() && n2 >= 0 && n2 < this.getColumnCount()) {
            if (n2 == 0) {
                object = new Integer(n + 1);
            } else if (this.isMissingAt(n, n2)) {
                object = null;
            } else {
                switch (this.getType(n2)) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        object = this.m_Data.instance(n).stringValue(n2 - 1);
                        break;
                    }
                    case 0: {
                        object = new Double(this.m_Data.instance(n).value(n2 - 1));
                        break;
                    }
                    default: {
                        object = "-can't display-";
                    }
                }
            }
        }
        if (this.getType(n2) != 0 && object != null && ((string = object.toString()).indexOf("\n") > -1 || string.indexOf("\r") > -1)) {
            string = string.replaceAll("\\r\\n", "<font color=\"red\"><b>\\\\r\\\\n</b></font>");
            string = string.replaceAll("\\r", "<font color=\"red\"><b>\\\\r</b></font>");
            string = string.replaceAll("\\n", "<font color=\"red\"><b>\\\\n</b></font>");
            object = "<html>" + string + "</html>";
        }
        return object;
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 > 0 && !this.isReadOnly();
    }

    public void setValueAt(Object object, int n, int n2) {
        this.setValueAt(object, n, n2, true);
    }

    public void setValueAt(Object object, int n, int n2, boolean bl) {
        if (!this.m_IgnoreChanges) {
            this.addUndoPoint();
        }
        Object object2 = this.getValueAt(n, n2);
        int n3 = this.getType(n, n2);
        int n4 = n2 - 1;
        Instance instance = this.m_Data.instance(n);
        Attribute attribute = instance.attribute(n4);
        if (object == null) {
            instance.setValue(n4, Instance.missingValue());
        } else {
            String string = object.toString();
            switch (n3) {
                case 3: {
                    try {
                        attribute.parseDate(string);
                        instance.setValue(n4, attribute.parseDate(string));
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 1: {
                    if (attribute.indexOfValue(string) <= -1) break;
                    instance.setValue(n4, (double)attribute.indexOfValue(string));
                    break;
                }
                case 2: {
                    instance.setValue(n4, string);
                    break;
                }
                case 0: {
                    try {
                        Double.parseDouble(string);
                        instance.setValue(n4, Double.parseDouble(string));
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 4: {
                    try {
                        instance.setValue(n4, (double)instance.attribute(n4).addRelation((Instances)object));
                    }
                    catch (Exception exception) {}
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported Attribute type: " + n3 + "!");
                }
            }
        }
        if (bl && !("" + object2).equals("" + object)) {
            this.notifyListener(new TableModelEvent(this, n, n2));
        }
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
        this.m_Listeners.add(tableModelListener);
    }

    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.m_Listeners.remove(tableModelListener);
    }

    public void notifyListener(TableModelEvent tableModelEvent) {
        if (!this.isNotificationEnabled()) {
            return;
        }
        for (TableModelListener tableModelListener : this.m_Listeners) {
            tableModelListener.tableChanged(tableModelEvent);
        }
    }

    public void clearUndo() {
        this.m_UndoList = new Vector();
    }

    public boolean canUndo() {
        return !this.m_UndoList.isEmpty();
    }

    public void undo() {
        if (this.canUndo()) {
            File file = (File)this.m_UndoList.get(this.m_UndoList.size() - 1);
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
                Instances instances = (Instances)objectInputStream.readObject();
                objectInputStream.close();
                this.setInstances(instances);
                this.notifyListener(new TableModelEvent(this, -1));
                this.notifyListener(new TableModelEvent(this));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            file.delete();
            this.m_UndoList.remove(this.m_UndoList.size() - 1);
        }
    }

    public void addUndoPoint() {
        if (!this.isUndoEnabled()) {
            return;
        }
        if (this.getInstances() != null) {
            try {
                File file = File.createTempFile("arffviewer", null);
                file.deleteOnExit();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                objectOutputStream.writeObject(this.getInstances());
                objectOutputStream.flush();
                objectOutputStream.close();
                this.m_UndoList.add(file);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

