/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers.forOPTICSAndDBScan.OPTICS_GUI;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import weka.clusterers.forOPTICSAndDBScan.DataObjects.DataObject;
import weka.clusterers.forOPTICSAndDBScan.OPTICS_GUI.SERObject;
import weka.core.FastVector;
import weka.core.Utils;

public class GraphPanel
extends JComponent {
    private static final long serialVersionUID = 7917937528738361470L;
    private FastVector resultVector;
    private int verticalAdjustment;
    private Color coreDistanceColor;
    private Color reachabilityDistanceColor;
    private int widthSlider;
    private boolean showCoreDistances;
    private boolean showReachabilityDistances;
    private int recentIndex = -1;

    public GraphPanel(FastVector fastVector, int n, boolean bl, boolean bl2) {
        this.resultVector = fastVector;
        this.verticalAdjustment = n;
        this.coreDistanceColor = new Color(100, 100, 100);
        this.reachabilityDistanceColor = Color.orange;
        this.widthSlider = 5;
        this.showCoreDistances = bl;
        this.showReachabilityDistances = bl2;
        this.addMouseMotionListener(new MouseHandler());
    }

    protected void paintComponent(Graphics graphics) {
        if (this.isOpaque()) {
            Dimension dimension = this.getSize();
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.resultVector.size(); ++i) {
            double d = ((DataObject)this.resultVector.elementAt(i)).getCoreDistance();
            double d2 = ((DataObject)this.resultVector.elementAt(i)).getReachabilityDistance();
            n2 = d == 2.147483647E9 ? this.getHeight() : (int)(d * (double)this.verticalAdjustment);
            n3 = d2 == 2.147483647E9 ? this.getHeight() : (int)(d2 * (double)this.verticalAdjustment);
            int n4 = i + n;
            if (this.isShowCoreDistances()) {
                graphics.setColor(this.coreDistanceColor);
                graphics.fillRect(n4, this.getHeight() - n2, this.widthSlider, n2);
            }
            if (this.isShowReachabilityDistances()) {
                int n5 = this.widthSlider;
                if (!this.isShowCoreDistances()) {
                    n5 = 0;
                }
                graphics.setColor(this.reachabilityDistanceColor);
                graphics.fillRect(n4 + n5, this.getHeight() - n3, this.widthSlider, n3);
            }
            if (this.isShowCoreDistances() && this.isShowReachabilityDistances()) {
                n += this.widthSlider * 2;
                continue;
            }
            n += this.widthSlider;
        }
    }

    public void setResultVector(FastVector fastVector) {
        this.resultVector = fastVector;
    }

    public void setNewToolTip(String string) {
        this.setToolTipText(string);
    }

    public void adjustSize(SERObject sERObject) {
        int n = 0;
        if (this.isShowCoreDistances() && this.isShowReachabilityDistances()) {
            n = 10;
        } else if (this.isShowCoreDistances() && !this.isShowReachabilityDistances() || !this.isShowCoreDistances() && this.isShowReachabilityDistances()) {
            n = 5;
        }
        this.setSize(new Dimension(n * sERObject.getDatabaseSize() + sERObject.getDatabaseSize(), this.getHeight()));
        this.setPreferredSize(new Dimension(n * sERObject.getDatabaseSize() + sERObject.getDatabaseSize(), this.getHeight()));
    }

    public boolean isShowCoreDistances() {
        return this.showCoreDistances;
    }

    public void setShowCoreDistances(boolean bl) {
        this.showCoreDistances = bl;
    }

    public boolean isShowReachabilityDistances() {
        return this.showReachabilityDistances;
    }

    public void setShowReachabilityDistances(boolean bl) {
        this.showReachabilityDistances = bl;
    }

    public void setVerticalAdjustment(int n) {
        this.verticalAdjustment = n;
    }

    public void setCoreDistanceColor(Color color) {
        this.coreDistanceColor = color;
        this.repaint();
    }

    public void setReachabilityDistanceColor(Color color) {
        this.reachabilityDistanceColor = color;
        this.repaint();
    }

    private class MouseHandler
    extends MouseMotionAdapter {
        private MouseHandler() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.showToolTip(mouseEvent.getX());
        }

        private boolean showToolTip(int n) {
            int n2 = 0;
            if (GraphPanel.this.isShowCoreDistances() && GraphPanel.this.isShowReachabilityDistances()) {
                n2 = 11;
            } else if (GraphPanel.this.isShowCoreDistances() && !GraphPanel.this.isShowReachabilityDistances() || !GraphPanel.this.isShowCoreDistances() && GraphPanel.this.isShowReachabilityDistances() || !GraphPanel.this.isShowCoreDistances() && !GraphPanel.this.isShowReachabilityDistances()) {
                n2 = 6;
            }
            if (n / n2 == GraphPanel.this.recentIndex) {
                return false;
            }
            GraphPanel.this.recentIndex = n / n2;
            DataObject dataObject = null;
            try {
                dataObject = (DataObject)GraphPanel.this.resultVector.elementAt(GraphPanel.this.recentIndex);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (dataObject != null) {
                if (!GraphPanel.this.isShowCoreDistances() && !GraphPanel.this.isShowReachabilityDistances()) {
                    GraphPanel.this.setNewToolTip("<html><body><b>Please select a distance</b></body></html>");
                } else {
                    GraphPanel.this.setNewToolTip("<html><body><table><tr><td>DataObject:</td><td>" + dataObject + "</td></tr>" + "<tr><td>Key:</td><td>" + dataObject.getKey() + "</td></tr>" + "<tr><td>" + (GraphPanel.this.isShowCoreDistances() ? "<b>" : "") + "Core-Distance:" + (GraphPanel.this.isShowCoreDistances() ? "</b>" : "") + "</td><td>" + (GraphPanel.this.isShowCoreDistances() ? "<b>" : "") + (dataObject.getCoreDistance() == 2.147483647E9 ? "UNDEFINED" : Utils.doubleToString(dataObject.getCoreDistance(), 3, 5)) + (GraphPanel.this.isShowCoreDistances() ? "</b>" : "") + "</td></tr>" + "<tr><td>" + (GraphPanel.this.isShowReachabilityDistances() ? "<b>" : "") + "Reachability-Distance:" + (GraphPanel.this.isShowReachabilityDistances() ? "</b>" : "") + "</td><td>" + (GraphPanel.this.isShowReachabilityDistances() ? "<b>" : "") + (dataObject.getReachabilityDistance() == 2.147483647E9 ? "UNDEFINED" : Utils.doubleToString(dataObject.getReachabilityDistance(), 3, 5)) + (GraphPanel.this.isShowReachabilityDistances() ? "</b>" : "") + "</td></tr>" + "</table></body></html>");
                }
            }
            return true;
        }
    }
}

