/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.Component;
import java.lang.reflect.Method;
import javax.swing.JOptionPane;

public class BrowserHelper {
    public static final String[] LINUX_BROWSERS = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};

    public static void openURL(String string) {
        BrowserHelper.openURL(null, string);
    }

    public static void openURL(Component component, String string) {
        BrowserHelper.openURL(component, string, true);
    }

    public static void openURL(Component component, String string, boolean bl) {
        String string2 = System.getProperty("os.name");
        try {
            if (string2.startsWith("Mac OS")) {
                Class<?> clazz = Class.forName("com.apple.eio.FileManager");
                Method method = clazz.getDeclaredMethod("openURL", String.class);
                method.invoke(null, string);
            } else if (string2.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + string);
            } else {
                String string3 = null;
                for (int i = 0; i < LINUX_BROWSERS.length && string3 == null; ++i) {
                    if (Runtime.getRuntime().exec(new String[]{"which", LINUX_BROWSERS[i]}).waitFor() != 0) continue;
                    string3 = LINUX_BROWSERS[i];
                    break;
                }
                if (string3 == null) {
                    throw new Exception("Could not find web browser");
                }
                Runtime.getRuntime().exec(new String[]{string3, string});
            }
        }
        catch (Exception exception) {
            String string4 = "Error attempting to launch web browser:\n" + exception.getMessage();
            if (bl) {
                JOptionPane.showMessageDialog(component, string4);
            }
            System.err.println(string4);
        }
    }
}

