/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.SparseInstance;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class SparseToNonSparse
extends Filter
implements UnsupervisedFilter,
StreamableFilter {
    static final long serialVersionUID = 2481634184210236074L;

    public String globalInfo() {
        return "An instance filter that converts all incoming sparse instances into non-sparse format.";
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enableAllAttributes();
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enableAllClasses();
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        this.setOutputFormat(instances);
        return true;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        Instance instance2 = null;
        if (instance instanceof SparseInstance) {
            instance2 = new Instance(instance.weight(), instance.toDoubleArray());
            instance2.setDataset(instance.dataset());
        } else {
            instance2 = instance;
        }
        this.push(instance2);
        return true;
    }

    public static void main(String[] stringArray) {
        SparseToNonSparse.runFilter(new SparseToNonSparse(), stringArray);
    }
}

