/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch.balltrees;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.DistanceFunction;
import weka.core.EuclideanDistance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.neighboursearch.balltrees.BallNode;

public abstract class BallTreeConstructor
implements OptionHandler,
Serializable,
RevisionHandler {
    protected int m_MaxInstancesInLeaf = 40;
    protected double m_MaxRelLeafRadius = 0.001;
    protected boolean m_FullyContainChildBalls = false;
    protected Instances m_Instances;
    protected DistanceFunction m_DistanceFunction;
    protected int m_NumNodes;
    protected int m_NumLeaves;
    protected int m_MaxDepth;
    protected int[] m_InstList;

    public abstract BallNode buildTree() throws Exception;

    public abstract int[] addInstance(BallNode var1, Instance var2) throws Exception;

    public String maxInstancesInLeafTipText() {
        return "The maximum number of instances allowed in a leaf.";
    }

    public int getMaxInstancesInLeaf() {
        return this.m_MaxInstancesInLeaf;
    }

    public void setMaxInstancesInLeaf(int n) throws Exception {
        if (n < 1) {
            throw new Exception("The maximum number of instances in a leaf must be >=1.");
        }
        this.m_MaxInstancesInLeaf = n;
    }

    public String maxRelativeLeafRadiusTipText() {
        return "The maximum relative radius allowed for a leaf node. Itis relative to the radius of the smallest ball enclosing all the data points (that were used to build the tree). This smallest ball would be the same as the root node's ball, if ContainChildBalls property is set to false (default).";
    }

    public double getMaxRelativeLeafRadius() {
        return this.m_MaxRelLeafRadius;
    }

    public void setMaxRelativeLeafRadius(double d) throws Exception {
        if (d < 0.0) {
            throw new Exception("The radius for the leaves should be >= 0.0");
        }
        this.m_MaxRelLeafRadius = d;
    }

    public String containChildBallsTipText() {
        return "Whether to contain fully the child balls.";
    }

    public boolean getContainChildBalls() {
        return this.m_FullyContainChildBalls;
    }

    public void setContainChildBalls(boolean bl) {
        this.m_FullyContainChildBalls = bl;
    }

    public void setInstances(Instances instances) {
        this.m_Instances = instances;
    }

    public void setInstanceList(int[] nArray) {
        this.m_InstList = nArray;
    }

    public void setEuclideanDistanceFunction(EuclideanDistance euclideanDistance) {
        this.m_DistanceFunction = euclideanDistance;
    }

    public int getNumNodes() {
        return this.m_NumNodes;
    }

    public int getNumLeaves() {
        return this.m_NumLeaves;
    }

    public int getMaxDepth() {
        return this.m_MaxDepth;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tSet maximum number of instances in a leaf node\n\t(default: 40)", "N", 0, "-N <value>"));
        vector.addElement(new Option("\tSet internal nodes' radius to the sum \n\tof the child balls radii. So that it \ncontains the child balls.", "R", 0, "-R"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('N', stringArray);
        if (string.length() != 0) {
            this.setMaxInstancesInLeaf(Integer.parseInt(string));
        } else {
            this.setMaxInstancesInLeaf(40);
        }
        this.setContainChildBalls(Utils.getFlag('R', stringArray));
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        vector.add("-N");
        vector.add("" + this.getMaxInstancesInLeaf());
        if (this.getContainChildBalls()) {
            vector.add("-R");
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.3 $");
    }
}

