/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.matrix.EigenvalueDecomposition;
import weka.core.matrix.LUDecomposition;
import weka.core.matrix.Maths;

public class Matrix
implements Cloneable,
Serializable,
RevisionHandler {
    private static final long serialVersionUID = -3604757095849145838L;
    protected weka.core.matrix.Matrix m_Matrix = null;

    public Matrix(int n, int n2) {
        this.m_Matrix = new weka.core.matrix.Matrix(n, n2);
    }

    public Matrix(double[][] dArray) throws Exception {
        this.m_Matrix = new weka.core.matrix.Matrix(dArray);
    }

    public Matrix(Reader reader) throws Exception {
        this.m_Matrix = new weka.core.matrix.Matrix(reader);
    }

    public Object clone() {
        try {
            return new Matrix(this.m_Matrix.getArrayCopy());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void write(Writer writer) throws Exception {
        this.m_Matrix.write(writer);
    }

    protected weka.core.matrix.Matrix getMatrix() {
        return this.m_Matrix;
    }

    public final double getElement(int n, int n2) {
        return this.m_Matrix.get(n, n2);
    }

    public final void addElement(int n, int n2, double d) {
        this.m_Matrix.set(n, n2, this.m_Matrix.get(n, n2) + d);
    }

    public final int numRows() {
        return this.m_Matrix.getRowDimension();
    }

    public final int numColumns() {
        return this.m_Matrix.getColumnDimension();
    }

    public final void setElement(int n, int n2, double d) {
        this.m_Matrix.set(n, n2, d);
    }

    public final void setRow(int n, double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            this.m_Matrix.set(n, i, dArray[i]);
        }
    }

    public double[] getRow(int n) {
        double[] dArray = new double[this.numColumns()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.getElement(n, i);
        }
        return dArray;
    }

    public double[] getColumn(int n) {
        double[] dArray = new double[this.numRows()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.getElement(i, n);
        }
        return dArray;
    }

    public final void setColumn(int n, double[] dArray) {
        for (int i = 0; i < this.numRows(); ++i) {
            this.m_Matrix.set(i, n, dArray[i]);
        }
    }

    public String toString() {
        return this.m_Matrix.toString();
    }

    public final Matrix add(Matrix matrix) {
        try {
            return new Matrix(this.m_Matrix.plus(matrix.getMatrix()).getArrayCopy());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public final Matrix transpose() {
        try {
            return new Matrix(this.m_Matrix.transpose().getArrayCopy());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public boolean isSymmetric() {
        return this.m_Matrix.isSymmetric();
    }

    public final Matrix multiply(Matrix matrix) {
        try {
            return new Matrix(this.getMatrix().times(matrix.getMatrix()).getArrayCopy());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public final double[] regression(Matrix matrix, double d) {
        return this.getMatrix().regression(matrix.getMatrix(), d).getCoefficients();
    }

    public final double[] regression(Matrix matrix, double[] dArray, double d) {
        return this.getMatrix().regression(matrix.getMatrix(), dArray, d).getCoefficients();
    }

    public Matrix getL() throws Exception {
        int n = this.numRows();
        int n2 = this.numColumns();
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < i && j < n2; ++j) {
                dArray[i][j] = this.getElement(i, j);
            }
            if (i >= n2) continue;
            dArray[i][i] = 1.0;
        }
        Matrix matrix = new Matrix(dArray);
        return matrix;
    }

    public Matrix getU() throws Exception {
        int n = this.numRows();
        int n2 = this.numColumns();
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = i; j < n2; ++j) {
                dArray[i][j] = this.getElement(i, j);
            }
        }
        Matrix matrix = new Matrix(dArray);
        return matrix;
    }

    public int[] LUDecomposition() throws Exception {
        LUDecomposition lUDecomposition = this.m_Matrix.lu();
        if (!lUDecomposition.isNonsingular()) {
            throw new Exception("Matrix is singular");
        }
        weka.core.matrix.Matrix matrix = lUDecomposition.getU();
        weka.core.matrix.Matrix matrix2 = lUDecomposition.getL();
        int n = this.numRows();
        int n2 = this.numColumns();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (j < i) {
                    this.setElement(i, j, matrix2.get(i, j));
                    continue;
                }
                this.setElement(i, j, matrix.get(i, j));
            }
        }
        matrix = null;
        matrix2 = null;
        return lUDecomposition.getPivot();
    }

    public void solve(double[] dArray) throws Exception {
        weka.core.matrix.Matrix matrix = this.m_Matrix.solve(new weka.core.matrix.Matrix(dArray, dArray.length));
        int n = matrix.getRowDimension();
        for (int i = 0; i < n; ++i) {
            dArray[i] = matrix.get(i, 0);
        }
    }

    public void eigenvalueDecomposition(double[][] dArray, double[] dArray2) throws Exception {
        int n;
        if (!this.isSymmetric()) {
            throw new Exception("EigenvalueDecomposition: Matrix must be symmetric.");
        }
        EigenvalueDecomposition eigenvalueDecomposition = this.m_Matrix.eig();
        weka.core.matrix.Matrix matrix = eigenvalueDecomposition.getV();
        double[] dArray3 = eigenvalueDecomposition.getRealEigenvalues();
        int n2 = this.numRows();
        int n3 = this.numColumns();
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                dArray[n][i] = matrix.get(n, i);
            }
        }
        for (n = 0; n < dArray3.length; ++n) {
            dArray2[n] = dArray3[n];
        }
    }

    protected static double hypot(double d, double d2) {
        return Maths.hypot(d, d2);
    }

    public String toMatlab() {
        return this.getMatrix().toMatlab();
    }

    public static Matrix parseMatlab(String string) throws Exception {
        return new Matrix(weka.core.matrix.Matrix.parseMatlab(string).getArray());
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.25 $");
    }

    public static void main(String[] stringArray) {
        double[] dArray = new double[]{2.3, 1.2, 5.0};
        double[] dArray2 = new double[]{5.2, 1.4, 9.0};
        double[] dArray3 = new double[]{4.0, 7.0, 8.0};
        double[] dArray4 = new double[]{1.0, 2.0, 3.0};
        try {
            int n;
            double[][] dArrayArray = new double[][]{{1.0, 2.0, 3.0}, {2.0, 5.0, 6.0}, {3.0, 6.0, 9.0}};
            Matrix matrix = new Matrix(dArrayArray);
            int n2 = matrix.numRows();
            double[][] dArray5 = new double[n2][n2];
            double[] dArray6 = new double[n2];
            double[] dArray7 = new double[n2];
            matrix.eigenvalueDecomposition(dArray5, dArray6);
            Matrix matrix2 = new Matrix(dArray5);
            Matrix matrix3 = new Matrix(2, 3);
            Matrix matrix4 = new Matrix(3, 2);
            System.out.println("Number of columns for a: " + matrix3.numColumns());
            System.out.println("Number of rows for a: " + matrix3.numRows());
            matrix3.setRow(0, dArray);
            matrix3.setRow(1, dArray2);
            matrix4.setColumn(0, dArray);
            matrix4.setColumn(1, dArray2);
            System.out.println("a:\n " + matrix3);
            System.out.println("b:\n " + matrix4);
            System.out.println("a (0, 0): " + matrix3.getElement(0, 0));
            System.out.println("a transposed:\n " + matrix3.transpose());
            System.out.println("a * b:\n " + matrix3.multiply(matrix4));
            Matrix matrix5 = new Matrix(3, 1);
            matrix5.setColumn(0, dArray3);
            System.out.println("r:\n " + matrix5);
            System.out.println("Coefficients of regression of b on r: ");
            double[] dArray8 = matrix4.regression(matrix5, 1.0E-8);
            for (n = 0; n < dArray8.length; ++n) {
                System.out.print(dArray8[n] + " ");
            }
            System.out.println();
            System.out.println("Weights: ");
            for (n = 0; n < dArray4.length; ++n) {
                System.out.print(dArray4[n] + " ");
            }
            System.out.println();
            System.out.println("Coefficients of weighted regression of b on r: ");
            dArray8 = matrix4.regression(matrix5, dArray4, 1.0E-8);
            for (n = 0; n < dArray8.length; ++n) {
                System.out.print(dArray8[n] + " ");
            }
            System.out.println();
            matrix3.setElement(0, 0, 6.0);
            System.out.println("a with (0, 0) set to 6:\n " + matrix3);
            matrix3.write(new FileWriter("main.matrix"));
            System.out.println("wrote matrix to \"main.matrix\"\n" + matrix3);
            matrix3 = new Matrix(new FileReader("main.matrix"));
            System.out.println("read matrix from \"main.matrix\"\n" + matrix3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

