/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.supervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.matrix.EigenvalueDecomposition;
import weka.core.matrix.Matrix;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.SupervisedFilter;
import weka.filters.unsupervised.attribute.Center;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;
import weka.filters.unsupervised.attribute.Standardize;

public class PLSFilter
extends SimpleBatchFilter
implements SupervisedFilter,
TechnicalInformationHandler {
    static final long serialVersionUID = -3335106965521265631L;
    public static final int ALGORITHM_SIMPLS = 1;
    public static final int ALGORITHM_PLS1 = 2;
    public static final Tag[] TAGS_ALGORITHM = new Tag[]{new Tag(1, "SIMPLS"), new Tag(2, "PLS1")};
    public static final int PREPROCESSING_NONE = 0;
    public static final int PREPROCESSING_CENTER = 1;
    public static final int PREPROCESSING_STANDARDIZE = 2;
    public static final Tag[] TAGS_PREPROCESSING = new Tag[]{new Tag(0, "none"), new Tag(1, "center"), new Tag(2, "standardize")};
    protected int m_NumComponents = 20;
    protected int m_Algorithm = 2;
    protected Matrix m_PLS1_RegVector = null;
    protected Matrix m_PLS1_P = null;
    protected Matrix m_PLS1_W = null;
    protected Matrix m_PLS1_b_hat = null;
    protected Matrix m_SIMPLS_W = null;
    protected Matrix m_SIMPLS_B = null;
    protected boolean m_PerformPrediction = false;
    protected Filter m_Missing = new ReplaceMissingValues();
    protected boolean m_ReplaceMissing = true;
    protected Filter m_Filter = new Center();
    protected int m_Preprocessing = 1;
    protected double m_ClassMean = 0.0;
    protected double m_ClassStdDev = 0.0;

    public String globalInfo() {
        return "Runs Partial Least Square Regression over the given instances and computes the resulting beta matrix for prediction.\nBy default it replaces missing values and centers the data.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.BOOK);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Tormod Naes and Tomas Isaksson and Tom Fearn and Tony Davies");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2002");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "A User Friendly Guide to Multivariate Calibration and Classification");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "NIR Publications");
        technicalInformation.setValue(TechnicalInformation.Field.ISBN, "0-9528666-2-5");
        TechnicalInformation technicalInformation2 = technicalInformation.add(TechnicalInformation.Type.MISC);
        technicalInformation2.setValue(TechnicalInformation.Field.AUTHOR, "StatSoft, Inc.");
        technicalInformation2.setValue(TechnicalInformation.Field.TITLE, "Partial Least Squares (PLS)");
        technicalInformation2.setValue(TechnicalInformation.Field.BOOKTITLE, "Electronic Textbook StatSoft");
        technicalInformation2.setValue(TechnicalInformation.Field.HTTP, "http://www.statsoft.com/textbook/stpls.html");
        technicalInformation2 = technicalInformation.add(TechnicalInformation.Type.MISC);
        technicalInformation2.setValue(TechnicalInformation.Field.AUTHOR, "Bent Jorgensen and Yuri Goegebeur");
        technicalInformation2.setValue(TechnicalInformation.Field.TITLE, "Module 7: Partial least squares regression I");
        technicalInformation2.setValue(TechnicalInformation.Field.BOOKTITLE, "ST02: Multivariate Data Analysis and Chemometrics");
        technicalInformation2.setValue(TechnicalInformation.Field.HTTP, "http://statmaster.sdu.dk/courses/ST02/module07/");
        technicalInformation2 = technicalInformation.add(TechnicalInformation.Type.ARTICLE);
        technicalInformation2.setValue(TechnicalInformation.Field.AUTHOR, "S. de Jong");
        technicalInformation2.setValue(TechnicalInformation.Field.YEAR, "1993");
        technicalInformation2.setValue(TechnicalInformation.Field.TITLE, "SIMPLS: an alternative approach to partial least squares regression");
        technicalInformation2.setValue(TechnicalInformation.Field.JOURNAL, "Chemometrics and Intelligent Laboratory Systems");
        technicalInformation2.setValue(TechnicalInformation.Field.VOLUME, "18");
        technicalInformation2.setValue(TechnicalInformation.Field.PAGES, "251-263");
        return technicalInformation;
    }

    public Enumeration listOptions() {
        SelectedTag selectedTag;
        int n;
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        vector.addElement(new Option("\tThe number of components to compute.\n\t(default: 20)", "C", 1, "-C <num>"));
        vector.addElement(new Option("\tUpdates the class attribute as well.\n\t(default: off)", "U", 0, "-U"));
        vector.addElement(new Option("\tTurns replacing of missing values on.\n\t(default: off)", "M", 0, "-M"));
        String string = "";
        for (n = 0; n < TAGS_ALGORITHM.length; ++n) {
            if (n > 0) {
                string = string + "|";
            }
            selectedTag = new SelectedTag(TAGS_ALGORITHM[n].getID(), TAGS_ALGORITHM);
            string = string + selectedTag.getSelectedTag().getReadable();
        }
        vector.addElement(new Option("\tThe algorithm to use.\n\t(default: PLS1)", "A", 1, "-A <" + string + ">"));
        string = "";
        for (n = 0; n < TAGS_PREPROCESSING.length; ++n) {
            if (n > 0) {
                string = string + "|";
            }
            selectedTag = new SelectedTag(TAGS_PREPROCESSING[n].getID(), TAGS_PREPROCESSING);
            string = string + selectedTag.getSelectedTag().getReadable();
        }
        vector.addElement(new Option("\tThe type of preprocessing that is applied to the data.\n\t(default: center)", "P", 1, "-P <" + string + ">"));
        return vector.elements();
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-C");
        vector.add("" + this.getNumComponents());
        if (this.getPerformPrediction()) {
            vector.add("-U");
        }
        if (this.getReplaceMissing()) {
            vector.add("-M");
        }
        vector.add("-A");
        vector.add("" + this.getAlgorithm().getSelectedTag().getReadable());
        vector.add("-P");
        vector.add("" + this.getPreprocessing().getSelectedTag().getReadable());
        return vector.toArray(new String[vector.size()]);
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        String string = Utils.getOption("C", stringArray);
        if (string.length() != 0) {
            this.setNumComponents(Integer.parseInt(string));
        } else {
            this.setNumComponents(20);
        }
        this.setPerformPrediction(Utils.getFlag("U", stringArray));
        this.setReplaceMissing(Utils.getFlag("M", stringArray));
        string = Utils.getOption("A", stringArray);
        if (string.length() != 0) {
            this.setAlgorithm(new SelectedTag(string, TAGS_ALGORITHM));
        } else {
            this.setAlgorithm(new SelectedTag(2, TAGS_ALGORITHM));
        }
        string = Utils.getOption("P", stringArray);
        if (string.length() != 0) {
            this.setPreprocessing(new SelectedTag(string, TAGS_PREPROCESSING));
        } else {
            this.setPreprocessing(new SelectedTag(1, TAGS_PREPROCESSING));
        }
    }

    public String numComponentsTipText() {
        return "The number of components to compute.";
    }

    public void setNumComponents(int n) {
        this.m_NumComponents = n;
    }

    public int getNumComponents() {
        return this.m_NumComponents;
    }

    public String performPredictionTipText() {
        return "Whether to update the class attribute with the predicted value.";
    }

    public void setPerformPrediction(boolean bl) {
        this.m_PerformPrediction = bl;
    }

    public boolean getPerformPrediction() {
        return this.m_PerformPrediction;
    }

    public String algorithmTipText() {
        return "Sets the type of algorithm to use.";
    }

    public void setAlgorithm(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_ALGORITHM) {
            this.m_Algorithm = selectedTag.getSelectedTag().getID();
        }
    }

    public SelectedTag getAlgorithm() {
        return new SelectedTag(this.m_Algorithm, TAGS_ALGORITHM);
    }

    public String replaceMissingTipText() {
        return "Whether to replace missing values.";
    }

    public void setReplaceMissing(boolean bl) {
        this.m_ReplaceMissing = bl;
    }

    public boolean getReplaceMissing() {
        return this.m_ReplaceMissing;
    }

    public String preprocessingTipText() {
        return "Sets the type of preprocessing to use.";
    }

    public void setPreprocessing(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_PREPROCESSING) {
            this.m_Preprocessing = selectedTag.getSelectedTag().getID();
        }
    }

    public SelectedTag getPreprocessing() {
        return new SelectedTag(this.m_Preprocessing, TAGS_PREPROCESSING);
    }

    protected Instances determineOutputFormat(Instances instances) throws Exception {
        FastVector fastVector = new FastVector();
        String string = this.getAlgorithm().getSelectedTag().getReadable();
        for (int i = 0; i < this.getNumComponents(); ++i) {
            fastVector.addElement(new Attribute(string + "_" + (i + 1)));
        }
        fastVector.addElement(new Attribute("Class"));
        Instances instances2 = new Instances(string, fastVector, 0);
        instances2.setClassIndex(instances2.numAttributes() - 1);
        return instances2;
    }

    protected Matrix getX(Instances instances) {
        int n = instances.classIndex();
        double[][] dArrayArray = new double[instances.numInstances()][];
        for (int i = 0; i < instances.numInstances(); ++i) {
            double[] dArray = instances.instance(i).toDoubleArray();
            dArrayArray[i] = new double[dArray.length - 1];
            int n2 = 0;
            for (int j = 0; j < dArray.length; ++j) {
                if (j == n) continue;
                dArrayArray[i][n2] = dArray[j];
                ++n2;
            }
        }
        Matrix matrix = new Matrix(dArrayArray);
        return matrix;
    }

    protected Matrix getX(Instance instance) {
        double[][] dArrayArray = new double[1][];
        double[] dArray = instance.toDoubleArray();
        dArrayArray[0] = new double[dArray.length - 1];
        System.arraycopy(dArray, 0, dArrayArray[0], 0, dArray.length - 1);
        Matrix matrix = new Matrix(dArrayArray);
        return matrix;
    }

    protected Matrix getY(Instances instances) {
        double[][] dArray = new double[instances.numInstances()][1];
        for (int i = 0; i < instances.numInstances(); ++i) {
            dArray[i][0] = instances.instance(i).classValue();
        }
        Matrix matrix = new Matrix(dArray);
        return matrix;
    }

    protected Matrix getY(Instance instance) {
        double[][] dArray = new double[1][1];
        dArray[0][0] = instance.classValue();
        Matrix matrix = new Matrix(dArray);
        return matrix;
    }

    protected Instances toInstances(Instances instances, Matrix matrix, Matrix matrix2) {
        Instances instances2 = new Instances(instances, 0);
        int n = matrix.getRowDimension();
        int n2 = matrix.getColumnDimension();
        int n3 = instances.classIndex();
        for (int i = 0; i < n; ++i) {
            double[] dArray = new double[n2 + 1];
            int n4 = 0;
            for (int j = 0; j < dArray.length; ++j) {
                if (j == n3) {
                    --n4;
                    dArray[j] = matrix2.get(i, 0);
                    continue;
                }
                dArray[j] = matrix.get(i, j + n4);
            }
            instances2.add(new Instance(1.0, dArray));
        }
        return instances2;
    }

    protected Matrix columnAsVector(Matrix matrix, int n) {
        Matrix matrix2 = new Matrix(matrix.getRowDimension(), 1);
        for (int i = 0; i < matrix.getRowDimension(); ++i) {
            matrix2.set(i, 0, matrix.get(i, n));
        }
        return matrix2;
    }

    protected void setVector(Matrix matrix, Matrix matrix2, int n) {
        matrix2.setMatrix(0, matrix2.getRowDimension() - 1, n, n, matrix);
    }

    protected Matrix getVector(Matrix matrix, int n) {
        return matrix.getMatrix(0, matrix.getRowDimension() - 1, n, n);
    }

    protected Matrix getDominantEigenVector(Matrix matrix) {
        EigenvalueDecomposition eigenvalueDecomposition = matrix.eig();
        double[] dArray = eigenvalueDecomposition.getRealEigenvalues();
        int n = Utils.maxIndex(dArray);
        Matrix matrix2 = this.columnAsVector(eigenvalueDecomposition.getV(), n);
        return matrix2;
    }

    protected void normalizeVector(Matrix matrix) {
        int n;
        double d = 0.0;
        for (n = 0; n < matrix.getRowDimension(); ++n) {
            d += matrix.get(n, 0) * matrix.get(n, 0);
        }
        d = StrictMath.sqrt(d);
        for (n = 0; n < matrix.getRowDimension(); ++n) {
            matrix.set(n, 0, matrix.get(n, 0) / d);
        }
    }

    protected Instances processPLS1(Instances instances) throws Exception {
        Instances instances2;
        if (!this.isFirstBatchDone()) {
            Matrix matrix = this.getX(instances);
            Matrix matrix2 = this.getY(instances);
            Matrix matrix3 = matrix.transpose();
            Matrix matrix4 = new Matrix(instances.numAttributes() - 1, this.getNumComponents());
            Matrix matrix5 = new Matrix(instances.numAttributes() - 1, this.getNumComponents());
            Matrix matrix6 = new Matrix(instances.numInstances(), this.getNumComponents());
            Matrix matrix7 = new Matrix(this.getNumComponents(), 1);
            for (int i = 0; i < this.getNumComponents(); ++i) {
                Matrix matrix8 = matrix3.times(matrix2);
                this.normalizeVector(matrix8);
                this.setVector(matrix8, matrix4, i);
                Matrix matrix9 = matrix.times(matrix8);
                Matrix matrix10 = matrix9.transpose();
                this.setVector(matrix9, matrix6, i);
                double d = matrix10.times(matrix2).get(0, 0) / matrix10.times(matrix9).get(0, 0);
                matrix7.set(i, 0, d);
                Matrix matrix11 = matrix3.times(matrix9).times(1.0 / matrix10.times(matrix9).get(0, 0));
                Matrix matrix12 = matrix11.transpose();
                this.setVector(matrix11, matrix5, i);
                matrix = matrix.minus(matrix9.times(matrix12));
                matrix2 = matrix2.minus(matrix9.times(d));
            }
            Matrix matrix13 = matrix4.times(matrix5.transpose().times(matrix4).inverse());
            Matrix matrix14 = this.getX(instances).times(matrix13);
            this.m_PLS1_RegVector = matrix13.times(matrix7);
            this.m_PLS1_P = matrix5;
            this.m_PLS1_W = matrix4;
            this.m_PLS1_b_hat = matrix7;
            instances2 = this.getPerformPrediction() ? this.toInstances(this.getOutputFormat(), matrix14, matrix2) : this.toInstances(this.getOutputFormat(), matrix14, this.getY(instances));
        } else {
            instances2 = new Instances(this.getOutputFormat());
            for (int i = 0; i < instances.numInstances(); ++i) {
                Instances instances3 = new Instances(instances, 0);
                instances3.add((Instance)instances.instance(i).copy());
                Matrix matrix = this.getX(instances3);
                Matrix matrix15 = new Matrix(1, this.getNumComponents());
                Matrix matrix16 = new Matrix(1, this.getNumComponents());
                for (int j = 0; j < this.getNumComponents(); ++j) {
                    this.setVector(matrix, matrix15, j);
                    Matrix matrix17 = matrix.times(this.getVector(this.m_PLS1_W, j));
                    this.setVector(matrix17, matrix16, j);
                    matrix = matrix.minus(this.getVector(this.m_PLS1_P, j).transpose().times(matrix17.get(0, 0)));
                }
                instances3 = this.getPerformPrediction() ? this.toInstances(this.getOutputFormat(), matrix16, matrix16.times(this.m_PLS1_b_hat)) : this.toInstances(this.getOutputFormat(), matrix16, this.getY(instances3));
                instances2.add(instances3.instance(0));
            }
        }
        return instances2;
    }

    protected Instances processSIMPLS(Instances instances) throws Exception {
        Instances instances2;
        if (!this.isFirstBatchDone()) {
            Matrix matrix;
            Matrix matrix2 = this.getX(instances);
            Matrix matrix3 = matrix2.transpose();
            Matrix matrix4 = this.getY(instances);
            Matrix matrix5 = matrix3.times(matrix4);
            Matrix matrix6 = matrix3.times(matrix2);
            Matrix matrix7 = Matrix.identity(instances.numAttributes() - 1, instances.numAttributes() - 1);
            Matrix matrix8 = new Matrix(instances.numAttributes() - 1, this.getNumComponents());
            Matrix matrix9 = new Matrix(instances.numAttributes() - 1, this.getNumComponents());
            Matrix matrix10 = new Matrix(1, this.getNumComponents());
            for (int i = 0; i < this.getNumComponents(); ++i) {
                Matrix matrix11 = matrix5.transpose();
                Matrix matrix12 = this.getDominantEigenVector(matrix11.times(matrix5));
                Matrix matrix13 = matrix5.times(matrix12);
                Matrix matrix14 = matrix13.transpose().times(matrix6).times(matrix13);
                matrix13 = matrix13.times(1.0 / StrictMath.sqrt(matrix14.get(0, 0)));
                this.setVector(matrix13, matrix8, i);
                Matrix matrix15 = matrix6.times(matrix13);
                Matrix matrix16 = matrix15.transpose();
                this.setVector(matrix15, matrix9, i);
                matrix12 = matrix11.times(matrix13);
                this.setVector(matrix12, matrix10, i);
                Matrix matrix17 = matrix7.times(matrix15);
                this.normalizeVector(matrix17);
                Matrix matrix18 = matrix17.transpose();
                matrix7 = matrix7.minus(matrix17.times(matrix18));
                matrix6 = matrix6.minus(matrix15.times(matrix16));
                matrix5 = matrix7.times(matrix5);
            }
            this.m_SIMPLS_W = matrix8;
            Matrix matrix19 = matrix = matrix2.times(this.m_SIMPLS_W);
            this.m_SIMPLS_B = matrix8.times(matrix10.transpose());
            Matrix matrix20 = this.getPerformPrediction() ? matrix.times(matrix9.transpose()).times(this.m_SIMPLS_B) : this.getY(instances);
            instances2 = this.toInstances(this.getOutputFormat(), matrix19, matrix20);
        } else {
            instances2 = new Instances(this.getOutputFormat());
            Matrix matrix = this.getX(instances);
            Matrix matrix21 = matrix.times(this.m_SIMPLS_W);
            Matrix matrix22 = this.getPerformPrediction() ? matrix.times(this.m_SIMPLS_B) : this.getY(instances);
            instances2 = this.toInstances(this.getOutputFormat(), matrix21, matrix22);
        }
        return instances2;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAll();
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NUMERIC_CLASS);
        capabilities.enable(Capabilities.Capability.DATE_CLASS);
        return capabilities;
    }

    protected Instances process(Instances instances) throws Exception {
        Instances instances2 = null;
        double[] dArray = !this.getPerformPrediction() ? instances.attributeToDoubleArray(instances.classIndex()) : null;
        if (!this.isFirstBatchDone()) {
            if (this.m_ReplaceMissing) {
                this.m_Missing.setInputFormat(instances);
            }
            switch (this.m_Preprocessing) {
                case 1: {
                    this.m_ClassMean = instances.meanOrMode(instances.classIndex());
                    this.m_ClassStdDev = 1.0;
                    this.m_Filter = new Center();
                    ((Center)this.m_Filter).setIgnoreClass(true);
                    break;
                }
                case 2: {
                    this.m_ClassMean = instances.meanOrMode(instances.classIndex());
                    this.m_ClassStdDev = StrictMath.sqrt(instances.variance(instances.classIndex()));
                    this.m_Filter = new Standardize();
                    ((Standardize)this.m_Filter).setIgnoreClass(true);
                    break;
                }
                default: {
                    this.m_ClassMean = 0.0;
                    this.m_ClassStdDev = 1.0;
                    this.m_Filter = null;
                }
            }
            if (this.m_Filter != null) {
                this.m_Filter.setInputFormat(instances);
            }
        }
        if (this.m_ReplaceMissing) {
            instances = Filter.useFilter(instances, this.m_Missing);
        }
        if (this.m_Filter != null) {
            instances = Filter.useFilter(instances, this.m_Filter);
        }
        switch (this.m_Algorithm) {
            case 1: {
                instances2 = this.processSIMPLS(instances);
                break;
            }
            case 2: {
                instances2 = this.processPLS1(instances);
                break;
            }
            default: {
                throw new IllegalStateException("Algorithm type '" + this.m_Algorithm + "' is not recognized!");
            }
        }
        for (int i = 0; i < instances2.numInstances(); ++i) {
            if (!this.getPerformPrediction()) {
                instances2.instance(i).setClassValue(dArray[i]);
                continue;
            }
            double d = instances2.instance(i).classValue();
            instances2.instance(i).setClassValue(d * this.m_ClassStdDev + this.m_ClassMean);
        }
        return instances2;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5541 $");
    }

    public static void main(String[] stringArray) {
        PLSFilter.runFilter(new PLSFilter(), stringArray);
    }
}

