/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.AttributeEvaluator;
import weka.classifiers.CostMatrix;
import weka.core.Capabilities;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public abstract class CostSensitiveASEvaluation
extends ASEvaluation
implements OptionHandler,
Serializable {
    static final long serialVersionUID = -7045833833363396977L;
    public static final int MATRIX_ON_DEMAND = 1;
    public static final int MATRIX_SUPPLIED = 2;
    public static final Tag[] TAGS_MATRIX_SOURCE = new Tag[]{new Tag(1, "Load cost matrix on demand"), new Tag(2, "Use explicit cost matrix")};
    protected int m_MatrixSource = 1;
    protected File m_OnDemandDirectory = new File(System.getProperty("user.dir"));
    protected String m_CostFile;
    protected CostMatrix m_CostMatrix = new CostMatrix(1);
    protected ASEvaluation m_evaluator;
    protected int m_seed = 1;

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(4);
        vector.addElement(new Option("\tFile name of a cost matrix to use. If this is not supplied,\n\ta cost matrix will be loaded on demand. The name of the\n\ton-demand file is the relation name of the training data\n\tplus \".cost\", and the path to the on-demand file is\n\tspecified with the -N option.", "C", 1, "-C <cost file name>"));
        vector.addElement(new Option("\tName of a directory to search for cost files when loading\n\tcosts on demand (default current directory).", "N", 1, "-N <directory>"));
        vector.addElement(new Option("\tThe cost matrix in Matlab single line format.", "cost-matrix", 1, "-cost-matrix <matrix>"));
        vector.addElement(new Option("\tThe seed to use for random number generation.", "S", 1, "-S <integer>"));
        vector.addElement(new Option("\tFull name of base evaluator. Options after -- are passed to the evaluator.\n\t(default: " + this.defaultEvaluatorString() + ")", "W", 1, "-W"));
        if (this.m_evaluator instanceof OptionHandler) {
            vector.addElement(new Option("", "", 0, "\nOptions specific to evaluator " + this.m_evaluator.getClass().getName() + ":"));
            Enumeration enumeration = ((OptionHandler)((Object)this.m_evaluator)).listOptions();
            while (enumeration.hasMoreElements()) {
                vector.addElement((Option)enumeration.nextElement());
            }
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        Object object;
        String string;
        String string2 = Utils.getOption('C', stringArray);
        if (string2.length() != 0) {
            try {
                this.setCostMatrix(new CostMatrix(new BufferedReader(new FileReader(string2))));
            }
            catch (Exception exception) {
                this.setCostMatrix(null);
            }
            this.setCostMatrixSource(new SelectedTag(2, TAGS_MATRIX_SOURCE));
            this.m_CostFile = string2;
        } else {
            this.setCostMatrixSource(new SelectedTag(1, TAGS_MATRIX_SOURCE));
        }
        String string3 = Utils.getOption('N', stringArray);
        if (string3.length() != 0) {
            this.setOnDemandDirectory(new File(string3));
        }
        if ((string = Utils.getOption("cost-matrix", stringArray)).length() != 0) {
            object = new StringWriter();
            CostMatrix.parseMatlab(string).write((Writer)object);
            this.setCostMatrix(new CostMatrix(new StringReader(((StringWriter)object).toString())));
            this.setCostMatrixSource(new SelectedTag(2, TAGS_MATRIX_SOURCE));
        }
        if (((String)(object = Utils.getOption('S', stringArray))).length() != 0) {
            this.setSeed(Integer.parseInt((String)object));
        } else {
            this.setSeed(1);
        }
        String string4 = Utils.getOption('W', stringArray);
        if (string4.length() > 0) {
            this.setEvaluator(ASEvaluation.forName(string4, null));
            this.setEvaluator(ASEvaluation.forName(string4, Utils.partitionOptions(stringArray)));
        } else {
            this.setEvaluator(ASEvaluation.forName(this.defaultEvaluatorString(), null));
            this.setEvaluator(ASEvaluation.forName(this.defaultEvaluatorString(), Utils.partitionOptions(stringArray)));
        }
    }

    public String[] getOptions() {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.m_MatrixSource == 2) {
            if (this.m_CostFile != null) {
                arrayList.add("-C");
                arrayList.add("" + this.m_CostFile);
            } else {
                arrayList.add("-cost-matrix");
                arrayList.add(this.getCostMatrix().toMatlab());
            }
        } else {
            arrayList.add("-N");
            arrayList.add("" + this.getOnDemandDirectory());
        }
        arrayList.add("-S");
        arrayList.add("" + this.getSeed());
        arrayList.add("-W");
        arrayList.add(this.m_evaluator.getClass().getName());
        if (this.m_evaluator instanceof OptionHandler && (stringArray = ((OptionHandler)((Object)this.m_evaluator)).getOptions()).length > 0) {
            arrayList.add("--");
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public String globalInfo() {
        return "A meta subset evaluator that makes its base subset evaluator cost-sensitive. ";
    }

    public String defaultEvaluatorString() {
        return "weka.attributeSelection.CfsSubsetEval";
    }

    public String costMatrixSourceTipText() {
        return "Sets where to get the cost matrix. The two options areto use the supplied explicit cost matrix (the setting of the costMatrix property), or to load a cost matrix from a file when required (this file will be loaded from the directory set by the onDemandDirectory property and will be named relation_name" + CostMatrix.FILE_EXTENSION + ").";
    }

    public SelectedTag getCostMatrixSource() {
        return new SelectedTag(this.m_MatrixSource, TAGS_MATRIX_SOURCE);
    }

    public void setCostMatrixSource(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_MATRIX_SOURCE) {
            this.m_MatrixSource = selectedTag.getSelectedTag().getID();
        }
    }

    public String onDemandDirectoryTipText() {
        return "Sets the directory where cost files are loaded from. This option is used when the costMatrixSource is set to \"On Demand\".";
    }

    public File getOnDemandDirectory() {
        return this.m_OnDemandDirectory;
    }

    public void setOnDemandDirectory(File file) {
        this.m_OnDemandDirectory = file.isDirectory() ? file : new File(file.getParent());
        this.m_MatrixSource = 1;
    }

    protected String getEvaluatorSpec() {
        ASEvaluation aSEvaluation = this.getEvaluator();
        if (aSEvaluation instanceof OptionHandler) {
            return aSEvaluation.getClass().getName() + " " + Utils.joinOptions(((OptionHandler)((Object)aSEvaluation)).getOptions());
        }
        return aSEvaluation.getClass().getName();
    }

    public String costMatrixTipText() {
        return "Sets the cost matrix explicitly. This matrix is used if the costMatrixSource property is set to \"Supplied\".";
    }

    public CostMatrix getCostMatrix() {
        return this.m_CostMatrix;
    }

    public void setCostMatrix(CostMatrix costMatrix) {
        this.m_CostMatrix = costMatrix;
        this.m_MatrixSource = 2;
    }

    public String seedTipText() {
        return "The random number seed to be used.";
    }

    public void setSeed(int n) {
        this.m_seed = n;
    }

    public int getSeed() {
        return this.m_seed;
    }

    public String evaluatorTipText() {
        return "The base evaluator to be used.";
    }

    public void setEvaluator(ASEvaluation aSEvaluation) throws IllegalArgumentException {
        this.m_evaluator = aSEvaluation;
    }

    public ASEvaluation getEvaluator() {
        return this.m_evaluator;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities;
        if (this.getEvaluator() != null) {
            capabilities = this.getEvaluator().getCapabilities();
        } else {
            capabilities = new Capabilities(this);
            capabilities.disableAll();
        }
        capabilities.disableAllClasses();
        capabilities.disableAllClassDependencies();
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        return capabilities;
    }

    public void buildEvaluator(Instances instances) throws Exception {
        Object object;
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        if (this.m_evaluator == null) {
            throw new Exception("No base evaluator has been set!");
        }
        if (this.m_MatrixSource == 1) {
            object = instances.relationName() + CostMatrix.FILE_EXTENSION;
            File file = new File(this.getOnDemandDirectory(), (String)object);
            if (!file.exists()) {
                throw new Exception("On-demand cost file doesn't exist: " + file);
            }
            this.setCostMatrix(new CostMatrix(new BufferedReader(new FileReader(file))));
        } else if (this.m_CostMatrix == null) {
            this.m_CostMatrix = new CostMatrix(instances.numClasses());
            this.m_CostMatrix.readOldFormat(new BufferedReader(new FileReader(this.m_CostFile)));
        }
        object = null;
        if (!(this.m_evaluator instanceof WeightedInstancesHandler)) {
            object = new Random(this.m_seed);
        }
        instances = this.m_CostMatrix.applyCostMatrix(instances, (Random)object);
        this.m_evaluator.buildEvaluator(instances);
    }

    public int[] postProcess(int[] nArray) throws Exception {
        return this.m_evaluator.postProcess(nArray);
    }

    public String toString() {
        if (this.m_evaluator == null) {
            return "CostSensitiveASEvaluation: No model built yet.";
        }
        String string = this.m_evaluator instanceof AttributeEvaluator ? "CostSensitiveAttributeEval using " : "CostSensitiveSubsetEval using ";
        string = string + "\n\n" + this.getEvaluatorSpec() + "\n\nEvaluator\n" + this.m_evaluator.toString() + "\n\nCost Matrix\n" + this.m_CostMatrix.toString();
        return string;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5562 $");
    }
}

