/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.functions.supportVector.Kernel;
import weka.classifiers.functions.supportVector.PolyKernel;
import weka.classifiers.functions.supportVector.RegOptimizer;
import weka.classifiers.functions.supportVector.RegSMOImproved;
import weka.core.AdditionalMeasureProducer;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.Normalize;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;
import weka.filters.unsupervised.attribute.Standardize;

public class SVMreg
extends Classifier
implements WeightedInstancesHandler,
AdditionalMeasureProducer,
TechnicalInformationHandler {
    private static final long serialVersionUID = -7149606251113102827L;
    public static final int FILTER_NORMALIZE = 0;
    public static final int FILTER_STANDARDIZE = 1;
    public static final int FILTER_NONE = 2;
    public static final Tag[] TAGS_FILTER = new Tag[]{new Tag(0, "Normalize training data"), new Tag(1, "Standardize training data"), new Tag(2, "No normalization/standardization")};
    protected int m_filterType = 0;
    protected NominalToBinary m_NominalToBinary;
    protected Filter m_Filter = null;
    protected ReplaceMissingValues m_Missing;
    protected boolean m_onlyNumeric;
    protected double m_C = 1.0;
    protected double m_x1 = 1.0;
    protected double m_x0 = 0.0;
    protected RegOptimizer m_optimizer = new RegSMOImproved();
    protected Kernel m_kernel = new PolyKernel();

    public String globalInfo() {
        return "SVMreg implements the support vector machine for regression. The parameters can be learned using various algorithms. The algorithm is selected by setting the RegOptimizer. The most popular algorithm (" + RegSMOImproved.class.getName().replaceAll(".*\\.", "") + ") is due to Shevade, Keerthi " + "et al and this is the default RegOptimizer.\n\n" + "For more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "S.K. Shevade and S.S. Keerthi and C. Bhattacharyya and K.R.K. Murthy");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Improvements to the SMO Algorithm for SVM Regression");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "IEEE Transactions on Neural Networks");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1999");
        technicalInformation.setValue(TechnicalInformation.Field.PS, "http://guppy.mpe.nus.edu.sg/~mpessk/svm/ieee_smo_reg.ps.gz");
        TechnicalInformation technicalInformation2 = technicalInformation.add(TechnicalInformation.Type.TECHREPORT);
        technicalInformation2.setValue(TechnicalInformation.Field.AUTHOR, "A.J. Smola and B. Schoelkopf");
        technicalInformation2.setValue(TechnicalInformation.Field.TITLE, "A tutorial on support vector regression");
        technicalInformation2.setValue(TechnicalInformation.Field.NOTE, "NeuroCOLT2 Technical Report NC2-TR-1998-030");
        technicalInformation2.setValue(TechnicalInformation.Field.YEAR, "1998");
        return technicalInformation;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tThe complexity constant C.\n\t(default 1)", "C", 1, "-C <double>"));
        vector.addElement(new Option("\tWhether to 0=normalize/1=standardize/2=neither.\n\t(default 0=normalize)", "N", 1, "-N"));
        vector.addElement(new Option("\tOptimizer class used for solving quadratic optimization problem\n\t(default " + RegSMOImproved.class.getName() + ")", "I", 1, "-I <classname and parameters>"));
        vector.addElement(new Option("\tThe Kernel to use.\n\t(default: weka.classifiers.functions.supportVector.PolyKernel)", "K", 1, "-K <classname and parameters>"));
        vector.addElement(new Option("", "", 0, "\nOptions specific to optimizer ('-I') " + this.getRegOptimizer().getClass().getName() + ":"));
        Enumeration enumeration = this.getRegOptimizer().listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        vector.addElement(new Option("", "", 0, "\nOptions specific to kernel ('-K') " + this.getKernel().getClass().getName() + ":"));
        enumeration = this.getKernel().listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('C', stringArray);
        if (string.length() != 0) {
            this.setC(Double.parseDouble(string));
        } else {
            this.setC(1.0);
        }
        String string2 = Utils.getOption('N', stringArray);
        if (string2.length() != 0) {
            this.setFilterType(new SelectedTag(Integer.parseInt(string2), TAGS_FILTER));
        } else {
            this.setFilterType(new SelectedTag(0, TAGS_FILTER));
        }
        string = Utils.getOption('I', stringArray);
        String[] stringArray2 = Utils.splitOptions(string);
        if (stringArray2.length != 0) {
            string = stringArray2[0];
            stringArray2[0] = "";
            this.setRegOptimizer((RegOptimizer)Utils.forName(RegOptimizer.class, string, stringArray2));
        } else {
            this.setRegOptimizer(new RegSMOImproved());
        }
        string = Utils.getOption('K', stringArray);
        stringArray2 = Utils.splitOptions(string);
        if (stringArray2.length != 0) {
            string = stringArray2[0];
            stringArray2[0] = "";
            this.setKernel(Kernel.forName(string, stringArray2));
        } else {
            this.setKernel(new PolyKernel());
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-C");
        vector.add("" + this.getC());
        vector.add("-N");
        vector.add("" + this.m_filterType);
        vector.add("-I");
        vector.add("" + this.getRegOptimizer().getClass().getName() + " " + Utils.joinOptions(this.getRegOptimizer().getOptions()));
        vector.add("-K");
        vector.add("" + this.getKernel().getClass().getName() + " " + Utils.joinOptions(this.getKernel().getOptions()));
        return vector.toArray(new String[vector.size()]);
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = this.getKernel().getCapabilities();
        capabilities.setOwner(this);
        capabilities.enableAllAttributeDependencies();
        if (capabilities.handles(Capabilities.Capability.NUMERIC_ATTRIBUTES)) {
            capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        }
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.disableAllClasses();
        capabilities.disableAllClassDependencies();
        capabilities.enable(Capabilities.Capability.NUMERIC_CLASS);
        capabilities.enable(Capabilities.Capability.DATE_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        int n;
        int n2;
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        Instances instances2 = new Instances(instances, 0);
        for (n2 = 0; n2 < instances.numInstances(); ++n2) {
            if (!(instances.instance(n2).weight() > 0.0)) continue;
            instances2.add(instances.instance(n2));
        }
        if (instances2.numInstances() == 0) {
            throw new Exception("No training instances left after removing instance with either a weight null or a missing class!");
        }
        instances = instances2;
        this.m_onlyNumeric = true;
        for (n2 = 0; n2 < instances.numAttributes(); ++n2) {
            if (n2 == instances.classIndex() || instances.attribute(n2).isNumeric()) continue;
            this.m_onlyNumeric = false;
            break;
        }
        this.m_Missing = new ReplaceMissingValues();
        this.m_Missing.setInputFormat(instances);
        instances = Filter.useFilter(instances, this.m_Missing);
        if (!this.m_onlyNumeric) {
            this.m_NominalToBinary = new NominalToBinary();
            this.m_NominalToBinary.setInputFormat(instances);
            instances = Filter.useFilter(instances, this.m_NominalToBinary);
        } else {
            this.m_NominalToBinary = null;
        }
        double d = instances.instance(0).classValue();
        for (n = 1; n < instances.numInstances() && instances.instance(n).classValue() == d; ++n) {
        }
        if (n == instances.numInstances()) {
            throw new Exception("All class values are the same. At least two class values should be different");
        }
        double d2 = instances.instance(n).classValue();
        if (this.m_filterType == 1) {
            this.m_Filter = new Standardize();
            ((Standardize)this.m_Filter).setIgnoreClass(true);
            this.m_Filter.setInputFormat(instances);
            instances = Filter.useFilter(instances, this.m_Filter);
        } else if (this.m_filterType == 0) {
            this.m_Filter = new Normalize();
            ((Normalize)this.m_Filter).setIgnoreClass(true);
            this.m_Filter.setInputFormat(instances);
            instances = Filter.useFilter(instances, this.m_Filter);
        } else {
            this.m_Filter = null;
        }
        if (this.m_Filter != null) {
            double d3 = instances.instance(0).classValue();
            double d4 = instances.instance(n).classValue();
            this.m_x1 = (d - d2) / (d3 - d4);
            this.m_x0 = d - this.m_x1 * d3;
        } else {
            this.m_x1 = 1.0;
            this.m_x0 = 0.0;
        }
        this.m_optimizer.setSVMReg(this);
        this.m_optimizer.buildClassifier(instances);
    }

    public double classifyInstance(Instance instance) throws Exception {
        this.m_Missing.input(instance);
        this.m_Missing.batchFinished();
        instance = this.m_Missing.output();
        if (!this.m_onlyNumeric) {
            this.m_NominalToBinary.input(instance);
            this.m_NominalToBinary.batchFinished();
            instance = this.m_NominalToBinary.output();
        }
        if (this.m_Filter != null) {
            this.m_Filter.input(instance);
            this.m_Filter.batchFinished();
            instance = this.m_Filter.output();
        }
        double d = this.m_optimizer.SVMOutput(instance);
        return d * this.m_x1 + this.m_x0;
    }

    public String regOptimizerTipText() {
        return "The learning algorithm.";
    }

    public void setRegOptimizer(RegOptimizer regOptimizer) {
        this.m_optimizer = regOptimizer;
    }

    public RegOptimizer getRegOptimizer() {
        return this.m_optimizer;
    }

    public String kernelTipText() {
        return "The kernel to use.";
    }

    public void setKernel(Kernel kernel) {
        this.m_kernel = kernel;
    }

    public Kernel getKernel() {
        return this.m_kernel;
    }

    public String cTipText() {
        return "The complexity parameter C.";
    }

    public double getC() {
        return this.m_C;
    }

    public void setC(double d) {
        this.m_C = d;
    }

    public String filterTypeTipText() {
        return "Determines how/if the data will be transformed.";
    }

    public SelectedTag getFilterType() {
        return new SelectedTag(this.m_filterType, TAGS_FILTER);
    }

    public void setFilterType(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_FILTER) {
            this.m_filterType = selectedTag.getSelectedTag().getID();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_optimizer == null || !this.m_optimizer.modelBuilt()) {
            return "SVMreg: No model built yet.";
        }
        try {
            stringBuffer.append(this.m_optimizer.toString());
        }
        catch (Exception exception) {
            return "Can't print SMVreg classifier.";
        }
        return stringBuffer.toString();
    }

    public Enumeration enumerateMeasures() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("measureKernelEvaluations");
        vector.addElement("measureCacheHits");
        return vector.elements();
    }

    public double getMeasure(String string) {
        if (string.equals("measureKernelEvaluations")) {
            return this.measureKernelEvaluations();
        }
        if (string.equals("measureCacheHits")) {
            return this.measureCacheHits();
        }
        throw new IllegalArgumentException("Measure '" + string + "' is not supported!");
    }

    protected double measureKernelEvaluations() {
        if (this.m_optimizer != null) {
            return this.m_optimizer.getKernelEvaluations();
        }
        return 0.0;
    }

    protected double measureCacheHits() {
        if (this.m_optimizer != null) {
            return this.m_optimizer.getCacheHits();
        }
        return 0.0;
    }

    public static void main(String[] stringArray) {
        SVMreg.runClassifier(new SVMreg(), stringArray);
    }
}

