/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.util.ArrayList;
import weka.core.Attribute;
import weka.core.Utils;
import weka.core.pmml.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuiltInMath
extends Function {
    private static final long serialVersionUID = -8092338695602573652L;
    protected MathFunc m_func = MathFunc.ABS;

    public BuiltInMath(MathFunc mathFunc) {
        this.m_func = mathFunc;
        this.m_functionName = this.m_func.toString();
    }

    @Override
    public void setParameterDefs(ArrayList<Attribute> arrayList) throws Exception {
        this.m_parameterDefs = arrayList;
        if (!this.m_func.legalNumParams(this.m_parameterDefs.size())) {
            throw new Exception("[BuiltInMath] illegal number of parameters for function: " + this.m_functionName);
        }
    }

    @Override
    public Attribute getOutputDef() {
        return new Attribute("BuiltInMathResult:" + this.m_func.toString());
    }

    @Override
    public String[] getParameterNames() {
        return this.m_func.getParameterNames();
    }

    @Override
    public double getResult(double[] dArray) throws Exception {
        if (this.m_parameterDefs == null) {
            throw new Exception("[BuiltInMath] incoming parameter structure has not been set");
        }
        if (!this.m_func.legalNumParams(dArray.length)) {
            throw new Exception("[BuiltInMath] wrong number of parameters!");
        }
        double d = this.m_func.eval(dArray);
        return d;
    }

    @Override
    public String toString() {
        String string = this.m_func.toString() + "(";
        for (int i = 0; i < this.m_parameterDefs.size(); ++i) {
            string = string + ((Attribute)this.m_parameterDefs.get(i)).name();
            string = i != this.m_parameterDefs.size() - 1 ? string + ", " : string + ")";
        }
        return string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MathFunc {
        MIN("min"){

            double eval(double[] dArray) {
                return dArray[Utils.minIndex(dArray)];
            }

            boolean legalNumParams(int n) {
                return n > 0;
            }

            String[] getParameterNames() {
                return null;
            }
        }
        ,
        MAX("max"){

            double eval(double[] dArray) {
                return dArray[Utils.maxIndex(dArray)];
            }

            boolean legalNumParams(int n) {
                return n > 0;
            }

            String[] getParameterNames() {
                return null;
            }
        }
        ,
        SUM("sum"){

            double eval(double[] dArray) {
                return Utils.sum(dArray);
            }

            boolean legalNumParams(int n) {
                return n > 0;
            }

            String[] getParameterNames() {
                return null;
            }
        }
        ,
        AVG("avg"){

            double eval(double[] dArray) {
                return Utils.mean(dArray);
            }

            boolean legalNumParams(int n) {
                return n > 0;
            }

            String[] getParameterNames() {
                return null;
            }
        }
        ,
        LOG10("log10"){

            double eval(double[] dArray) {
                return Math.log10(dArray[0]);
            }

            boolean legalNumParams(int n) {
                return n == 1;
            }

            String[] getParameterNames() {
                return new String[]{"A"};
            }
        }
        ,
        LN("ln"){

            double eval(double[] dArray) {
                return Math.log(dArray[0]);
            }

            boolean legalNumParams(int n) {
                return n == 1;
            }

            String[] getParameterNames() {
                return new String[]{"A"};
            }
        }
        ,
        SQRT("sqrt"){

            double eval(double[] dArray) {
                return Math.sqrt(dArray[0]);
            }

            boolean legalNumParams(int n) {
                return n == 1;
            }

            String[] getParameterNames() {
                return new String[]{"A"};
            }
        }
        ,
        ABS("abs"){

            double eval(double[] dArray) {
                return Math.abs(dArray[0]);
            }

            boolean legalNumParams(int n) {
                return n == 1;
            }

            String[] getParameterNames() {
                return new String[]{"A"};
            }
        }
        ,
        EXP("exp"){

            double eval(double[] dArray) {
                return Math.exp(dArray[0]);
            }

            boolean legalNumParams(int n) {
                return n == 1;
            }

            String[] getParameterNames() {
                return new String[]{"A"};
            }
        }
        ,
        POW("pow"){

            double eval(double[] dArray) {
                return Math.pow(dArray[0], dArray[1]);
            }

            boolean legalNumParams(int n) {
                return n == 2;
            }

            String[] getParameterNames() {
                return new String[]{"A", "B"};
            }
        }
        ,
        THRESHOLD("threshold"){

            double eval(double[] dArray) {
                if (dArray[0] > dArray[1]) {
                    return 1.0;
                }
                return 0.0;
            }

            boolean legalNumParams(int n) {
                return n == 2;
            }

            String[] getParameterNames() {
                return new String[]{"A", "B"};
            }
        }
        ,
        FLOOR("floor"){

            double eval(double[] dArray) {
                return Math.floor(dArray[0]);
            }

            boolean legalNumParams(int n) {
                return n == 1;
            }

            String[] getParameterNames() {
                return new String[]{"A"};
            }
        }
        ,
        CEIL("ceil"){

            double eval(double[] dArray) {
                return Math.ceil(dArray[0]);
            }

            boolean legalNumParams(int n) {
                return n == 1;
            }

            String[] getParameterNames() {
                return new String[]{"A"};
            }
        }
        ,
        ROUND("round"){

            double eval(double[] dArray) {
                return Math.round(dArray[0]);
            }

            boolean legalNumParams(int n) {
                return n == 1;
            }

            String[] getParameterNames() {
                return new String[]{"A"};
            }
        };

        private final String m_stringVal;

        abstract double eval(double[] var1);

        abstract boolean legalNumParams(int var1);

        abstract String[] getParameterNames();

        private MathFunc(String string2) {
            this.m_stringVal = string2;
        }

        public String toString() {
            return this.m_stringVal;
        }
    }
}

