/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes;

import weka.classifiers.UpdateableClassifier;
import weka.classifiers.bayes.NaiveBayesMultinomial;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class NaiveBayesMultinomialUpdateable
extends NaiveBayesMultinomial
implements UpdateableClassifier {
    private static final long serialVersionUID = -7204398796974263186L;
    protected double[] m_wordsPerClass;

    public String globalInfo() {
        return super.globalInfo() + "\n\n" + "Incremental version of the algorithm.";
    }

    public void buildClassifier(Instances instances) throws Exception {
        int n;
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.m_headerInfo = new Instances(instances, 0);
        this.m_numClasses = instances.numClasses();
        this.m_numAttributes = instances.numAttributes();
        this.m_probOfWordGivenClass = new double[this.m_numClasses][];
        this.m_wordsPerClass = new double[this.m_numClasses];
        this.m_probOfClass = new double[this.m_numClasses];
        double d = 1.0;
        for (n = 0; n < this.m_numClasses; ++n) {
            this.m_probOfWordGivenClass[n] = new double[this.m_numAttributes];
            this.m_probOfClass[n] = d;
            this.m_wordsPerClass[n] = d * (double)this.m_numAttributes;
            for (int i = 0; i < this.m_numAttributes; ++i) {
                this.m_probOfWordGivenClass[n][i] = d;
            }
        }
        for (n = 0; n < instances.numInstances(); ++n) {
            this.updateClassifier(instances.instance(n));
        }
    }

    public void updateClassifier(Instance instance) throws Exception {
        int n;
        int n2 = n = (int)instance.value(instance.classIndex());
        this.m_probOfClass[n2] = this.m_probOfClass[n2] + instance.weight();
        for (int i = 0; i < instance.numValues(); ++i) {
            if (instance.index(i) == instance.classIndex() || instance.isMissing(i)) continue;
            double d = instance.valueSparse(i) * instance.weight();
            if (d < 0.0) {
                throw new Exception("Numeric attribute values must all be greater or equal to zero.");
            }
            int n3 = n;
            this.m_wordsPerClass[n3] = this.m_wordsPerClass[n3] + d;
            double[] dArray = this.m_probOfWordGivenClass[n];
            int n4 = instance.index(i);
            dArray[n4] = dArray[n4] + d;
        }
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        int n;
        double[] dArray = new double[this.m_numClasses];
        double[] dArray2 = new double[this.m_numClasses];
        for (int i = 0; i < this.m_numClasses; ++i) {
            int n2 = i;
            dArray2[n2] = dArray2[n2] + Math.log(this.m_probOfClass[i]);
            int n3 = 0;
            for (n = 0; n < instance.numValues(); ++n) {
                if (instance.index(n) == instance.classIndex()) continue;
                double d = instance.valueSparse(n);
                n3 = (int)((double)n3 + d);
                int n4 = i;
                dArray2[n4] = dArray2[n4] + d * Math.log(this.m_probOfWordGivenClass[i][instance.index(n)]);
            }
            int n5 = i;
            dArray2[n5] = dArray2[n5] - (double)n3 * Math.log(this.m_wordsPerClass[i]);
        }
        double d = dArray2[Utils.maxIndex(dArray2)];
        for (n = 0; n < this.m_numClasses; ++n) {
            dArray[n] = Math.exp(dArray2[n] - d);
        }
        Utils.normalize(dArray);
        return dArray;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("The independent probability of a class\n");
        stringBuffer.append("--------------------------------------\n");
        for (n = 0; n < this.m_numClasses; ++n) {
            stringBuffer.append(this.m_headerInfo.classAttribute().value(n)).append("\t").append(Double.toString(this.m_probOfClass[n])).append("\n");
        }
        stringBuffer.append("\nThe probability of a word given the class\n");
        stringBuffer.append("-----------------------------------------\n\t");
        for (n = 0; n < this.m_numClasses; ++n) {
            stringBuffer.append(this.m_headerInfo.classAttribute().value(n)).append("\t");
        }
        stringBuffer.append("\n");
        for (n = 0; n < this.m_numAttributes; ++n) {
            stringBuffer.append(this.m_headerInfo.attribute(n).name()).append("\t");
            for (int i = 0; i < this.m_numClasses; ++i) {
                stringBuffer.append(Double.toString(Math.exp(this.m_probOfWordGivenClass[i][n]))).append("\t");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.3 $");
    }

    public static void main(String[] stringArray) {
        NaiveBayesMultinomialUpdateable.runClassifier(new NaiveBayesMultinomialUpdateable(), stringArray);
    }
}

