/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees;

import java.util.Enumeration;
import weka.classifiers.Classifier;
import weka.classifiers.Sourcable;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.NoSupportForMissingValuesException;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class Id3
extends Classifier
implements TechnicalInformationHandler,
Sourcable {
    static final long serialVersionUID = -2693678647096322561L;
    private Id3[] m_Successors;
    private Attribute m_Attribute;
    private double m_ClassValue;
    private double[] m_Distribution;
    private Attribute m_ClassAttribute;

    public String globalInfo() {
        return "Class for constructing an unpruned decision tree based on the ID3 algorithm. Can only deal with nominal attributes. No missing values allowed. Empty leaves may result in unclassified instances. For more information see: \n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "R. Quinlan");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1986");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Induction of decision trees");
        technicalInformation.setValue(TechnicalInformation.Field.JOURNAL, "Machine Learning");
        technicalInformation.setValue(TechnicalInformation.Field.VOLUME, "1");
        technicalInformation.setValue(TechnicalInformation.Field.NUMBER, "1");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "81-106");
        return technicalInformation;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.setMinimumNumberInstances(0);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.makeTree(instances);
    }

    private void makeTree(Instances instances) throws Exception {
        Object object;
        if (instances.numInstances() == 0) {
            this.m_Attribute = null;
            this.m_ClassValue = Instance.missingValue();
            this.m_Distribution = new double[instances.numClasses()];
            return;
        }
        double[] dArray = new double[instances.numAttributes()];
        Enumeration enumeration = instances.enumerateAttributes();
        while (enumeration.hasMoreElements()) {
            object = (Instances[])enumeration.nextElement();
            dArray[((Attribute)object).index()] = this.computeInfoGain(instances, (Attribute)object);
        }
        this.m_Attribute = instances.attribute(Utils.maxIndex(dArray));
        if (Utils.eq(dArray[this.m_Attribute.index()], 0.0)) {
            this.m_Attribute = null;
            this.m_Distribution = new double[instances.numClasses()];
            object = instances.enumerateInstances();
            while (object.hasMoreElements()) {
                Instance instance = (Instance)object.nextElement();
                int n = (int)instance.classValue();
                this.m_Distribution[n] = this.m_Distribution[n] + 1.0;
            }
            Utils.normalize(this.m_Distribution);
            this.m_ClassValue = Utils.maxIndex(this.m_Distribution);
            this.m_ClassAttribute = instances.classAttribute();
        } else {
            object = this.splitData(instances, this.m_Attribute);
            this.m_Successors = new Id3[this.m_Attribute.numValues()];
            for (int i = 0; i < this.m_Attribute.numValues(); ++i) {
                this.m_Successors[i] = new Id3();
                this.m_Successors[i].makeTree((Instances)object[i]);
            }
        }
    }

    public double classifyInstance(Instance instance) throws NoSupportForMissingValuesException {
        if (instance.hasMissingValue()) {
            throw new NoSupportForMissingValuesException("Id3: no missing values, please.");
        }
        if (this.m_Attribute == null) {
            return this.m_ClassValue;
        }
        return this.m_Successors[(int)instance.value(this.m_Attribute)].classifyInstance(instance);
    }

    public double[] distributionForInstance(Instance instance) throws NoSupportForMissingValuesException {
        if (instance.hasMissingValue()) {
            throw new NoSupportForMissingValuesException("Id3: no missing values, please.");
        }
        if (this.m_Attribute == null) {
            return this.m_Distribution;
        }
        return this.m_Successors[(int)instance.value(this.m_Attribute)].distributionForInstance(instance);
    }

    public String toString() {
        if (this.m_Distribution == null && this.m_Successors == null) {
            return "Id3: No model built yet.";
        }
        return "Id3\n\n" + this.toString(0);
    }

    private double computeInfoGain(Instances instances, Attribute attribute) throws Exception {
        double d = this.computeEntropy(instances);
        Instances[] instancesArray = this.splitData(instances, attribute);
        for (int i = 0; i < attribute.numValues(); ++i) {
            if (instancesArray[i].numInstances() <= 0) continue;
            d -= (double)instancesArray[i].numInstances() / (double)instances.numInstances() * this.computeEntropy(instancesArray[i]);
        }
        return d;
    }

    private double computeEntropy(Instances instances) throws Exception {
        double[] dArray = new double[instances.numClasses()];
        Enumeration enumeration = instances.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            Instance instance = (Instance)enumeration.nextElement();
            int n = (int)instance.classValue();
            dArray[n] = dArray[n] + 1.0;
        }
        double d = 0.0;
        for (int i = 0; i < instances.numClasses(); ++i) {
            if (!(dArray[i] > 0.0)) continue;
            d -= dArray[i] * Utils.log2(dArray[i]);
        }
        return (d /= (double)instances.numInstances()) + Utils.log2(instances.numInstances());
    }

    private Instances[] splitData(Instances instances, Attribute attribute) {
        Instances[] instancesArray = new Instances[attribute.numValues()];
        for (int i = 0; i < attribute.numValues(); ++i) {
            instancesArray[i] = new Instances(instances, instances.numInstances());
        }
        Enumeration enumeration = instances.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            Instance instance = (Instance)enumeration.nextElement();
            instancesArray[(int)instance.value(attribute)].add(instance);
        }
        for (int i = 0; i < instancesArray.length; ++i) {
            instancesArray[i].compactify();
        }
        return instancesArray;
    }

    private String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_Attribute == null) {
            if (Instance.isMissingValue(this.m_ClassValue)) {
                stringBuffer.append(": null");
            } else {
                stringBuffer.append(": " + this.m_ClassAttribute.value((int)this.m_ClassValue));
            }
        } else {
            for (int i = 0; i < this.m_Attribute.numValues(); ++i) {
                stringBuffer.append("\n");
                for (int j = 0; j < n; ++j) {
                    stringBuffer.append("|  ");
                }
                stringBuffer.append(this.m_Attribute.name() + " = " + this.m_Attribute.value(i));
                stringBuffer.append(this.m_Successors[i].toString(n + 1));
            }
        }
        return stringBuffer.toString();
    }

    protected int toSource(int n, StringBuffer stringBuffer) throws Exception {
        int n2;
        stringBuffer.append("\n");
        stringBuffer.append("  protected static double node" + n + "(Object[] i) {\n");
        if (this.m_Attribute == null) {
            n2 = n;
            if (Double.isNaN(this.m_ClassValue)) {
                stringBuffer.append("    return Double.NaN;");
            } else {
                stringBuffer.append("    return " + this.m_ClassValue + ";");
            }
            if (this.m_ClassAttribute != null) {
                stringBuffer.append(" // " + this.m_ClassAttribute.value((int)this.m_ClassValue));
            }
            stringBuffer.append("\n");
            stringBuffer.append("  }\n");
        } else {
            int n3;
            stringBuffer.append("    // " + this.m_Attribute.name() + "\n");
            StringBuffer[] stringBufferArray = new StringBuffer[this.m_Attribute.numValues()];
            int n4 = n;
            for (n3 = 0; n3 < this.m_Attribute.numValues(); ++n3) {
                ++n4;
                stringBuffer.append("    ");
                if (n3 > 0) {
                    stringBuffer.append("else ");
                }
                stringBuffer.append("if (((String) i[" + this.m_Attribute.index() + "]).equals(\"" + this.m_Attribute.value(n3) + "\"))\n");
                stringBuffer.append("      return node" + n4 + "(i);\n");
                stringBufferArray[n3] = new StringBuffer();
                n4 = this.m_Successors[n3].toSource(n4, stringBufferArray[n3]);
            }
            stringBuffer.append("    else\n");
            stringBuffer.append("      throw new IllegalArgumentException(\"Value '\" + i[" + this.m_Attribute.index() + "] + \"' is not allowed!\");\n");
            stringBuffer.append("  }\n");
            for (n3 = 0; n3 < this.m_Attribute.numValues(); ++n3) {
                stringBuffer.append(stringBufferArray[n3].toString());
            }
            stringBufferArray = null;
            n2 = n4;
        }
        return n2;
    }

    public String toSource(String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class " + string + " {\n");
        stringBuffer.append("  public static double classify(Object[] i) {\n");
        int n = 0;
        stringBuffer.append("    return node" + n + "(i);\n");
        stringBuffer.append("  }\n");
        this.toSource(n, stringBuffer);
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.23 $");
    }

    public static void main(String[] stringArray) {
        Id3.runClassifier(new Id3(), stringArray);
    }
}

